/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobAttachmentSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobAttachmentSettings> {
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3BucketName").getter(JobAttachmentSettings.getter(JobAttachmentSettings::s3BucketName)).setter(JobAttachmentSettings.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()}).build();
    private static final SdkField<String> ROOT_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootPrefix").getter(JobAttachmentSettings.getter(JobAttachmentSettings::rootPrefix)).setter(JobAttachmentSettings.setter(Builder::rootPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_NAME_FIELD, ROOT_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3BucketName", S3_BUCKET_NAME_FIELD);
            this.put("rootPrefix", ROOT_PREFIX_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s3BucketName;
    private final String rootPrefix;

    private JobAttachmentSettings(BuilderImpl builder) {
        this.s3BucketName = builder.s3BucketName;
        this.rootPrefix = builder.rootPrefix;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String rootPrefix() {
        return this.rootPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobAttachmentSettings)) {
            return false;
        }
        JobAttachmentSettings other = (JobAttachmentSettings)obj;
        return Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.rootPrefix(), other.rootPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"JobAttachmentSettings").add("S3BucketName", (Object)this.s3BucketName()).add("RootPrefix", (Object)this.rootPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "rootPrefix": {
                return Optional.ofNullable(clazz.cast(this.rootPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobAttachmentSettings, T> g) {
        return obj -> g.apply((JobAttachmentSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3BucketName;
        private String rootPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(JobAttachmentSettings model) {
            this.s3BucketName(model.s3BucketName);
            this.rootPrefix(model.rootPrefix);
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getRootPrefix() {
            return this.rootPrefix;
        }

        public final void setRootPrefix(String rootPrefix) {
            this.rootPrefix = rootPrefix;
        }

        @Override
        public final Builder rootPrefix(String rootPrefix) {
            this.rootPrefix = rootPrefix;
            return this;
        }

        public JobAttachmentSettings build() {
            return new JobAttachmentSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobAttachmentSettings> {
        public Builder s3BucketName(String var1);

        public Builder rootPrefix(String var1);
    }
}

