/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.BudgetSchedule;
import software.amazon.awssdk.services.deadline.model.BudgetStatus;
import software.amazon.awssdk.services.deadline.model.ConsumedUsages;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.ResponseBudgetAction;
import software.amazon.awssdk.services.deadline.model.ResponseBudgetActionListCopier;
import software.amazon.awssdk.services.deadline.model.UsageTrackingResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBudgetResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetBudgetResponse> {
    private static final SdkField<String> BUDGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("budgetId").getter(GetBudgetResponse.getter(GetBudgetResponse::budgetId)).setter(GetBudgetResponse.setter(Builder::budgetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetId").build()}).build();
    private static final SdkField<UsageTrackingResource> USAGE_TRACKING_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usageTrackingResource").getter(GetBudgetResponse.getter(GetBudgetResponse::usageTrackingResource)).setter(GetBudgetResponse.setter(Builder::usageTrackingResource)).constructor(UsageTrackingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTrackingResource").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetBudgetResponse.getter(GetBudgetResponse::statusAsString)).setter(GetBudgetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(GetBudgetResponse.getter(GetBudgetResponse::displayName)).setter(GetBudgetResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetBudgetResponse.getter(GetBudgetResponse::description)).setter(GetBudgetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("approximateDollarLimit").getter(GetBudgetResponse.getter(GetBudgetResponse::approximateDollarLimit)).setter(GetBudgetResponse.setter(Builder::approximateDollarLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build()}).build();
    private static final SdkField<ConsumedUsages> USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usages").getter(GetBudgetResponse.getter(GetBudgetResponse::usages)).setter(GetBudgetResponse.setter(Builder::usages)).constructor(ConsumedUsages::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usages").build()}).build();
    private static final SdkField<List<ResponseBudgetAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(GetBudgetResponse.getter(GetBudgetResponse::actions)).setter(GetBudgetResponse.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponseBudgetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BudgetSchedule> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(GetBudgetResponse.getter(GetBudgetResponse::schedule)).setter(GetBudgetResponse.setter(Builder::schedule)).constructor(BudgetSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetBudgetResponse.getter(GetBudgetResponse::createdBy)).setter(GetBudgetResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetBudgetResponse.getter(GetBudgetResponse::createdAt)).setter(GetBudgetResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(GetBudgetResponse.getter(GetBudgetResponse::updatedBy)).setter(GetBudgetResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetBudgetResponse.getter(GetBudgetResponse::updatedAt)).setter(GetBudgetResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> QUEUE_STOPPED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("queueStoppedAt").getter(GetBudgetResponse.getter(GetBudgetResponse::queueStoppedAt)).setter(GetBudgetResponse.setter(Builder::queueStoppedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueStoppedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_ID_FIELD, USAGE_TRACKING_RESOURCE_FIELD, STATUS_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, APPROXIMATE_DOLLAR_LIMIT_FIELD, USAGES_FIELD, ACTIONS_FIELD, SCHEDULE_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, UPDATED_BY_FIELD, UPDATED_AT_FIELD, QUEUE_STOPPED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("budgetId", BUDGET_ID_FIELD);
            this.put("usageTrackingResource", USAGE_TRACKING_RESOURCE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("displayName", DISPLAY_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("approximateDollarLimit", APPROXIMATE_DOLLAR_LIMIT_FIELD);
            this.put("usages", USAGES_FIELD);
            this.put("actions", ACTIONS_FIELD);
            this.put("schedule", SCHEDULE_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("queueStoppedAt", QUEUE_STOPPED_AT_FIELD);
        }
    });
    private final String budgetId;
    private final UsageTrackingResource usageTrackingResource;
    private final String status;
    private final String displayName;
    private final String description;
    private final Float approximateDollarLimit;
    private final ConsumedUsages usages;
    private final List<ResponseBudgetAction> actions;
    private final BudgetSchedule schedule;
    private final String createdBy;
    private final Instant createdAt;
    private final String updatedBy;
    private final Instant updatedAt;
    private final Instant queueStoppedAt;

    private GetBudgetResponse(BuilderImpl builder) {
        super(builder);
        this.budgetId = builder.budgetId;
        this.usageTrackingResource = builder.usageTrackingResource;
        this.status = builder.status;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.usages = builder.usages;
        this.actions = builder.actions;
        this.schedule = builder.schedule;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.updatedBy = builder.updatedBy;
        this.updatedAt = builder.updatedAt;
        this.queueStoppedAt = builder.queueStoppedAt;
    }

    public final String budgetId() {
        return this.budgetId;
    }

    public final UsageTrackingResource usageTrackingResource() {
        return this.usageTrackingResource;
    }

    public final BudgetStatus status() {
        return BudgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final Float approximateDollarLimit() {
        return this.approximateDollarLimit;
    }

    public final ConsumedUsages usages() {
        return this.usages;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<ResponseBudgetAction> actions() {
        return this.actions;
    }

    public final BudgetSchedule schedule() {
        return this.schedule;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant queueStoppedAt() {
        return this.queueStoppedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTrackingResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.usages());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueStoppedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBudgetResponse)) {
            return false;
        }
        GetBudgetResponse other = (GetBudgetResponse)((Object)obj);
        return Objects.equals(this.budgetId(), other.budgetId()) && Objects.equals(this.usageTrackingResource(), other.usageTrackingResource()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.approximateDollarLimit(), other.approximateDollarLimit()) && Objects.equals(this.usages(), other.usages()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.queueStoppedAt(), other.queueStoppedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetBudgetResponse").add("BudgetId", (Object)this.budgetId()).add("UsageTrackingResource", (Object)this.usageTrackingResource()).add("Status", (Object)this.statusAsString()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ApproximateDollarLimit", (Object)this.approximateDollarLimit()).add("Usages", (Object)this.usages()).add("Actions", this.hasActions() ? this.actions() : null).add("Schedule", (Object)this.schedule()).add("CreatedBy", (Object)this.createdBy()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedBy", (Object)this.updatedBy()).add("UpdatedAt", (Object)this.updatedAt()).add("QueueStoppedAt", (Object)this.queueStoppedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "budgetId": {
                return Optional.ofNullable(clazz.cast(this.budgetId()));
            }
            case "usageTrackingResource": {
                return Optional.ofNullable(clazz.cast(this.usageTrackingResource()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "approximateDollarLimit": {
                return Optional.ofNullable(clazz.cast(this.approximateDollarLimit()));
            }
            case "usages": {
                return Optional.ofNullable(clazz.cast(this.usages()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "queueStoppedAt": {
                return Optional.ofNullable(clazz.cast(this.queueStoppedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetBudgetResponse, T> g) {
        return obj -> g.apply((GetBudgetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String budgetId;
        private UsageTrackingResource usageTrackingResource;
        private String status;
        private String displayName;
        private String description;
        private Float approximateDollarLimit;
        private ConsumedUsages usages;
        private List<ResponseBudgetAction> actions = DefaultSdkAutoConstructList.getInstance();
        private BudgetSchedule schedule;
        private String createdBy;
        private Instant createdAt;
        private String updatedBy;
        private Instant updatedAt;
        private Instant queueStoppedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBudgetResponse model) {
            super(model);
            this.budgetId(model.budgetId);
            this.usageTrackingResource(model.usageTrackingResource);
            this.status(model.status);
            this.displayName(model.displayName);
            this.description(model.description);
            this.approximateDollarLimit(model.approximateDollarLimit);
            this.usages(model.usages);
            this.actions(model.actions);
            this.schedule(model.schedule);
            this.createdBy(model.createdBy);
            this.createdAt(model.createdAt);
            this.updatedBy(model.updatedBy);
            this.updatedAt(model.updatedAt);
            this.queueStoppedAt(model.queueStoppedAt);
        }

        public final String getBudgetId() {
            return this.budgetId;
        }

        public final void setBudgetId(String budgetId) {
            this.budgetId = budgetId;
        }

        @Override
        public final Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public final UsageTrackingResource.Builder getUsageTrackingResource() {
            return this.usageTrackingResource != null ? this.usageTrackingResource.toBuilder() : null;
        }

        public final void setUsageTrackingResource(UsageTrackingResource.BuilderImpl usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource != null ? usageTrackingResource.build() : null;
        }

        @Override
        public final Builder usageTrackingResource(UsageTrackingResource usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BudgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Float getApproximateDollarLimit() {
            return this.approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final ConsumedUsages.Builder getUsages() {
            return this.usages != null ? this.usages.toBuilder() : null;
        }

        public final void setUsages(ConsumedUsages.BuilderImpl usages) {
            this.usages = usages != null ? usages.build() : null;
        }

        @Override
        public final Builder usages(ConsumedUsages usages) {
            this.usages = usages;
            return this;
        }

        public final List<ResponseBudgetAction.Builder> getActions() {
            List<ResponseBudgetAction.Builder> result = ResponseBudgetActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ResponseBudgetAction.BuilderImpl> actions) {
            this.actions = ResponseBudgetActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ResponseBudgetAction> actions) {
            this.actions = ResponseBudgetActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ResponseBudgetAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ResponseBudgetAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (ResponseBudgetAction)((ResponseBudgetAction.Builder)ResponseBudgetAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BudgetSchedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(BudgetSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(BudgetSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getQueueStoppedAt() {
            return this.queueStoppedAt;
        }

        public final void setQueueStoppedAt(Instant queueStoppedAt) {
            this.queueStoppedAt = queueStoppedAt;
        }

        @Override
        public final Builder queueStoppedAt(Instant queueStoppedAt) {
            this.queueStoppedAt = queueStoppedAt;
            return this;
        }

        @Override
        public GetBudgetResponse build() {
            return new GetBudgetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBudgetResponse> {
        public Builder budgetId(String var1);

        public Builder usageTrackingResource(UsageTrackingResource var1);

        default public Builder usageTrackingResource(Consumer<UsageTrackingResource.Builder> usageTrackingResource) {
            return this.usageTrackingResource((UsageTrackingResource)((UsageTrackingResource.Builder)UsageTrackingResource.builder().applyMutation(usageTrackingResource)).build());
        }

        public Builder status(String var1);

        public Builder status(BudgetStatus var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder approximateDollarLimit(Float var1);

        public Builder usages(ConsumedUsages var1);

        default public Builder usages(Consumer<ConsumedUsages.Builder> usages) {
            return this.usages((ConsumedUsages)((ConsumedUsages.Builder)ConsumedUsages.builder().applyMutation(usages)).build());
        }

        public Builder actions(Collection<ResponseBudgetAction> var1);

        public Builder actions(ResponseBudgetAction ... var1);

        public Builder actions(Consumer<ResponseBudgetAction.Builder> ... var1);

        public Builder schedule(BudgetSchedule var1);

        default public Builder schedule(Consumer<BudgetSchedule.Builder> schedule) {
            return this.schedule((BudgetSchedule)((BudgetSchedule.Builder)BudgetSchedule.builder().applyMutation(schedule)).build());
        }

        public Builder createdBy(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder queueStoppedAt(Instant var1);
    }
}

