/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WindowsUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WindowsUser> {
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("user").getter(WindowsUser.getter(WindowsUser::user)).setter(WindowsUser.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<String> PASSWORD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("passwordArn").getter(WindowsUser.getter(WindowsUser::passwordArn)).setter(WindowsUser.setter(Builder::passwordArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_FIELD, PASSWORD_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String user;
    private final String passwordArn;

    private WindowsUser(BuilderImpl builder) {
        this.user = builder.user;
        this.passwordArn = builder.passwordArn;
    }

    public final String user() {
        return this.user;
    }

    public final String passwordArn() {
        return this.passwordArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowsUser)) {
            return false;
        }
        WindowsUser other = (WindowsUser)obj;
        return Objects.equals(this.user(), other.user()) && Objects.equals(this.passwordArn(), other.passwordArn());
    }

    public final String toString() {
        return ToString.builder((String)"WindowsUser").add("User", (Object)this.user()).add("PasswordArn", (Object)this.passwordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "passwordArn": {
                return Optional.ofNullable(clazz.cast(this.passwordArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WindowsUser, T> g) {
        return obj -> g.apply((WindowsUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String user;
        private String passwordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowsUser model) {
            this.user(model.user);
            this.passwordArn(model.passwordArn);
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getPasswordArn() {
            return this.passwordArn;
        }

        public final void setPasswordArn(String passwordArn) {
            this.passwordArn = passwordArn;
        }

        @Override
        public final Builder passwordArn(String passwordArn) {
            this.passwordArn = passwordArn;
            return this;
        }

        public WindowsUser build() {
            return new WindowsUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WindowsUser> {
        public Builder user(String var1);

        public Builder passwordArn(String var1);
    }
}

