/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.LogOptionsCopier;
import software.amazon.awssdk.services.deadline.model.LogParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfiguration> {
    private static final SdkField<String> LOG_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logDriver").getter(LogConfiguration.getter(LogConfiguration::logDriver)).setter(LogConfiguration.setter(Builder::logDriver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDriver").build()}).build();
    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("options").getter(LogConfiguration.getter(LogConfiguration::options)).setter(LogConfiguration.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(LogConfiguration.getter(LogConfiguration::parameters)).setter(LogConfiguration.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(LogConfiguration.getter(LogConfiguration::error)).setter(LogConfiguration.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_DRIVER_FIELD, OPTIONS_FIELD, PARAMETERS_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logDriver;
    private final Map<String, String> options;
    private final Map<String, String> parameters;
    private final String error;

    private LogConfiguration(BuilderImpl builder) {
        this.logDriver = builder.logDriver;
        this.options = builder.options;
        this.parameters = builder.parameters;
        this.error = builder.error;
    }

    public final String logDriver() {
        return this.logDriver;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> options() {
        return this.options;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> parameters() {
        return this.parameters;
    }

    public final String error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logDriver());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        return Objects.equals(this.logDriver(), other.logDriver()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfiguration").add("LogDriver", (Object)this.logDriver()).add("Options", this.hasOptions() ? this.options() : null).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logDriver": {
                return Optional.ofNullable(clazz.cast(this.logDriver()));
            }
            case "options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logDriver;
        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String error;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            this.logDriver(model.logDriver);
            this.options(model.options);
            this.parameters(model.parameters);
            this.error(model.error);
        }

        public final String getLogDriver() {
            return this.logDriver;
        }

        public final void setLogDriver(String logDriver) {
            this.logDriver = logDriver;
        }

        @Override
        public final Builder logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        public final Map<String, String> getOptions() {
            if (this.options instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = LogOptionsCopier.copy(options);
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = LogOptionsCopier.copy(options);
            return this;
        }

        public final Map<String, String> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = LogParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = LogParametersCopier.copy(parameters);
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfiguration> {
        public Builder logDriver(String var1);

        public Builder options(Map<String, String> var1);

        public Builder parameters(Map<String, String> var1);

        public Builder error(String var1);
    }
}

