/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.BudgetSummariesCopier;
import software.amazon.awssdk.services.deadline.model.BudgetSummary;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBudgetsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListBudgetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBudgetsResponse.getter(ListBudgetsResponse::nextToken)).setter(ListBudgetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<BudgetSummary>> BUDGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("budgets").getter(ListBudgetsResponse.getter(ListBudgetsResponse::budgets)).setter(ListBudgetsResponse.setter(Builder::budgets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BudgetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, BUDGETS_FIELD));
    private final String nextToken;
    private final List<BudgetSummary> budgets;

    private ListBudgetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.budgets = builder.budgets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBudgets() {
        return this.budgets != null && !(this.budgets instanceof SdkAutoConstructList);
    }

    public final List<BudgetSummary> budgets() {
        return this.budgets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBudgets() ? this.budgets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBudgetsResponse)) {
            return false;
        }
        ListBudgetsResponse other = (ListBudgetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasBudgets() == other.hasBudgets() && Objects.equals(this.budgets(), other.budgets());
    }

    public final String toString() {
        return ToString.builder((String)"ListBudgetsResponse").add("NextToken", (Object)this.nextToken()).add("Budgets", this.hasBudgets() ? this.budgets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "budgets": {
                return Optional.ofNullable(clazz.cast(this.budgets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBudgetsResponse, T> g) {
        return obj -> g.apply((ListBudgetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<BudgetSummary> budgets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBudgetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.budgets(model.budgets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BudgetSummary.Builder> getBudgets() {
            List<BudgetSummary.Builder> result = BudgetSummariesCopier.copyToBuilder(this.budgets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBudgets(Collection<BudgetSummary.BuilderImpl> budgets) {
            this.budgets = BudgetSummariesCopier.copyFromBuilder(budgets);
        }

        @Override
        public final Builder budgets(Collection<BudgetSummary> budgets) {
            this.budgets = BudgetSummariesCopier.copy(budgets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(BudgetSummary ... budgets) {
            this.budgets(Arrays.asList(budgets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder budgets(Consumer<BudgetSummary.Builder> ... budgets) {
            this.budgets(Stream.of(budgets).map(c -> (BudgetSummary)((BudgetSummary.Builder)BudgetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBudgetsResponse build() {
            return new ListBudgetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBudgetsResponse> {
        public Builder nextToken(String var1);

        public Builder budgets(Collection<BudgetSummary> var1);

        public Builder budgets(BudgetSummary ... var1);

        public Builder budgets(Consumer<BudgetSummary.Builder> ... var1);
    }
}

