/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.SessionActionSummariesCopier;
import software.amazon.awssdk.services.deadline.model.SessionActionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSessionActionsResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListSessionActionsResponse> {
    private static final SdkField<List<SessionActionSummary>> SESSION_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessionActions").getter(ListSessionActionsResponse.getter(ListSessionActionsResponse::sessionActions)).setter(ListSessionActionsResponse.setter(Builder::sessionActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SessionActionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSessionActionsResponse.getter(ListSessionActionsResponse::nextToken)).setter(ListSessionActionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ACTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SessionActionSummary> sessionActions;
    private final String nextToken;

    private ListSessionActionsResponse(BuilderImpl builder) {
        super(builder);
        this.sessionActions = builder.sessionActions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSessionActions() {
        return this.sessionActions != null && !(this.sessionActions instanceof SdkAutoConstructList);
    }

    public final List<SessionActionSummary> sessionActions() {
        return this.sessionActions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessionActions() ? this.sessionActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionActionsResponse)) {
            return false;
        }
        ListSessionActionsResponse other = (ListSessionActionsResponse)((Object)obj);
        return this.hasSessionActions() == other.hasSessionActions() && Objects.equals(this.sessionActions(), other.sessionActions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSessionActionsResponse").add("SessionActions", this.hasSessionActions() ? this.sessionActions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionActions": {
                return Optional.ofNullable(clazz.cast(this.sessionActions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSessionActionsResponse, T> g) {
        return obj -> g.apply((ListSessionActionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private List<SessionActionSummary> sessionActions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionActionsResponse model) {
            super(model);
            this.sessionActions(model.sessionActions);
            this.nextToken(model.nextToken);
        }

        public final List<SessionActionSummary.Builder> getSessionActions() {
            List<SessionActionSummary.Builder> result = SessionActionSummariesCopier.copyToBuilder(this.sessionActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessionActions(Collection<SessionActionSummary.BuilderImpl> sessionActions) {
            this.sessionActions = SessionActionSummariesCopier.copyFromBuilder(sessionActions);
        }

        @Override
        public final Builder sessionActions(Collection<SessionActionSummary> sessionActions) {
            this.sessionActions = SessionActionSummariesCopier.copy(sessionActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionActions(SessionActionSummary ... sessionActions) {
            this.sessionActions(Arrays.asList(sessionActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessionActions(Consumer<SessionActionSummary.Builder> ... sessionActions) {
            this.sessionActions(Stream.of(sessionActions).map(c -> (SessionActionSummary)((SessionActionSummary.Builder)SessionActionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSessionActionsResponse build() {
            return new ListSessionActionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSessionActionsResponse> {
        public Builder sessionActions(Collection<SessionActionSummary> var1);

        public Builder sessionActions(SessionActionSummary ... var1);

        public Builder sessionActions(Consumer<SessionActionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

