/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.BudgetSummary;
import software.amazon.awssdk.services.deadline.model.ListBudgetsRequest;
import software.amazon.awssdk.services.deadline.model.ListBudgetsResponse;

public class ListBudgetsPublisher
implements SdkPublisher<ListBudgetsResponse> {
    private final DeadlineAsyncClient client;
    private final ListBudgetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBudgetsPublisher(DeadlineAsyncClient client, ListBudgetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBudgetsPublisher(DeadlineAsyncClient client, ListBudgetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBudgetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBudgetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BudgetSummary> budgets() {
        Function<ListBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.budgets() != null) {
                return response.budgets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBudgetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBudgetsResponseFetcher
    implements AsyncPageFetcher<ListBudgetsResponse> {
        private ListBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(ListBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBudgetsResponse> nextPage(ListBudgetsResponse previousPage) {
            if (previousPage == null) {
                return ListBudgetsPublisher.this.client.listBudgets(ListBudgetsPublisher.this.firstRequest);
            }
            return ListBudgetsPublisher.this.client.listBudgets((ListBudgetsRequest)((Object)ListBudgetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

