/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersRequest;
import software.amazon.awssdk.services.deadline.model.ListQueueMembersResponse;
import software.amazon.awssdk.services.deadline.model.QueueMember;

public class ListQueueMembersPublisher
implements SdkPublisher<ListQueueMembersResponse> {
    private final DeadlineAsyncClient client;
    private final ListQueueMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueueMembersPublisher(DeadlineAsyncClient client, ListQueueMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueueMembersPublisher(DeadlineAsyncClient client, ListQueueMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueueMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueueMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<QueueMember> members() {
        Function<ListQueueMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.members() != null) {
                return response.members().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListQueueMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListQueueMembersResponseFetcher
    implements AsyncPageFetcher<ListQueueMembersResponse> {
        private ListQueueMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListQueueMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueueMembersResponse> nextPage(ListQueueMembersResponse previousPage) {
            if (previousPage == null) {
                return ListQueueMembersPublisher.this.client.listQueueMembers(ListQueueMembersPublisher.this.firstRequest);
            }
            return ListQueueMembersPublisher.this.client.listQueueMembers((ListQueueMembersRequest)((Object)ListQueueMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

