/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.SessionsStatisticsAggregationStatus;
import software.amazon.awssdk.services.deadline.model.Statistics;
import software.amazon.awssdk.services.deadline.model.StatisticsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionsStatisticsAggregationResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetSessionsStatisticsAggregationResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetSessionsStatisticsAggregationResponse.getter(GetSessionsStatisticsAggregationResponse::nextToken)).setter(GetSessionsStatisticsAggregationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<Statistics>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statistics").getter(GetSessionsStatisticsAggregationResponse.getter(GetSessionsStatisticsAggregationResponse::statistics)).setter(GetSessionsStatisticsAggregationResponse.setter(Builder::statistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Statistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSessionsStatisticsAggregationResponse.getter(GetSessionsStatisticsAggregationResponse::statusAsString)).setter(GetSessionsStatisticsAggregationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetSessionsStatisticsAggregationResponse.getter(GetSessionsStatisticsAggregationResponse::statusMessage)).setter(GetSessionsStatisticsAggregationResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, STATISTICS_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private final String nextToken;
    private final List<Statistics> statistics;
    private final String status;
    private final String statusMessage;

    private GetSessionsStatisticsAggregationResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.statistics = builder.statistics;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasStatistics() {
        return this.statistics != null && !(this.statistics instanceof SdkAutoConstructList);
    }

    public final List<Statistics> statistics() {
        return this.statistics;
    }

    public final SessionsStatisticsAggregationStatus status() {
        return SessionsStatisticsAggregationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatistics() ? this.statistics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionsStatisticsAggregationResponse)) {
            return false;
        }
        GetSessionsStatisticsAggregationResponse other = (GetSessionsStatisticsAggregationResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasStatistics() == other.hasStatistics() && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionsStatisticsAggregationResponse").add("NextToken", (Object)this.nextToken()).add("Statistics", this.hasStatistics() ? this.statistics() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionsStatisticsAggregationResponse, T> g) {
        return obj -> g.apply((GetSessionsStatisticsAggregationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Statistics> statistics = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionsStatisticsAggregationResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.statistics(model.statistics);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Statistics.Builder> getStatistics() {
            List<Statistics.Builder> result = StatisticsListCopier.copyToBuilder(this.statistics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatistics(Collection<Statistics.BuilderImpl> statistics) {
            this.statistics = StatisticsListCopier.copyFromBuilder(statistics);
        }

        @Override
        public final Builder statistics(Collection<Statistics> statistics) {
            this.statistics = StatisticsListCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Statistics ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Consumer<Statistics.Builder> ... statistics) {
            this.statistics(Stream.of(statistics).map(c -> (Statistics)((Statistics.Builder)Statistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionsStatisticsAggregationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public GetSessionsStatisticsAggregationResponse build() {
            return new GetSessionsStatisticsAggregationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionsStatisticsAggregationResponse> {
        public Builder nextToken(String var1);

        public Builder statistics(Collection<Statistics> var1);

        public Builder statistics(Statistics ... var1);

        public Builder statistics(Consumer<Statistics.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(SessionsStatisticsAggregationStatus var1);

        public Builder statusMessage(String var1);
    }
}

