/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.EnvironmentDetailsError;
import software.amazon.awssdk.services.deadline.model.JobAttachmentDetailsError;
import software.amazon.awssdk.services.deadline.model.JobDetailsError;
import software.amazon.awssdk.services.deadline.model.StepDetailsError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobEntityError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetJobEntityError> {
    private static final SdkField<EnvironmentDetailsError> ENVIRONMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environmentDetails").getter(GetJobEntityError.getter(GetJobEntityError::environmentDetails)).setter(GetJobEntityError.setter(Builder::environmentDetails)).constructor(EnvironmentDetailsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDetails").build()}).build();
    private static final SdkField<JobAttachmentDetailsError> JOB_ATTACHMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobAttachmentDetails").getter(GetJobEntityError.getter(GetJobEntityError::jobAttachmentDetails)).setter(GetJobEntityError.setter(Builder::jobAttachmentDetails)).constructor(JobAttachmentDetailsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentDetails").build()}).build();
    private static final SdkField<JobDetailsError> JOB_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDetails").getter(GetJobEntityError.getter(GetJobEntityError::jobDetails)).setter(GetJobEntityError.setter(Builder::jobDetails)).constructor(JobDetailsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDetails").build()}).build();
    private static final SdkField<StepDetailsError> STEP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stepDetails").getter(GetJobEntityError.getter(GetJobEntityError::stepDetails)).setter(GetJobEntityError.setter(Builder::stepDetails)).constructor(StepDetailsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_DETAILS_FIELD, JOB_ATTACHMENT_DETAILS_FIELD, JOB_DETAILS_FIELD, STEP_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final EnvironmentDetailsError environmentDetails;
    private final JobAttachmentDetailsError jobAttachmentDetails;
    private final JobDetailsError jobDetails;
    private final StepDetailsError stepDetails;
    private final Type type;

    private GetJobEntityError(BuilderImpl builder) {
        this.environmentDetails = builder.environmentDetails;
        this.jobAttachmentDetails = builder.jobAttachmentDetails;
        this.jobDetails = builder.jobDetails;
        this.stepDetails = builder.stepDetails;
        this.type = builder.type;
    }

    public final EnvironmentDetailsError environmentDetails() {
        return this.environmentDetails;
    }

    public final JobAttachmentDetailsError jobAttachmentDetails() {
        return this.jobAttachmentDetails;
    }

    public final JobDetailsError jobDetails() {
        return this.jobDetails;
    }

    public final StepDetailsError stepDetails() {
        return this.stepDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobAttachmentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobEntityError)) {
            return false;
        }
        GetJobEntityError other = (GetJobEntityError)obj;
        return Objects.equals(this.environmentDetails(), other.environmentDetails()) && Objects.equals(this.jobAttachmentDetails(), other.jobAttachmentDetails()) && Objects.equals(this.jobDetails(), other.jobDetails()) && Objects.equals(this.stepDetails(), other.stepDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetJobEntityError").add("EnvironmentDetails", (Object)this.environmentDetails()).add("JobAttachmentDetails", (Object)this.jobAttachmentDetails()).add("JobDetails", (Object)this.jobDetails()).add("StepDetails", (Object)this.stepDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentDetails": {
                return Optional.ofNullable(clazz.cast(this.environmentDetails()));
            }
            case "jobAttachmentDetails": {
                return Optional.ofNullable(clazz.cast(this.jobAttachmentDetails()));
            }
            case "jobDetails": {
                return Optional.ofNullable(clazz.cast(this.jobDetails()));
            }
            case "stepDetails": {
                return Optional.ofNullable(clazz.cast(this.stepDetails()));
            }
        }
        return Optional.empty();
    }

    public static GetJobEntityError fromEnvironmentDetails(EnvironmentDetailsError environmentDetails) {
        return (GetJobEntityError)GetJobEntityError.builder().environmentDetails(environmentDetails).build();
    }

    public static GetJobEntityError fromEnvironmentDetails(Consumer<EnvironmentDetailsError.Builder> environmentDetails) {
        EnvironmentDetailsError.Builder builder = EnvironmentDetailsError.builder();
        environmentDetails.accept(builder);
        return GetJobEntityError.fromEnvironmentDetails((EnvironmentDetailsError)builder.build());
    }

    public static GetJobEntityError fromJobAttachmentDetails(JobAttachmentDetailsError jobAttachmentDetails) {
        return (GetJobEntityError)GetJobEntityError.builder().jobAttachmentDetails(jobAttachmentDetails).build();
    }

    public static GetJobEntityError fromJobAttachmentDetails(Consumer<JobAttachmentDetailsError.Builder> jobAttachmentDetails) {
        JobAttachmentDetailsError.Builder builder = JobAttachmentDetailsError.builder();
        jobAttachmentDetails.accept(builder);
        return GetJobEntityError.fromJobAttachmentDetails((JobAttachmentDetailsError)builder.build());
    }

    public static GetJobEntityError fromJobDetails(JobDetailsError jobDetails) {
        return (GetJobEntityError)GetJobEntityError.builder().jobDetails(jobDetails).build();
    }

    public static GetJobEntityError fromJobDetails(Consumer<JobDetailsError.Builder> jobDetails) {
        JobDetailsError.Builder builder = JobDetailsError.builder();
        jobDetails.accept(builder);
        return GetJobEntityError.fromJobDetails((JobDetailsError)builder.build());
    }

    public static GetJobEntityError fromStepDetails(StepDetailsError stepDetails) {
        return (GetJobEntityError)GetJobEntityError.builder().stepDetails(stepDetails).build();
    }

    public static GetJobEntityError fromStepDetails(Consumer<StepDetailsError.Builder> stepDetails) {
        StepDetailsError.Builder builder = StepDetailsError.builder();
        stepDetails.accept(builder);
        return GetJobEntityError.fromStepDetails((StepDetailsError)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetJobEntityError, T> g) {
        return obj -> g.apply((GetJobEntityError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ENVIRONMENT_DETAILS,
        JOB_ATTACHMENT_DETAILS,
        JOB_DETAILS,
        STEP_DETAILS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EnvironmentDetailsError environmentDetails;
        private JobAttachmentDetailsError jobAttachmentDetails;
        private JobDetailsError jobDetails;
        private StepDetailsError stepDetails;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobEntityError model) {
            this.environmentDetails(model.environmentDetails);
            this.jobAttachmentDetails(model.jobAttachmentDetails);
            this.jobDetails(model.jobDetails);
            this.stepDetails(model.stepDetails);
        }

        public final EnvironmentDetailsError.Builder getEnvironmentDetails() {
            return this.environmentDetails != null ? this.environmentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDetails(EnvironmentDetailsError.BuilderImpl environmentDetails) {
            EnvironmentDetailsError oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails != null ? environmentDetails.build() : null;
            this.handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
        }

        @Override
        public final Builder environmentDetails(EnvironmentDetailsError environmentDetails) {
            EnvironmentDetailsError oldValue = this.environmentDetails;
            this.environmentDetails = environmentDetails;
            this.handleUnionValueChange(Type.ENVIRONMENT_DETAILS, oldValue, this.environmentDetails);
            return this;
        }

        public final JobAttachmentDetailsError.Builder getJobAttachmentDetails() {
            return this.jobAttachmentDetails != null ? this.jobAttachmentDetails.toBuilder() : null;
        }

        public final void setJobAttachmentDetails(JobAttachmentDetailsError.BuilderImpl jobAttachmentDetails) {
            JobAttachmentDetailsError oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails != null ? jobAttachmentDetails.build() : null;
            this.handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
        }

        @Override
        public final Builder jobAttachmentDetails(JobAttachmentDetailsError jobAttachmentDetails) {
            JobAttachmentDetailsError oldValue = this.jobAttachmentDetails;
            this.jobAttachmentDetails = jobAttachmentDetails;
            this.handleUnionValueChange(Type.JOB_ATTACHMENT_DETAILS, oldValue, this.jobAttachmentDetails);
            return this;
        }

        public final JobDetailsError.Builder getJobDetails() {
            return this.jobDetails != null ? this.jobDetails.toBuilder() : null;
        }

        public final void setJobDetails(JobDetailsError.BuilderImpl jobDetails) {
            JobDetailsError oldValue = this.jobDetails;
            this.jobDetails = jobDetails != null ? jobDetails.build() : null;
            this.handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
        }

        @Override
        public final Builder jobDetails(JobDetailsError jobDetails) {
            JobDetailsError oldValue = this.jobDetails;
            this.jobDetails = jobDetails;
            this.handleUnionValueChange(Type.JOB_DETAILS, oldValue, this.jobDetails);
            return this;
        }

        public final StepDetailsError.Builder getStepDetails() {
            return this.stepDetails != null ? this.stepDetails.toBuilder() : null;
        }

        public final void setStepDetails(StepDetailsError.BuilderImpl stepDetails) {
            StepDetailsError oldValue = this.stepDetails;
            this.stepDetails = stepDetails != null ? stepDetails.build() : null;
            this.handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
        }

        @Override
        public final Builder stepDetails(StepDetailsError stepDetails) {
            StepDetailsError oldValue = this.stepDetails;
            this.stepDetails = stepDetails;
            this.handleUnionValueChange(Type.STEP_DETAILS, oldValue, this.stepDetails);
            return this;
        }

        public GetJobEntityError build() {
            return new GetJobEntityError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetJobEntityError> {
        public Builder environmentDetails(EnvironmentDetailsError var1);

        default public Builder environmentDetails(Consumer<EnvironmentDetailsError.Builder> environmentDetails) {
            return this.environmentDetails((EnvironmentDetailsError)((EnvironmentDetailsError.Builder)EnvironmentDetailsError.builder().applyMutation(environmentDetails)).build());
        }

        public Builder jobAttachmentDetails(JobAttachmentDetailsError var1);

        default public Builder jobAttachmentDetails(Consumer<JobAttachmentDetailsError.Builder> jobAttachmentDetails) {
            return this.jobAttachmentDetails((JobAttachmentDetailsError)((JobAttachmentDetailsError.Builder)JobAttachmentDetailsError.builder().applyMutation(jobAttachmentDetails)).build());
        }

        public Builder jobDetails(JobDetailsError var1);

        default public Builder jobDetails(Consumer<JobDetailsError.Builder> jobDetails) {
            return this.jobDetails((JobDetailsError)((JobDetailsError.Builder)JobDetailsError.builder().applyMutation(jobDetails)).build());
        }

        public Builder stepDetails(StepDetailsError var1);

        default public Builder stepDetails(Consumer<StepDetailsError.Builder> stepDetails) {
            return this.stepDetails((StepDetailsError)((StepDetailsError.Builder)StepDetailsError.builder().applyMutation(stepDetails)).build());
        }
    }
}

