/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.QueueSummariesCopier;
import software.amazon.awssdk.services.deadline.model.QueueSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueuesResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, ListQueuesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListQueuesResponse.getter(ListQueuesResponse::nextToken)).setter(ListQueuesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<QueueSummary>> QUEUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queues").getter(ListQueuesResponse.getter(ListQueuesResponse::queues)).setter(ListQueuesResponse.setter(Builder::queues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueueSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, QUEUES_FIELD));
    private final String nextToken;
    private final List<QueueSummary> queues;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.queues = builder.queues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQueues() {
        return this.queues != null && !(this.queues instanceof SdkAutoConstructList);
    }

    public final List<QueueSummary> queues() {
        return this.queues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueues() ? this.queues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasQueues() == other.hasQueues() && Objects.equals(this.queues(), other.queues());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueuesResponse").add("NextToken", (Object)this.nextToken()).add("Queues", this.hasQueues() ? this.queues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "queues": {
                return Optional.ofNullable(clazz.cast(this.queues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesResponse, T> g) {
        return obj -> g.apply((ListQueuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<QueueSummary> queues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.queues(model.queues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QueueSummary.Builder> getQueues() {
            List<QueueSummary.Builder> result = QueueSummariesCopier.copyToBuilder(this.queues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueues(Collection<QueueSummary.BuilderImpl> queues) {
            this.queues = QueueSummariesCopier.copyFromBuilder(queues);
        }

        @Override
        public final Builder queues(Collection<QueueSummary> queues) {
            this.queues = QueueSummariesCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(QueueSummary ... queues) {
            this.queues(Arrays.asList(queues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Consumer<QueueSummary.Builder> ... queues) {
            this.queues(Stream.of(queues).map(c -> (QueueSummary)((QueueSummary.Builder)QueueSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueuesResponse> {
        public Builder nextToken(String var1);

        public Builder queues(Collection<QueueSummary> var1);

        public Builder queues(QueueSummary ... var1);

        public Builder queues(Consumer<QueueSummary.Builder> ... var1);
    }
}

