/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineResponse;
import software.amazon.awssdk.services.deadline.model.SessionActionDefinition;
import software.amazon.awssdk.services.deadline.model.SessionActionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionActionResponse
extends DeadlineResponse
implements ToCopyableBuilder<Builder, GetSessionActionResponse> {
    private static final SdkField<SessionActionDefinition> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(GetSessionActionResponse.getter(GetSessionActionResponse::definition)).setter(GetSessionActionResponse.setter(Builder::definition)).constructor(SessionActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetSessionActionResponse.getter(GetSessionActionResponse::endedAt)).setter(GetSessionActionResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> PROCESS_EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("processExitCode").getter(GetSessionActionResponse.getter(GetSessionActionResponse::processExitCode)).setter(GetSessionActionResponse.setter(Builder::processExitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processExitCode").build()}).build();
    private static final SdkField<String> PROGRESS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("progressMessage").getter(GetSessionActionResponse.getter(GetSessionActionResponse::progressMessage)).setter(GetSessionActionResponse.setter(Builder::progressMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressMessage").build()}).build();
    private static final SdkField<Float> PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("progressPercent").getter(GetSessionActionResponse.getter(GetSessionActionResponse::progressPercent)).setter(GetSessionActionResponse.setter(Builder::progressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercent").build()}).build();
    private static final SdkField<String> SESSION_ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionActionId").getter(GetSessionActionResponse.getter(GetSessionActionResponse::sessionActionId)).setter(GetSessionActionResponse.setter(Builder::sessionActionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionActionId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetSessionActionResponse.getter(GetSessionActionResponse::sessionId)).setter(GetSessionActionResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetSessionActionResponse.getter(GetSessionActionResponse::startedAt)).setter(GetSessionActionResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetSessionActionResponse.getter(GetSessionActionResponse::statusAsString)).setter(GetSessionActionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> WORKER_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("workerUpdatedAt").getter(GetSessionActionResponse.getter(GetSessionActionResponse::workerUpdatedAt)).setter(GetSessionActionResponse.setter(Builder::workerUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, ENDED_AT_FIELD, PROCESS_EXIT_CODE_FIELD, PROGRESS_MESSAGE_FIELD, PROGRESS_PERCENT_FIELD, SESSION_ACTION_ID_FIELD, SESSION_ID_FIELD, STARTED_AT_FIELD, STATUS_FIELD, WORKER_UPDATED_AT_FIELD));
    private final SessionActionDefinition definition;
    private final Instant endedAt;
    private final Integer processExitCode;
    private final String progressMessage;
    private final Float progressPercent;
    private final String sessionActionId;
    private final String sessionId;
    private final Instant startedAt;
    private final String status;
    private final Instant workerUpdatedAt;

    private GetSessionActionResponse(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.endedAt = builder.endedAt;
        this.processExitCode = builder.processExitCode;
        this.progressMessage = builder.progressMessage;
        this.progressPercent = builder.progressPercent;
        this.sessionActionId = builder.sessionActionId;
        this.sessionId = builder.sessionId;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.workerUpdatedAt = builder.workerUpdatedAt;
    }

    public final SessionActionDefinition definition() {
        return this.definition;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Integer processExitCode() {
        return this.processExitCode;
    }

    public final String progressMessage() {
        return this.progressMessage;
    }

    public final Float progressPercent() {
        return this.progressPercent;
    }

    public final String sessionActionId() {
        return this.sessionActionId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final SessionActionStatus status() {
        return SessionActionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant workerUpdatedAt() {
        return this.workerUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.processExitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionActionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionActionResponse)) {
            return false;
        }
        GetSessionActionResponse other = (GetSessionActionResponse)((Object)obj);
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.processExitCode(), other.processExitCode()) && Objects.equals(this.progressMessage(), other.progressMessage()) && Objects.equals(this.progressPercent(), other.progressPercent()) && Objects.equals(this.sessionActionId(), other.sessionActionId()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.workerUpdatedAt(), other.workerUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionActionResponse").add("Definition", (Object)this.definition()).add("EndedAt", (Object)this.endedAt()).add("ProcessExitCode", (Object)this.processExitCode()).add("ProgressMessage", (Object)(this.progressMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("ProgressPercent", (Object)this.progressPercent()).add("SessionActionId", (Object)this.sessionActionId()).add("SessionId", (Object)this.sessionId()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).add("WorkerUpdatedAt", (Object)this.workerUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "processExitCode": {
                return Optional.ofNullable(clazz.cast(this.processExitCode()));
            }
            case "progressMessage": {
                return Optional.ofNullable(clazz.cast(this.progressMessage()));
            }
            case "progressPercent": {
                return Optional.ofNullable(clazz.cast(this.progressPercent()));
            }
            case "sessionActionId": {
                return Optional.ofNullable(clazz.cast(this.sessionActionId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "workerUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.workerUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSessionActionResponse, T> g) {
        return obj -> g.apply((GetSessionActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineResponse.BuilderImpl
    implements Builder {
        private SessionActionDefinition definition;
        private Instant endedAt;
        private Integer processExitCode;
        private String progressMessage;
        private Float progressPercent;
        private String sessionActionId;
        private String sessionId;
        private Instant startedAt;
        private String status;
        private Instant workerUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionActionResponse model) {
            super(model);
            this.definition(model.definition);
            this.endedAt(model.endedAt);
            this.processExitCode(model.processExitCode);
            this.progressMessage(model.progressMessage);
            this.progressPercent(model.progressPercent);
            this.sessionActionId(model.sessionActionId);
            this.sessionId(model.sessionId);
            this.startedAt(model.startedAt);
            this.status(model.status);
            this.workerUpdatedAt(model.workerUpdatedAt);
        }

        public final SessionActionDefinition.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(SessionActionDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(SessionActionDefinition definition) {
            this.definition = definition;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Integer getProcessExitCode() {
            return this.processExitCode;
        }

        public final void setProcessExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
        }

        @Override
        public final Builder processExitCode(Integer processExitCode) {
            this.processExitCode = processExitCode;
            return this;
        }

        public final String getProgressMessage() {
            return this.progressMessage;
        }

        public final void setProgressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
        }

        @Override
        public final Builder progressMessage(String progressMessage) {
            this.progressMessage = progressMessage;
            return this;
        }

        public final Float getProgressPercent() {
            return this.progressPercent;
        }

        public final void setProgressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Float progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final String getSessionActionId() {
            return this.sessionActionId;
        }

        public final void setSessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
        }

        @Override
        public final Builder sessionActionId(String sessionActionId) {
            this.sessionActionId = sessionActionId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getWorkerUpdatedAt() {
            return this.workerUpdatedAt;
        }

        public final void setWorkerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
        }

        @Override
        public final Builder workerUpdatedAt(Instant workerUpdatedAt) {
            this.workerUpdatedAt = workerUpdatedAt;
            return this;
        }

        @Override
        public GetSessionActionResponse build() {
            return new GetSessionActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionActionResponse> {
        public Builder definition(SessionActionDefinition var1);

        default public Builder definition(Consumer<SessionActionDefinition.Builder> definition) {
            return this.definition((SessionActionDefinition)((SessionActionDefinition.Builder)SessionActionDefinition.builder().applyMutation(definition)).build());
        }

        public Builder endedAt(Instant var1);

        public Builder processExitCode(Integer var1);

        public Builder progressMessage(String var1);

        public Builder progressPercent(Float var1);

        public Builder sessionActionId(String var1);

        public Builder sessionId(String var1);

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(SessionActionStatus var1);

        public Builder workerUpdatedAt(Instant var1);
    }
}

