/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.AcceleratorCountRange;
import software.amazon.awssdk.services.deadline.model.AcceleratorTotalMemoryMiBRange;
import software.amazon.awssdk.services.deadline.model.AcceleratorType;
import software.amazon.awssdk.services.deadline.model.AcceleratorTypesCopier;
import software.amazon.awssdk.services.deadline.model.CpuArchitectureType;
import software.amazon.awssdk.services.deadline.model.CustomFleetAmountCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.CustomFleetAttributeCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.CustomerManagedFleetOperatingSystemFamily;
import software.amazon.awssdk.services.deadline.model.FleetAmountCapability;
import software.amazon.awssdk.services.deadline.model.FleetAttributeCapability;
import software.amazon.awssdk.services.deadline.model.MemoryMiBRange;
import software.amazon.awssdk.services.deadline.model.VCpuCountRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerManagedWorkerCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerManagedWorkerCapabilities> {
    private static final SdkField<AcceleratorCountRange> ACCELERATOR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acceleratorCount").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::acceleratorCount)).setter(CustomerManagedWorkerCapabilities.setter(Builder::acceleratorCount)).constructor(AcceleratorCountRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorCount").build()}).build();
    private static final SdkField<AcceleratorTotalMemoryMiBRange> ACCELERATOR_TOTAL_MEMORY_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acceleratorTotalMemoryMiB").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::acceleratorTotalMemoryMiB)).setter(CustomerManagedWorkerCapabilities.setter(Builder::acceleratorTotalMemoryMiB)).constructor(AcceleratorTotalMemoryMiBRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTotalMemoryMiB").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("acceleratorTypes").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::acceleratorTypesAsStrings)).setter(CustomerManagedWorkerCapabilities.setter(Builder::acceleratorTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CPU_ARCHITECTURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpuArchitectureType").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::cpuArchitectureTypeAsString)).setter(CustomerManagedWorkerCapabilities.setter(Builder::cpuArchitectureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitectureType").build()}).build();
    private static final SdkField<List<FleetAmountCapability>> CUSTOM_AMOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customAmounts").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::customAmounts)).setter(CustomerManagedWorkerCapabilities.setter(Builder::customAmounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAmounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAmountCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FleetAttributeCapability>> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customAttributes").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::customAttributes)).setter(CustomerManagedWorkerCapabilities.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAttributeCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MemoryMiBRange> MEMORY_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryMiB").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::memoryMiB)).setter(CustomerManagedWorkerCapabilities.setter(Builder::memoryMiB)).constructor(MemoryMiBRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryMiB").build()}).build();
    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osFamily").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::osFamilyAsString)).setter(CustomerManagedWorkerCapabilities.setter(Builder::osFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()}).build();
    private static final SdkField<VCpuCountRange> V_CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vCpuCount").getter(CustomerManagedWorkerCapabilities.getter(CustomerManagedWorkerCapabilities::vCpuCount)).setter(CustomerManagedWorkerCapabilities.setter(Builder::vCpuCount)).constructor(VCpuCountRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpuCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_COUNT_FIELD, ACCELERATOR_TOTAL_MEMORY_MIB_FIELD, ACCELERATOR_TYPES_FIELD, CPU_ARCHITECTURE_TYPE_FIELD, CUSTOM_AMOUNTS_FIELD, CUSTOM_ATTRIBUTES_FIELD, MEMORY_MIB_FIELD, OS_FAMILY_FIELD, V_CPU_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final AcceleratorCountRange acceleratorCount;
    private final AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB;
    private final List<String> acceleratorTypes;
    private final String cpuArchitectureType;
    private final List<FleetAmountCapability> customAmounts;
    private final List<FleetAttributeCapability> customAttributes;
    private final MemoryMiBRange memoryMiB;
    private final String osFamily;
    private final VCpuCountRange vCpuCount;

    private CustomerManagedWorkerCapabilities(BuilderImpl builder) {
        this.acceleratorCount = builder.acceleratorCount;
        this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.cpuArchitectureType = builder.cpuArchitectureType;
        this.customAmounts = builder.customAmounts;
        this.customAttributes = builder.customAttributes;
        this.memoryMiB = builder.memoryMiB;
        this.osFamily = builder.osFamily;
        this.vCpuCount = builder.vCpuCount;
    }

    public final AcceleratorCountRange acceleratorCount() {
        return this.acceleratorCount;
    }

    public final AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB() {
        return this.acceleratorTotalMemoryMiB;
    }

    public final List<AcceleratorType> acceleratorTypes() {
        return AcceleratorTypesCopier.copyStringToEnum(this.acceleratorTypes);
    }

    public final boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorTypesAsStrings() {
        return this.acceleratorTypes;
    }

    public final CpuArchitectureType cpuArchitectureType() {
        return CpuArchitectureType.fromValue(this.cpuArchitectureType);
    }

    public final String cpuArchitectureTypeAsString() {
        return this.cpuArchitectureType;
    }

    public final boolean hasCustomAmounts() {
        return this.customAmounts != null && !(this.customAmounts instanceof SdkAutoConstructList);
    }

    public final List<FleetAmountCapability> customAmounts() {
        return this.customAmounts;
    }

    public final boolean hasCustomAttributes() {
        return this.customAttributes != null && !(this.customAttributes instanceof SdkAutoConstructList);
    }

    public final List<FleetAttributeCapability> customAttributes() {
        return this.customAttributes;
    }

    public final MemoryMiBRange memoryMiB() {
        return this.memoryMiB;
    }

    public final CustomerManagedFleetOperatingSystemFamily osFamily() {
        return CustomerManagedFleetOperatingSystemFamily.fromValue(this.osFamily);
    }

    public final String osFamilyAsString() {
        return this.osFamily;
    }

    public final VCpuCountRange vCpuCount() {
        return this.vCpuCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorTotalMemoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuArchitectureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAmounts() ? this.customAmounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAttributes() ? this.customAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vCpuCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedWorkerCapabilities)) {
            return false;
        }
        CustomerManagedWorkerCapabilities other = (CustomerManagedWorkerCapabilities)obj;
        return Objects.equals(this.acceleratorCount(), other.acceleratorCount()) && Objects.equals(this.acceleratorTotalMemoryMiB(), other.acceleratorTotalMemoryMiB()) && this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings()) && Objects.equals(this.cpuArchitectureTypeAsString(), other.cpuArchitectureTypeAsString()) && this.hasCustomAmounts() == other.hasCustomAmounts() && Objects.equals(this.customAmounts(), other.customAmounts()) && this.hasCustomAttributes() == other.hasCustomAttributes() && Objects.equals(this.customAttributes(), other.customAttributes()) && Objects.equals(this.memoryMiB(), other.memoryMiB()) && Objects.equals(this.osFamilyAsString(), other.osFamilyAsString()) && Objects.equals(this.vCpuCount(), other.vCpuCount());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerManagedWorkerCapabilities").add("AcceleratorCount", (Object)this.acceleratorCount()).add("AcceleratorTotalMemoryMiB", (Object)this.acceleratorTotalMemoryMiB()).add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypesAsStrings() : null).add("CpuArchitectureType", (Object)this.cpuArchitectureTypeAsString()).add("CustomAmounts", this.hasCustomAmounts() ? this.customAmounts() : null).add("CustomAttributes", this.hasCustomAttributes() ? this.customAttributes() : null).add("MemoryMiB", (Object)this.memoryMiB()).add("OsFamily", (Object)this.osFamilyAsString()).add("VCpuCount", (Object)this.vCpuCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceleratorCount": {
                return Optional.ofNullable(clazz.cast(this.acceleratorCount()));
            }
            case "acceleratorTotalMemoryMiB": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTotalMemoryMiB()));
            }
            case "acceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypesAsStrings()));
            }
            case "cpuArchitectureType": {
                return Optional.ofNullable(clazz.cast(this.cpuArchitectureTypeAsString()));
            }
            case "customAmounts": {
                return Optional.ofNullable(clazz.cast(this.customAmounts()));
            }
            case "customAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
            case "memoryMiB": {
                return Optional.ofNullable(clazz.cast(this.memoryMiB()));
            }
            case "osFamily": {
                return Optional.ofNullable(clazz.cast(this.osFamilyAsString()));
            }
            case "vCpuCount": {
                return Optional.ofNullable(clazz.cast(this.vCpuCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedWorkerCapabilities, T> g) {
        return obj -> g.apply((CustomerManagedWorkerCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AcceleratorCountRange acceleratorCount;
        private AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB;
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();
        private String cpuArchitectureType;
        private List<FleetAmountCapability> customAmounts = DefaultSdkAutoConstructList.getInstance();
        private List<FleetAttributeCapability> customAttributes = DefaultSdkAutoConstructList.getInstance();
        private MemoryMiBRange memoryMiB;
        private String osFamily;
        private VCpuCountRange vCpuCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedWorkerCapabilities model) {
            this.acceleratorCount(model.acceleratorCount);
            this.acceleratorTotalMemoryMiB(model.acceleratorTotalMemoryMiB);
            this.acceleratorTypesWithStrings(model.acceleratorTypes);
            this.cpuArchitectureType(model.cpuArchitectureType);
            this.customAmounts(model.customAmounts);
            this.customAttributes(model.customAttributes);
            this.memoryMiB(model.memoryMiB);
            this.osFamily(model.osFamily);
            this.vCpuCount(model.vCpuCount);
        }

        public final AcceleratorCountRange.Builder getAcceleratorCount() {
            return this.acceleratorCount != null ? this.acceleratorCount.toBuilder() : null;
        }

        public final void setAcceleratorCount(AcceleratorCountRange.BuilderImpl acceleratorCount) {
            this.acceleratorCount = acceleratorCount != null ? acceleratorCount.build() : null;
        }

        @Override
        public final Builder acceleratorCount(AcceleratorCountRange acceleratorCount) {
            this.acceleratorCount = acceleratorCount;
            return this;
        }

        public final AcceleratorTotalMemoryMiBRange.Builder getAcceleratorTotalMemoryMiB() {
            return this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.toBuilder() : null;
        }

        public final void setAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange.BuilderImpl acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB != null ? acceleratorTotalMemoryMiB.build() : null;
        }

        @Override
        public final Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypesCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String ... acceleratorTypes) {
            this.acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<AcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(AcceleratorType ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getCpuArchitectureType() {
            return this.cpuArchitectureType;
        }

        public final void setCpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
        }

        @Override
        public final Builder cpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
            return this;
        }

        @Override
        public final Builder cpuArchitectureType(CpuArchitectureType cpuArchitectureType) {
            this.cpuArchitectureType(cpuArchitectureType == null ? null : cpuArchitectureType.toString());
            return this;
        }

        public final List<FleetAmountCapability.Builder> getCustomAmounts() {
            List<FleetAmountCapability.Builder> result = CustomFleetAmountCapabilitiesCopier.copyToBuilder(this.customAmounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAmounts(Collection<FleetAmountCapability.BuilderImpl> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copyFromBuilder(customAmounts);
        }

        @Override
        public final Builder customAmounts(Collection<FleetAmountCapability> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copy(customAmounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(FleetAmountCapability ... customAmounts) {
            this.customAmounts(Arrays.asList(customAmounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(Consumer<FleetAmountCapability.Builder> ... customAmounts) {
            this.customAmounts(Stream.of(customAmounts).map(c -> (FleetAmountCapability)((FleetAmountCapability.Builder)FleetAmountCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FleetAttributeCapability.Builder> getCustomAttributes() {
            List<FleetAttributeCapability.Builder> result = CustomFleetAttributeCapabilitiesCopier.copyToBuilder(this.customAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAttributes(Collection<FleetAttributeCapability.BuilderImpl> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public final Builder customAttributes(Collection<FleetAttributeCapability> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(FleetAttributeCapability ... customAttributes) {
            this.customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<FleetAttributeCapability.Builder> ... customAttributes) {
            this.customAttributes(Stream.of(customAttributes).map(c -> (FleetAttributeCapability)((FleetAttributeCapability.Builder)FleetAttributeCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MemoryMiBRange.Builder getMemoryMiB() {
            return this.memoryMiB != null ? this.memoryMiB.toBuilder() : null;
        }

        public final void setMemoryMiB(MemoryMiBRange.BuilderImpl memoryMiB) {
            this.memoryMiB = memoryMiB != null ? memoryMiB.build() : null;
        }

        @Override
        public final Builder memoryMiB(MemoryMiBRange memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public final String getOsFamily() {
            return this.osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(CustomerManagedFleetOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final VCpuCountRange.Builder getVCpuCount() {
            return this.vCpuCount != null ? this.vCpuCount.toBuilder() : null;
        }

        public final void setVCpuCount(VCpuCountRange.BuilderImpl vCpuCount) {
            this.vCpuCount = vCpuCount != null ? vCpuCount.build() : null;
        }

        @Override
        public final Builder vCpuCount(VCpuCountRange vCpuCount) {
            this.vCpuCount = vCpuCount;
            return this;
        }

        public CustomerManagedWorkerCapabilities build() {
            return new CustomerManagedWorkerCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerManagedWorkerCapabilities> {
        public Builder acceleratorCount(AcceleratorCountRange var1);

        default public Builder acceleratorCount(Consumer<AcceleratorCountRange.Builder> acceleratorCount) {
            return this.acceleratorCount((AcceleratorCountRange)((AcceleratorCountRange.Builder)AcceleratorCountRange.builder().applyMutation(acceleratorCount)).build());
        }

        public Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange var1);

        default public Builder acceleratorTotalMemoryMiB(Consumer<AcceleratorTotalMemoryMiBRange.Builder> acceleratorTotalMemoryMiB) {
            return this.acceleratorTotalMemoryMiB((AcceleratorTotalMemoryMiBRange)((AcceleratorTotalMemoryMiBRange.Builder)AcceleratorTotalMemoryMiBRange.builder().applyMutation(acceleratorTotalMemoryMiB)).build());
        }

        public Builder acceleratorTypesWithStrings(Collection<String> var1);

        public Builder acceleratorTypesWithStrings(String ... var1);

        public Builder acceleratorTypes(Collection<AcceleratorType> var1);

        public Builder acceleratorTypes(AcceleratorType ... var1);

        public Builder cpuArchitectureType(String var1);

        public Builder cpuArchitectureType(CpuArchitectureType var1);

        public Builder customAmounts(Collection<FleetAmountCapability> var1);

        public Builder customAmounts(FleetAmountCapability ... var1);

        public Builder customAmounts(Consumer<FleetAmountCapability.Builder> ... var1);

        public Builder customAttributes(Collection<FleetAttributeCapability> var1);

        public Builder customAttributes(FleetAttributeCapability ... var1);

        public Builder customAttributes(Consumer<FleetAttributeCapability.Builder> ... var1);

        public Builder memoryMiB(MemoryMiBRange var1);

        default public Builder memoryMiB(Consumer<MemoryMiBRange.Builder> memoryMiB) {
            return this.memoryMiB((MemoryMiBRange)((MemoryMiBRange.Builder)MemoryMiBRange.builder().applyMutation(memoryMiB)).build());
        }

        public Builder osFamily(String var1);

        public Builder osFamily(CustomerManagedFleetOperatingSystemFamily var1);

        public Builder vCpuCount(VCpuCountRange var1);

        default public Builder vCpuCount(Consumer<VCpuCountRange.Builder> vCpuCount) {
            return this.vCpuCount((VCpuCountRange)((VCpuCountRange.Builder)VCpuCountRange.builder().applyMutation(vCpuCount)).build());
        }
    }
}

