/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkerStatus {
    CREATED("CREATED"),
    STARTED("STARTED"),
    STOPPING("STOPPING"),
    STOPPED("STOPPED"),
    NOT_RESPONDING("NOT_RESPONDING"),
    NOT_COMPATIBLE("NOT_COMPATIBLE"),
    RUNNING("RUNNING"),
    IDLE("IDLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkerStatus> VALUE_MAP;
    private final String value;

    private WorkerStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkerStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkerStatus> knownValues() {
        EnumSet<WorkerStatus> knownValues = EnumSet.allOf(WorkerStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkerStatus.class, WorkerStatus::toString);
    }
}

