/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.SearchGroupedFilterExpressions;
import software.amazon.awssdk.services.deadline.model.SearchJobsRequestQueueIdsListCopier;
import software.amazon.awssdk.services.deadline.model.SearchSortExpression;
import software.amazon.awssdk.services.deadline.model.SearchSortExpressionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchJobsRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, SearchJobsRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(SearchJobsRequest.getter(SearchJobsRequest::farmId)).setter(SearchJobsRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<SearchGroupedFilterExpressions> FILTER_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filterExpressions").getter(SearchJobsRequest.getter(SearchJobsRequest::filterExpressions)).setter(SearchJobsRequest.setter(Builder::filterExpressions)).constructor(SearchGroupedFilterExpressions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterExpressions").build()}).build();
    private static final SdkField<Integer> ITEM_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("itemOffset").getter(SearchJobsRequest.getter(SearchJobsRequest::itemOffset)).setter(SearchJobsRequest.setter(Builder::itemOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemOffset").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("pageSize").getter(SearchJobsRequest.getter(SearchJobsRequest::pageSize)).setter(SearchJobsRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageSize").build()}).build();
    private static final SdkField<List<String>> QUEUE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("queueIds").getter(SearchJobsRequest.getter(SearchJobsRequest::queueIds)).setter(SearchJobsRequest.setter(Builder::queueIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SearchSortExpression>> SORT_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sortExpressions").getter(SearchJobsRequest.getter(SearchJobsRequest::sortExpressions)).setter(SearchJobsRequest.setter(Builder::sortExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortExpressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchSortExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, FILTER_EXPRESSIONS_FIELD, ITEM_OFFSET_FIELD, PAGE_SIZE_FIELD, QUEUE_IDS_FIELD, SORT_EXPRESSIONS_FIELD));
    private final String farmId;
    private final SearchGroupedFilterExpressions filterExpressions;
    private final Integer itemOffset;
    private final Integer pageSize;
    private final List<String> queueIds;
    private final List<SearchSortExpression> sortExpressions;

    private SearchJobsRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.filterExpressions = builder.filterExpressions;
        this.itemOffset = builder.itemOffset;
        this.pageSize = builder.pageSize;
        this.queueIds = builder.queueIds;
        this.sortExpressions = builder.sortExpressions;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final SearchGroupedFilterExpressions filterExpressions() {
        return this.filterExpressions;
    }

    public final Integer itemOffset() {
        return this.itemOffset;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final boolean hasQueueIds() {
        return this.queueIds != null && !(this.queueIds instanceof SdkAutoConstructList);
    }

    public final List<String> queueIds() {
        return this.queueIds;
    }

    public final boolean hasSortExpressions() {
        return this.sortExpressions != null && !(this.sortExpressions instanceof SdkAutoConstructList);
    }

    public final List<SearchSortExpression> sortExpressions() {
        return this.sortExpressions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpressions());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueIds() ? this.queueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortExpressions() ? this.sortExpressions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchJobsRequest)) {
            return false;
        }
        SearchJobsRequest other = (SearchJobsRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.filterExpressions(), other.filterExpressions()) && Objects.equals(this.itemOffset(), other.itemOffset()) && Objects.equals(this.pageSize(), other.pageSize()) && this.hasQueueIds() == other.hasQueueIds() && Objects.equals(this.queueIds(), other.queueIds()) && this.hasSortExpressions() == other.hasSortExpressions() && Objects.equals(this.sortExpressions(), other.sortExpressions());
    }

    public final String toString() {
        return ToString.builder((String)"SearchJobsRequest").add("FarmId", (Object)this.farmId()).add("FilterExpressions", (Object)this.filterExpressions()).add("ItemOffset", (Object)this.itemOffset()).add("PageSize", (Object)this.pageSize()).add("QueueIds", this.hasQueueIds() ? this.queueIds() : null).add("SortExpressions", this.hasSortExpressions() ? this.sortExpressions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "filterExpressions": {
                return Optional.ofNullable(clazz.cast(this.filterExpressions()));
            }
            case "itemOffset": {
                return Optional.ofNullable(clazz.cast(this.itemOffset()));
            }
            case "pageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "queueIds": {
                return Optional.ofNullable(clazz.cast(this.queueIds()));
            }
            case "sortExpressions": {
                return Optional.ofNullable(clazz.cast(this.sortExpressions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchJobsRequest, T> g) {
        return obj -> g.apply((SearchJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private SearchGroupedFilterExpressions filterExpressions;
        private Integer itemOffset;
        private Integer pageSize;
        private List<String> queueIds = DefaultSdkAutoConstructList.getInstance();
        private List<SearchSortExpression> sortExpressions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchJobsRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.filterExpressions(model.filterExpressions);
            this.itemOffset(model.itemOffset);
            this.pageSize(model.pageSize);
            this.queueIds(model.queueIds);
            this.sortExpressions(model.sortExpressions);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final SearchGroupedFilterExpressions.Builder getFilterExpressions() {
            return this.filterExpressions != null ? this.filterExpressions.toBuilder() : null;
        }

        public final void setFilterExpressions(SearchGroupedFilterExpressions.BuilderImpl filterExpressions) {
            this.filterExpressions = filterExpressions != null ? filterExpressions.build() : null;
        }

        @Override
        public final Builder filterExpressions(SearchGroupedFilterExpressions filterExpressions) {
            this.filterExpressions = filterExpressions;
            return this;
        }

        public final Integer getItemOffset() {
            return this.itemOffset;
        }

        public final void setItemOffset(Integer itemOffset) {
            this.itemOffset = itemOffset;
        }

        @Override
        public final Builder itemOffset(Integer itemOffset) {
            this.itemOffset = itemOffset;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final Collection<String> getQueueIds() {
            if (this.queueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queueIds;
        }

        public final void setQueueIds(Collection<String> queueIds) {
            this.queueIds = SearchJobsRequestQueueIdsListCopier.copy(queueIds);
        }

        @Override
        public final Builder queueIds(Collection<String> queueIds) {
            this.queueIds = SearchJobsRequestQueueIdsListCopier.copy(queueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueIds(String ... queueIds) {
            this.queueIds(Arrays.asList(queueIds));
            return this;
        }

        public final List<SearchSortExpression.Builder> getSortExpressions() {
            List<SearchSortExpression.Builder> result = SearchSortExpressionsCopier.copyToBuilder(this.sortExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortExpressions(Collection<SearchSortExpression.BuilderImpl> sortExpressions) {
            this.sortExpressions = SearchSortExpressionsCopier.copyFromBuilder(sortExpressions);
        }

        @Override
        public final Builder sortExpressions(Collection<SearchSortExpression> sortExpressions) {
            this.sortExpressions = SearchSortExpressionsCopier.copy(sortExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortExpressions(SearchSortExpression ... sortExpressions) {
            this.sortExpressions(Arrays.asList(sortExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortExpressions(Consumer<SearchSortExpression.Builder> ... sortExpressions) {
            this.sortExpressions(Stream.of(sortExpressions).map(c -> (SearchSortExpression)((SearchSortExpression.Builder)SearchSortExpression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchJobsRequest build() {
            return new SearchJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchJobsRequest> {
        public Builder farmId(String var1);

        public Builder filterExpressions(SearchGroupedFilterExpressions var1);

        default public Builder filterExpressions(Consumer<SearchGroupedFilterExpressions.Builder> filterExpressions) {
            return this.filterExpressions((SearchGroupedFilterExpressions)((SearchGroupedFilterExpressions.Builder)SearchGroupedFilterExpressions.builder().applyMutation(filterExpressions)).build());
        }

        public Builder itemOffset(Integer var1);

        public Builder pageSize(Integer var1);

        public Builder queueIds(Collection<String> var1);

        public Builder queueIds(String ... var1);

        public Builder sortExpressions(Collection<SearchSortExpression> var1);

        public Builder sortExpressions(SearchSortExpression ... var1);

        public Builder sortExpressions(Consumer<SearchSortExpression.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

