/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CpuArchitectureType {
    X86_64("x86_64"),
    ARM64("arm64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CpuArchitectureType> VALUE_MAP;
    private final String value;

    private CpuArchitectureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CpuArchitectureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CpuArchitectureType> knownValues() {
        EnumSet<CpuArchitectureType> knownValues = EnumSet.allOf(CpuArchitectureType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CpuArchitectureType.class, CpuArchitectureType::toString);
    }
}

