/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.BudgetStatus;
import software.amazon.awssdk.services.deadline.model.ConsumedUsages;
import software.amazon.awssdk.services.deadline.model.UsageTrackingResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BudgetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BudgetSummary> {
    private static final SdkField<Float> APPROXIMATE_DOLLAR_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("approximateDollarLimit").getter(BudgetSummary.getter(BudgetSummary::approximateDollarLimit)).setter(BudgetSummary.setter(Builder::approximateDollarLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarLimit").build()}).build();
    private static final SdkField<String> BUDGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("budgetId").getter(BudgetSummary.getter(BudgetSummary::budgetId)).setter(BudgetSummary.setter(Builder::budgetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budgetId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(BudgetSummary.getter(BudgetSummary::createdAt)).setter(BudgetSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(BudgetSummary.getter(BudgetSummary::createdBy)).setter(BudgetSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(BudgetSummary.getter(BudgetSummary::description)).setter(BudgetSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(BudgetSummary.getter(BudgetSummary::displayName)).setter(BudgetSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(BudgetSummary.getter(BudgetSummary::statusAsString)).setter(BudgetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(BudgetSummary.getter(BudgetSummary::updatedAt)).setter(BudgetSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(BudgetSummary.getter(BudgetSummary::updatedBy)).setter(BudgetSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<UsageTrackingResource> USAGE_TRACKING_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usageTrackingResource").getter(BudgetSummary.getter(BudgetSummary::usageTrackingResource)).setter(BudgetSummary.setter(Builder::usageTrackingResource)).constructor(UsageTrackingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTrackingResource").build()}).build();
    private static final SdkField<ConsumedUsages> USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("usages").getter(BudgetSummary.getter(BudgetSummary::usages)).setter(BudgetSummary.setter(Builder::usages)).constructor(ConsumedUsages::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROXIMATE_DOLLAR_LIMIT_FIELD, BUDGET_ID_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, USAGE_TRACKING_RESOURCE_FIELD, USAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float approximateDollarLimit;
    private final String budgetId;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String displayName;
    private final String status;
    private final Instant updatedAt;
    private final String updatedBy;
    private final UsageTrackingResource usageTrackingResource;
    private final ConsumedUsages usages;

    private BudgetSummary(BuilderImpl builder) {
        this.approximateDollarLimit = builder.approximateDollarLimit;
        this.budgetId = builder.budgetId;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.usageTrackingResource = builder.usageTrackingResource;
        this.usages = builder.usages;
    }

    public final Float approximateDollarLimit() {
        return this.approximateDollarLimit;
    }

    public final String budgetId() {
        return this.budgetId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final BudgetStatus status() {
        return BudgetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final UsageTrackingResource usageTrackingResource() {
        return this.usageTrackingResource;
    }

    public final ConsumedUsages usages() {
        return this.usages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateDollarLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTrackingResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.usages());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetSummary)) {
            return false;
        }
        BudgetSummary other = (BudgetSummary)obj;
        return Objects.equals(this.approximateDollarLimit(), other.approximateDollarLimit()) && Objects.equals(this.budgetId(), other.budgetId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && Objects.equals(this.usageTrackingResource(), other.usageTrackingResource()) && Objects.equals(this.usages(), other.usages());
    }

    public final String toString() {
        return ToString.builder((String)"BudgetSummary").add("ApproximateDollarLimit", (Object)this.approximateDollarLimit()).add("BudgetId", (Object)this.budgetId()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("UsageTrackingResource", (Object)this.usageTrackingResource()).add("Usages", (Object)this.usages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "approximateDollarLimit": {
                return Optional.ofNullable(clazz.cast(this.approximateDollarLimit()));
            }
            case "budgetId": {
                return Optional.ofNullable(clazz.cast(this.budgetId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "usageTrackingResource": {
                return Optional.ofNullable(clazz.cast(this.usageTrackingResource()));
            }
            case "usages": {
                return Optional.ofNullable(clazz.cast(this.usages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BudgetSummary, T> g) {
        return obj -> g.apply((BudgetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float approximateDollarLimit;
        private String budgetId;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String displayName;
        private String status;
        private Instant updatedAt;
        private String updatedBy;
        private UsageTrackingResource usageTrackingResource;
        private ConsumedUsages usages;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetSummary model) {
            this.approximateDollarLimit(model.approximateDollarLimit);
            this.budgetId(model.budgetId);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.displayName(model.displayName);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.usageTrackingResource(model.usageTrackingResource);
            this.usages(model.usages);
        }

        public final Float getApproximateDollarLimit() {
            return this.approximateDollarLimit;
        }

        public final void setApproximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
        }

        @Override
        public final Builder approximateDollarLimit(Float approximateDollarLimit) {
            this.approximateDollarLimit = approximateDollarLimit;
            return this;
        }

        public final String getBudgetId() {
            return this.budgetId;
        }

        public final void setBudgetId(String budgetId) {
            this.budgetId = budgetId;
        }

        @Override
        public final Builder budgetId(String budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BudgetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final UsageTrackingResource.Builder getUsageTrackingResource() {
            return this.usageTrackingResource != null ? this.usageTrackingResource.toBuilder() : null;
        }

        public final void setUsageTrackingResource(UsageTrackingResource.BuilderImpl usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource != null ? usageTrackingResource.build() : null;
        }

        @Override
        public final Builder usageTrackingResource(UsageTrackingResource usageTrackingResource) {
            this.usageTrackingResource = usageTrackingResource;
            return this;
        }

        public final ConsumedUsages.Builder getUsages() {
            return this.usages != null ? this.usages.toBuilder() : null;
        }

        public final void setUsages(ConsumedUsages.BuilderImpl usages) {
            this.usages = usages != null ? usages.build() : null;
        }

        @Override
        public final Builder usages(ConsumedUsages usages) {
            this.usages = usages;
            return this;
        }

        public BudgetSummary build() {
            return new BudgetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BudgetSummary> {
        public Builder approximateDollarLimit(Float var1);

        public Builder budgetId(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(BudgetStatus var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder usageTrackingResource(UsageTrackingResource var1);

        default public Builder usageTrackingResource(Consumer<UsageTrackingResource.Builder> usageTrackingResource) {
            return this.usageTrackingResource((UsageTrackingResource)((UsageTrackingResource.Builder)UsageTrackingResource.builder().applyMutation(usageTrackingResource)).build());
        }

        public Builder usages(ConsumedUsages var1);

        default public Builder usages(Consumer<ConsumedUsages.Builder> usages) {
            return this.usages((ConsumedUsages)((ConsumedUsages.Builder)ConsumedUsages.builder().applyMutation(usages)).build());
        }
    }
}

