/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.deadline.model.AllowedStorageProfileIdsCopier;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.DefaultQueueBudgetAction;
import software.amazon.awssdk.services.deadline.model.JobAttachmentSettings;
import software.amazon.awssdk.services.deadline.model.JobRunAsUser;
import software.amazon.awssdk.services.deadline.model.RequiredFileSystemLocationNamesCopier;
import software.amazon.awssdk.services.deadline.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQueueRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, CreateQueueRequest> {
    private static final SdkField<List<String>> ALLOWED_STORAGE_PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedStorageProfileIds").getter(CreateQueueRequest.getter(CreateQueueRequest::allowedStorageProfileIds)).setter(CreateQueueRequest.setter(Builder::allowedStorageProfileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedStorageProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateQueueRequest.getter(CreateQueueRequest::clientToken)).setter(CreateQueueRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DEFAULT_BUDGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultBudgetAction").getter(CreateQueueRequest.getter(CreateQueueRequest::defaultBudgetActionAsString)).setter(CreateQueueRequest.setter(Builder::defaultBudgetAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultBudgetAction").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateQueueRequest.getter(CreateQueueRequest::description)).setter(CreateQueueRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateQueueRequest.getter(CreateQueueRequest::displayName)).setter(CreateQueueRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(CreateQueueRequest.getter(CreateQueueRequest::farmId)).setter(CreateQueueRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<JobAttachmentSettings> JOB_ATTACHMENT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobAttachmentSettings").getter(CreateQueueRequest.getter(CreateQueueRequest::jobAttachmentSettings)).setter(CreateQueueRequest.setter(Builder::jobAttachmentSettings)).constructor(JobAttachmentSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobAttachmentSettings").build()}).build();
    private static final SdkField<JobRunAsUser> JOB_RUN_AS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobRunAsUser").getter(CreateQueueRequest.getter(CreateQueueRequest::jobRunAsUser)).setter(CreateQueueRequest.setter(Builder::jobRunAsUser)).constructor(JobRunAsUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunAsUser").build()}).build();
    private static final SdkField<List<String>> REQUIRED_FILE_SYSTEM_LOCATION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredFileSystemLocationNames").getter(CreateQueueRequest.getter(CreateQueueRequest::requiredFileSystemLocationNames)).setter(CreateQueueRequest.setter(Builder::requiredFileSystemLocationNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFileSystemLocationNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateQueueRequest.getter(CreateQueueRequest::roleArn)).setter(CreateQueueRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateQueueRequest.getter(CreateQueueRequest::tags)).setter(CreateQueueRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_STORAGE_PROFILE_IDS_FIELD, CLIENT_TOKEN_FIELD, DEFAULT_BUDGET_ACTION_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, FARM_ID_FIELD, JOB_ATTACHMENT_SETTINGS_FIELD, JOB_RUN_AS_USER_FIELD, REQUIRED_FILE_SYSTEM_LOCATION_NAMES_FIELD, ROLE_ARN_FIELD, TAGS_FIELD));
    private final List<String> allowedStorageProfileIds;
    private final String clientToken;
    private final String defaultBudgetAction;
    private final String description;
    private final String displayName;
    private final String farmId;
    private final JobAttachmentSettings jobAttachmentSettings;
    private final JobRunAsUser jobRunAsUser;
    private final List<String> requiredFileSystemLocationNames;
    private final String roleArn;
    private final Map<String, String> tags;

    private CreateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.allowedStorageProfileIds = builder.allowedStorageProfileIds;
        this.clientToken = builder.clientToken;
        this.defaultBudgetAction = builder.defaultBudgetAction;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.farmId = builder.farmId;
        this.jobAttachmentSettings = builder.jobAttachmentSettings;
        this.jobRunAsUser = builder.jobRunAsUser;
        this.requiredFileSystemLocationNames = builder.requiredFileSystemLocationNames;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
    }

    public final boolean hasAllowedStorageProfileIds() {
        return this.allowedStorageProfileIds != null && !(this.allowedStorageProfileIds instanceof SdkAutoConstructList);
    }

    public final List<String> allowedStorageProfileIds() {
        return this.allowedStorageProfileIds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DefaultQueueBudgetAction defaultBudgetAction() {
        return DefaultQueueBudgetAction.fromValue(this.defaultBudgetAction);
    }

    public final String defaultBudgetActionAsString() {
        return this.defaultBudgetAction;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final JobAttachmentSettings jobAttachmentSettings() {
        return this.jobAttachmentSettings;
    }

    public final JobRunAsUser jobRunAsUser() {
        return this.jobRunAsUser;
    }

    public final boolean hasRequiredFileSystemLocationNames() {
        return this.requiredFileSystemLocationNames != null && !(this.requiredFileSystemLocationNames instanceof SdkAutoConstructList);
    }

    public final List<String> requiredFileSystemLocationNames() {
        return this.requiredFileSystemLocationNames;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedStorageProfileIds() ? this.allowedStorageProfileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultBudgetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobAttachmentSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunAsUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredFileSystemLocationNames() ? this.requiredFileSystemLocationNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest)((Object)obj);
        return this.hasAllowedStorageProfileIds() == other.hasAllowedStorageProfileIds() && Objects.equals(this.allowedStorageProfileIds(), other.allowedStorageProfileIds()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.defaultBudgetActionAsString(), other.defaultBudgetActionAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.jobAttachmentSettings(), other.jobAttachmentSettings()) && Objects.equals(this.jobRunAsUser(), other.jobRunAsUser()) && this.hasRequiredFileSystemLocationNames() == other.hasRequiredFileSystemLocationNames() && Objects.equals(this.requiredFileSystemLocationNames(), other.requiredFileSystemLocationNames()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQueueRequest").add("AllowedStorageProfileIds", this.hasAllowedStorageProfileIds() ? this.allowedStorageProfileIds() : null).add("ClientToken", (Object)this.clientToken()).add("DefaultBudgetAction", (Object)this.defaultBudgetActionAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)this.displayName()).add("FarmId", (Object)this.farmId()).add("JobAttachmentSettings", (Object)this.jobAttachmentSettings()).add("JobRunAsUser", (Object)this.jobRunAsUser()).add("RequiredFileSystemLocationNames", (Object)(this.requiredFileSystemLocationNames() == null ? null : "*** Sensitive Data Redacted ***")).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedStorageProfileIds": {
                return Optional.ofNullable(clazz.cast(this.allowedStorageProfileIds()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "defaultBudgetAction": {
                return Optional.ofNullable(clazz.cast(this.defaultBudgetActionAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "jobAttachmentSettings": {
                return Optional.ofNullable(clazz.cast(this.jobAttachmentSettings()));
            }
            case "jobRunAsUser": {
                return Optional.ofNullable(clazz.cast(this.jobRunAsUser()));
            }
            case "requiredFileSystemLocationNames": {
                return Optional.ofNullable(clazz.cast(this.requiredFileSystemLocationNames()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQueueRequest, T> g) {
        return obj -> g.apply((CreateQueueRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private List<String> allowedStorageProfileIds = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String defaultBudgetAction;
        private String description;
        private String displayName;
        private String farmId;
        private JobAttachmentSettings jobAttachmentSettings;
        private JobRunAsUser jobRunAsUser;
        private List<String> requiredFileSystemLocationNames = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            super(model);
            this.allowedStorageProfileIds(model.allowedStorageProfileIds);
            this.clientToken(model.clientToken);
            this.defaultBudgetAction(model.defaultBudgetAction);
            this.description(model.description);
            this.displayName(model.displayName);
            this.farmId(model.farmId);
            this.jobAttachmentSettings(model.jobAttachmentSettings);
            this.jobRunAsUser(model.jobRunAsUser);
            this.requiredFileSystemLocationNames(model.requiredFileSystemLocationNames);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
        }

        public final Collection<String> getAllowedStorageProfileIds() {
            if (this.allowedStorageProfileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedStorageProfileIds;
        }

        public final void setAllowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
            this.allowedStorageProfileIds = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIds);
        }

        @Override
        public final Builder allowedStorageProfileIds(Collection<String> allowedStorageProfileIds) {
            this.allowedStorageProfileIds = AllowedStorageProfileIdsCopier.copy(allowedStorageProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedStorageProfileIds(String ... allowedStorageProfileIds) {
            this.allowedStorageProfileIds(Arrays.asList(allowedStorageProfileIds));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDefaultBudgetAction() {
            return this.defaultBudgetAction;
        }

        public final void setDefaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
        }

        @Override
        public final Builder defaultBudgetAction(String defaultBudgetAction) {
            this.defaultBudgetAction = defaultBudgetAction;
            return this;
        }

        @Override
        public final Builder defaultBudgetAction(DefaultQueueBudgetAction defaultBudgetAction) {
            this.defaultBudgetAction(defaultBudgetAction == null ? null : defaultBudgetAction.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final JobAttachmentSettings.Builder getJobAttachmentSettings() {
            return this.jobAttachmentSettings != null ? this.jobAttachmentSettings.toBuilder() : null;
        }

        public final void setJobAttachmentSettings(JobAttachmentSettings.BuilderImpl jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings != null ? jobAttachmentSettings.build() : null;
        }

        @Override
        public final Builder jobAttachmentSettings(JobAttachmentSettings jobAttachmentSettings) {
            this.jobAttachmentSettings = jobAttachmentSettings;
            return this;
        }

        public final JobRunAsUser.Builder getJobRunAsUser() {
            return this.jobRunAsUser != null ? this.jobRunAsUser.toBuilder() : null;
        }

        public final void setJobRunAsUser(JobRunAsUser.BuilderImpl jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser != null ? jobRunAsUser.build() : null;
        }

        @Override
        public final Builder jobRunAsUser(JobRunAsUser jobRunAsUser) {
            this.jobRunAsUser = jobRunAsUser;
            return this;
        }

        public final Collection<String> getRequiredFileSystemLocationNames() {
            if (this.requiredFileSystemLocationNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredFileSystemLocationNames;
        }

        public final void setRequiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNames);
        }

        @Override
        public final Builder requiredFileSystemLocationNames(Collection<String> requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames = RequiredFileSystemLocationNamesCopier.copy(requiredFileSystemLocationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFileSystemLocationNames(String ... requiredFileSystemLocationNames) {
            this.requiredFileSystemLocationNames(Arrays.asList(requiredFileSystemLocationNames));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQueueRequest> {
        public Builder allowedStorageProfileIds(Collection<String> var1);

        public Builder allowedStorageProfileIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder defaultBudgetAction(String var1);

        public Builder defaultBudgetAction(DefaultQueueBudgetAction var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder farmId(String var1);

        public Builder jobAttachmentSettings(JobAttachmentSettings var1);

        default public Builder jobAttachmentSettings(Consumer<JobAttachmentSettings.Builder> jobAttachmentSettings) {
            return this.jobAttachmentSettings((JobAttachmentSettings)((JobAttachmentSettings.Builder)JobAttachmentSettings.builder().applyMutation(jobAttachmentSettings)).build());
        }

        public Builder jobRunAsUser(JobRunAsUser var1);

        default public Builder jobRunAsUser(Consumer<JobRunAsUser.Builder> jobRunAsUser) {
            return this.jobRunAsUser((JobRunAsUser)((JobRunAsUser.Builder)JobRunAsUser.builder().applyMutation(jobRunAsUser)).build());
        }

        public Builder requiredFileSystemLocationNames(Collection<String> var1);

        public Builder requiredFileSystemLocationNames(String ... var1);

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

