/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.model.GetFleetRequest;
import software.amazon.awssdk.services.deadline.model.GetFleetResponse;
import software.amazon.awssdk.services.deadline.model.GetJobRequest;
import software.amazon.awssdk.services.deadline.model.GetJobResponse;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointRequest;
import software.amazon.awssdk.services.deadline.model.GetLicenseEndpointResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueFleetAssociationResponse;
import software.amazon.awssdk.services.deadline.model.GetQueueRequest;
import software.amazon.awssdk.services.deadline.model.GetQueueResponse;
import software.amazon.awssdk.services.deadline.waiters.DefaultDeadlineAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface DeadlineAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<GetFleetResponse>> waitUntilFleetActive(GetFleetRequest getFleetRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetFleetResponse>> waitUntilFleetActive(Consumer<GetFleetRequest.Builder> getFleetRequest) {
        return this.waitUntilFleetActive((GetFleetRequest)((Object)((GetFleetRequest.Builder)GetFleetRequest.builder().applyMutation(getFleetRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetFleetResponse>> waitUntilFleetActive(GetFleetRequest getFleetRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetFleetResponse>> waitUntilFleetActive(Consumer<GetFleetRequest.Builder> getFleetRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilFleetActive((GetFleetRequest)((Object)((GetFleetRequest.Builder)GetFleetRequest.builder().applyMutation(getFleetRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetJobResponse>> waitUntilJobCreateComplete(GetJobRequest getJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetJobResponse>> waitUntilJobCreateComplete(Consumer<GetJobRequest.Builder> getJobRequest) {
        return this.waitUntilJobCreateComplete((GetJobRequest)((Object)((GetJobRequest.Builder)GetJobRequest.builder().applyMutation(getJobRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetJobResponse>> waitUntilJobCreateComplete(GetJobRequest getJobRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetJobResponse>> waitUntilJobCreateComplete(Consumer<GetJobRequest.Builder> getJobRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilJobCreateComplete((GetJobRequest)((Object)((GetJobRequest.Builder)GetJobRequest.builder().applyMutation(getJobRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointDeleted(Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest) {
        return this.waitUntilLicenseEndpointDeleted((GetLicenseEndpointRequest)((Object)((GetLicenseEndpointRequest.Builder)GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointDeleted(GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointDeleted(Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilLicenseEndpointDeleted((GetLicenseEndpointRequest)((Object)((GetLicenseEndpointRequest.Builder)GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointValid(GetLicenseEndpointRequest getLicenseEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointValid(Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest) {
        return this.waitUntilLicenseEndpointValid((GetLicenseEndpointRequest)((Object)((GetLicenseEndpointRequest.Builder)GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointValid(GetLicenseEndpointRequest getLicenseEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetLicenseEndpointResponse>> waitUntilLicenseEndpointValid(Consumer<GetLicenseEndpointRequest.Builder> getLicenseEndpointRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilLicenseEndpointValid((GetLicenseEndpointRequest)((Object)((GetLicenseEndpointRequest.Builder)GetLicenseEndpointRequest.builder().applyMutation(getLicenseEndpointRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetQueueFleetAssociationResponse>> waitUntilQueueFleetAssociationStopped(GetQueueFleetAssociationRequest getQueueFleetAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetQueueFleetAssociationResponse>> waitUntilQueueFleetAssociationStopped(Consumer<GetQueueFleetAssociationRequest.Builder> getQueueFleetAssociationRequest) {
        return this.waitUntilQueueFleetAssociationStopped((GetQueueFleetAssociationRequest)((Object)((GetQueueFleetAssociationRequest.Builder)GetQueueFleetAssociationRequest.builder().applyMutation(getQueueFleetAssociationRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetQueueFleetAssociationResponse>> waitUntilQueueFleetAssociationStopped(GetQueueFleetAssociationRequest getQueueFleetAssociationRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetQueueFleetAssociationResponse>> waitUntilQueueFleetAssociationStopped(Consumer<GetQueueFleetAssociationRequest.Builder> getQueueFleetAssociationRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilQueueFleetAssociationStopped((GetQueueFleetAssociationRequest)((Object)((GetQueueFleetAssociationRequest.Builder)GetQueueFleetAssociationRequest.builder().applyMutation(getQueueFleetAssociationRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueScheduling(GetQueueRequest getQueueRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueScheduling(Consumer<GetQueueRequest.Builder> getQueueRequest) {
        return this.waitUntilQueueScheduling((GetQueueRequest)((Object)((GetQueueRequest.Builder)GetQueueRequest.builder().applyMutation(getQueueRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueScheduling(GetQueueRequest getQueueRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueScheduling(Consumer<GetQueueRequest.Builder> getQueueRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilQueueScheduling((GetQueueRequest)((Object)((GetQueueRequest.Builder)GetQueueRequest.builder().applyMutation(getQueueRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueSchedulingBlocked(Consumer<GetQueueRequest.Builder> getQueueRequest) {
        return this.waitUntilQueueSchedulingBlocked((GetQueueRequest)((Object)((GetQueueRequest.Builder)GetQueueRequest.builder().applyMutation(getQueueRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueSchedulingBlocked(GetQueueRequest getQueueRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<GetQueueResponse>> waitUntilQueueSchedulingBlocked(Consumer<GetQueueRequest.Builder> getQueueRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilQueueSchedulingBlocked((GetQueueRequest)((Object)((GetQueueRequest.Builder)GetQueueRequest.builder().applyMutation(getQueueRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultDeadlineAsyncWaiter.builder();
    }

    public static DeadlineAsyncWaiter create() {
        return DefaultDeadlineAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(DeadlineAsyncClient var1);

        public DeadlineAsyncWaiter build();
    }
}

