/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.LicenseEndpointSummary;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsRequest;
import software.amazon.awssdk.services.deadline.model.ListLicenseEndpointsResponse;

public class ListLicenseEndpointsIterable
implements SdkIterable<ListLicenseEndpointsResponse> {
    private final DeadlineClient client;
    private final ListLicenseEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLicenseEndpointsIterable(DeadlineClient client, ListLicenseEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLicenseEndpointsResponseFetcher();
    }

    public Iterator<ListLicenseEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LicenseEndpointSummary> licenseEndpoints() {
        Function<ListLicenseEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.licenseEndpoints() != null) {
                return response.licenseEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLicenseEndpointsResponseFetcher
    implements SyncPageFetcher<ListLicenseEndpointsResponse> {
        private ListLicenseEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListLicenseEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLicenseEndpointsResponse nextPage(ListLicenseEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListLicenseEndpointsIterable.this.client.listLicenseEndpoints(ListLicenseEndpointsIterable.this.firstRequest);
            }
            return ListLicenseEndpointsIterable.this.client.listLicenseEndpoints((ListLicenseEndpointsRequest)((Object)ListLicenseEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

