/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.DependenciesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepDetailsEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepDetailsEntity> {
    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependencies").getter(StepDetailsEntity.getter(StepDetailsEntity::dependencies)).setter(StepDetailsEntity.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(StepDetailsEntity.getter(StepDetailsEntity::jobId)).setter(StepDetailsEntity.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaVersion").getter(StepDetailsEntity.getter(StepDetailsEntity::schemaVersion)).setter(StepDetailsEntity.setter(Builder::schemaVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepId").getter(StepDetailsEntity.getter(StepDetailsEntity::stepId)).setter(StepDetailsEntity.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()}).build();
    private static final SdkField<Document> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("template").getter(StepDetailsEntity.getter(StepDetailsEntity::template)).setter(StepDetailsEntity.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPENDENCIES_FIELD, JOB_ID_FIELD, SCHEMA_VERSION_FIELD, STEP_ID_FIELD, TEMPLATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> dependencies;
    private final String jobId;
    private final String schemaVersion;
    private final String stepId;
    private final Document template;

    private StepDetailsEntity(BuilderImpl builder) {
        this.dependencies = builder.dependencies;
        this.jobId = builder.jobId;
        this.schemaVersion = builder.schemaVersion;
        this.stepId = builder.stepId;
        this.template = builder.template;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<String> dependencies() {
        return this.dependencies;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String schemaVersion() {
        return this.schemaVersion;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final Document template() {
        return this.template;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepDetailsEntity)) {
            return false;
        }
        StepDetailsEntity other = (StepDetailsEntity)obj;
        return this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.schemaVersion(), other.schemaVersion()) && Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.template(), other.template());
    }

    public final String toString() {
        return ToString.builder((String)"StepDetailsEntity").add("Dependencies", this.hasDependencies() ? this.dependencies() : null).add("JobId", (Object)this.jobId()).add("SchemaVersion", (Object)this.schemaVersion()).add("StepId", (Object)this.stepId()).add("Template", (Object)(this.template() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "schemaVersion": {
                return Optional.ofNullable(clazz.cast(this.schemaVersion()));
            }
            case "stepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepDetailsEntity, T> g) {
        return obj -> g.apply((StepDetailsEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();
        private String jobId;
        private String schemaVersion;
        private String stepId;
        private Document template;

        private BuilderImpl() {
        }

        private BuilderImpl(StepDetailsEntity model) {
            this.dependencies(model.dependencies);
            this.jobId(model.jobId);
            this.schemaVersion(model.schemaVersion);
            this.stepId(model.stepId);
            this.template(model.template);
        }

        public final Collection<String> getDependencies() {
            if (this.dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependenciesListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependenciesListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSchemaVersion() {
            return this.schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final Document getTemplate() {
            return this.template;
        }

        public final void setTemplate(Document template) {
            this.template = template;
        }

        @Override
        public final Builder template(Document template) {
            this.template = template;
            return this;
        }

        public StepDetailsEntity build() {
            return new StepDetailsEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepDetailsEntity> {
        public Builder dependencies(Collection<String> var1);

        public Builder dependencies(String ... var1);

        public Builder jobId(String var1);

        public Builder schemaVersion(String var1);

        public Builder stepId(String var1);

        public Builder template(Document var1);
    }
}

