/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.ChangeType;
import software.amazon.awssdk.services.dax.model.IsModifiable;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValue;
import software.amazon.awssdk.services.dax.model.NodeTypeSpecificValueListCopier;
import software.amazon.awssdk.services.dax.model.ParameterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameter> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::parameterName)).setter(Parameter.setter(Builder::parameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()}).build();
    private static final SdkField<String> PARAMETER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::parameterTypeAsString)).setter(Parameter.setter(Builder::parameterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterType").build()}).build();
    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::parameterValue)).setter(Parameter.setter(Builder::parameterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()}).build();
    private static final SdkField<List<NodeTypeSpecificValue>> NODE_TYPE_SPECIFIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Parameter.getter(Parameter::nodeTypeSpecificValues)).setter(Parameter.setter(Builder::nodeTypeSpecificValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeTypeSpecificValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeTypeSpecificValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::description)).setter(Parameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::source)).setter(Parameter.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::dataType)).setter(Parameter.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::allowedValues)).setter(Parameter.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()}).build();
    private static final SdkField<String> IS_MODIFIABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::isModifiableAsString)).setter(Parameter.setter(Builder::isModifiable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsModifiable").build()}).build();
    private static final SdkField<String> CHANGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::changeTypeAsString)).setter(Parameter.setter(Builder::changeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD, PARAMETER_TYPE_FIELD, PARAMETER_VALUE_FIELD, NODE_TYPE_SPECIFIC_VALUES_FIELD, DESCRIPTION_FIELD, SOURCE_FIELD, DATA_TYPE_FIELD, ALLOWED_VALUES_FIELD, IS_MODIFIABLE_FIELD, CHANGE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterName;
    private final String parameterType;
    private final String parameterValue;
    private final List<NodeTypeSpecificValue> nodeTypeSpecificValues;
    private final String description;
    private final String source;
    private final String dataType;
    private final String allowedValues;
    private final String isModifiable;
    private final String changeType;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
        this.nodeTypeSpecificValues = builder.nodeTypeSpecificValues;
        this.description = builder.description;
        this.source = builder.source;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.changeType = builder.changeType;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public ParameterType parameterType() {
        return ParameterType.fromValue(this.parameterType);
    }

    public String parameterTypeAsString() {
        return this.parameterType;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public List<NodeTypeSpecificValue> nodeTypeSpecificValues() {
        return this.nodeTypeSpecificValues;
    }

    public String description() {
        return this.description;
    }

    public String source() {
        return this.source;
    }

    public String dataType() {
        return this.dataType;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public IsModifiable isModifiable() {
        return IsModifiable.fromValue(this.isModifiable);
    }

    public String isModifiableAsString() {
        return this.isModifiable;
    }

    public ChangeType changeType() {
        return ChangeType.fromValue(this.changeType);
    }

    public String changeTypeAsString() {
        return this.changeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeTypeSpecificValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.isModifiableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.parameterName(), other.parameterName()) && Objects.equals(this.parameterTypeAsString(), other.parameterTypeAsString()) && Objects.equals(this.parameterValue(), other.parameterValue()) && Objects.equals(this.nodeTypeSpecificValues(), other.nodeTypeSpecificValues()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.dataType(), other.dataType()) && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.isModifiableAsString(), other.isModifiableAsString()) && Objects.equals(this.changeTypeAsString(), other.changeTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Parameter").add("ParameterName", (Object)this.parameterName()).add("ParameterType", (Object)this.parameterTypeAsString()).add("ParameterValue", (Object)this.parameterValue()).add("NodeTypeSpecificValues", this.nodeTypeSpecificValues()).add("Description", (Object)this.description()).add("Source", (Object)this.source()).add("DataType", (Object)this.dataType()).add("AllowedValues", (Object)this.allowedValues()).add("IsModifiable", (Object)this.isModifiableAsString()).add("ChangeType", (Object)this.changeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.ofNullable(clazz.cast(this.parameterName()));
            }
            case "ParameterType": {
                return Optional.ofNullable(clazz.cast(this.parameterTypeAsString()));
            }
            case "ParameterValue": {
                return Optional.ofNullable(clazz.cast(this.parameterValue()));
            }
            case "NodeTypeSpecificValues": {
                return Optional.ofNullable(clazz.cast(this.nodeTypeSpecificValues()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "IsModifiable": {
                return Optional.ofNullable(clazz.cast(this.isModifiableAsString()));
            }
            case "ChangeType": {
                return Optional.ofNullable(clazz.cast(this.changeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterType;
        private String parameterValue;
        private List<NodeTypeSpecificValue> nodeTypeSpecificValues = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String source;
        private String dataType;
        private String allowedValues;
        private String isModifiable;
        private String changeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.parameterName(model.parameterName);
            this.parameterType(model.parameterType);
            this.parameterValue(model.parameterValue);
            this.nodeTypeSpecificValues(model.nodeTypeSpecificValues);
            this.description(model.description);
            this.source(model.source);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.isModifiable(model.isModifiable);
            this.changeType(model.changeType);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterTypeAsString() {
            return this.parameterType;
        }

        @Override
        public final Builder parameterType(String parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        @Override
        public final Builder parameterType(ParameterType parameterType) {
            this.parameterType(parameterType.toString());
            return this;
        }

        public final void setParameterType(String parameterType) {
            this.parameterType = parameterType;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final Collection<NodeTypeSpecificValue.Builder> getNodeTypeSpecificValues() {
            return this.nodeTypeSpecificValues != null ? (Collection)this.nodeTypeSpecificValues.stream().map(NodeTypeSpecificValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copy(nodeTypeSpecificValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeTypeSpecificValues(NodeTypeSpecificValue ... nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues(Arrays.asList(nodeTypeSpecificValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeTypeSpecificValues(Consumer<NodeTypeSpecificValue.Builder> ... nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues(Stream.of(nodeTypeSpecificValues).map(c -> (NodeTypeSpecificValue)((NodeTypeSpecificValue.Builder)NodeTypeSpecificValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNodeTypeSpecificValues(Collection<NodeTypeSpecificValue.BuilderImpl> nodeTypeSpecificValues) {
            this.nodeTypeSpecificValues = NodeTypeSpecificValueListCopier.copyFromBuilder(nodeTypeSpecificValues);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final String getIsModifiableAsString() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        @Override
        public final Builder isModifiable(IsModifiable isModifiable) {
            this.isModifiable(isModifiable.toString());
            return this;
        }

        public final void setIsModifiable(String isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getChangeTypeAsString() {
            return this.changeType;
        }

        @Override
        public final Builder changeType(String changeType) {
            this.changeType = changeType;
            return this;
        }

        @Override
        public final Builder changeType(ChangeType changeType) {
            this.changeType(changeType.toString());
            return this;
        }

        public final void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public Parameter build() {
            return new Parameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameter> {
        public Builder parameterName(String var1);

        public Builder parameterType(String var1);

        public Builder parameterType(ParameterType var1);

        public Builder parameterValue(String var1);

        public Builder nodeTypeSpecificValues(Collection<NodeTypeSpecificValue> var1);

        public Builder nodeTypeSpecificValues(NodeTypeSpecificValue ... var1);

        public Builder nodeTypeSpecificValues(Consumer<NodeTypeSpecificValue.Builder> ... var1);

        public Builder description(String var1);

        public Builder source(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder isModifiable(String var1);

        public Builder isModifiable(IsModifiable var1);

        public Builder changeType(String var1);

        public Builder changeType(ChangeType var1);
    }
}

