/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dax.model.ClusterEndpointEncryptionType;
import software.amazon.awssdk.services.dax.model.Endpoint;
import software.amazon.awssdk.services.dax.model.Node;
import software.amazon.awssdk.services.dax.model.NodeIdentifierListCopier;
import software.amazon.awssdk.services.dax.model.NodeListCopier;
import software.amazon.awssdk.services.dax.model.NotificationConfiguration;
import software.amazon.awssdk.services.dax.model.ParameterGroupStatus;
import software.amazon.awssdk.services.dax.model.SSEDescription;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembership;
import software.amazon.awssdk.services.dax.model.SecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(Cluster.getter(Cluster::clusterName)).setter(Cluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Cluster.getter(Cluster::description)).setter(Cluster.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(Cluster.getter(Cluster::clusterArn)).setter(Cluster.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<Integer> TOTAL_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalNodes").getter(Cluster.getter(Cluster::totalNodes)).setter(Cluster.setter(Builder::totalNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNodes").build()}).build();
    private static final SdkField<Integer> ACTIVE_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActiveNodes").getter(Cluster.getter(Cluster::activeNodes)).setter(Cluster.setter(Builder::activeNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveNodes").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(Cluster.getter(Cluster::nodeType)).setter(Cluster.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Cluster.getter(Cluster::status)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Endpoint> CLUSTER_DISCOVERY_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterDiscoveryEndpoint").getter(Cluster.getter(Cluster::clusterDiscoveryEndpoint)).setter(Cluster.setter(Builder::clusterDiscoveryEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterDiscoveryEndpoint").build()}).build();
    private static final SdkField<List<String>> NODE_IDS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodeIdsToRemove").getter(Cluster.getter(Cluster::nodeIdsToRemove)).setter(Cluster.setter(Builder::nodeIdsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIdsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Node>> NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Nodes").getter(Cluster.getter(Cluster::nodes)).setter(Cluster.setter(Builder::nodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Node::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(Cluster.getter(Cluster::preferredMaintenanceWindow)).setter(Cluster.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationConfiguration").getter(Cluster.getter(Cluster::notificationConfiguration)).setter(Cluster.setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroup").getter(Cluster.getter(Cluster::subnetGroup)).setter(Cluster.setter(Builder::subnetGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroup").build()}).build();
    private static final SdkField<List<SecurityGroupMembership>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(Cluster.getter(Cluster::securityGroups)).setter(Cluster.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(Cluster.getter(Cluster::iamRoleArn)).setter(Cluster.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<ParameterGroupStatus> PARAMETER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParameterGroup").getter(Cluster.getter(Cluster::parameterGroup)).setter(Cluster.setter(Builder::parameterGroup)).constructor(ParameterGroupStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroup").build()}).build();
    private static final SdkField<SSEDescription> SSE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SSEDescription").getter(Cluster.getter(Cluster::sseDescription)).setter(Cluster.setter(Builder::sseDescription)).constructor(SSEDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEDescription").build()}).build();
    private static final SdkField<String> CLUSTER_ENDPOINT_ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterEndpointEncryptionType").getter(Cluster.getter(Cluster::clusterEndpointEncryptionTypeAsString)).setter(Cluster.setter(Builder::clusterEndpointEncryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpointEncryptionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, DESCRIPTION_FIELD, CLUSTER_ARN_FIELD, TOTAL_NODES_FIELD, ACTIVE_NODES_FIELD, NODE_TYPE_FIELD, STATUS_FIELD, CLUSTER_DISCOVERY_ENDPOINT_FIELD, NODE_IDS_TO_REMOVE_FIELD, NODES_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, NOTIFICATION_CONFIGURATION_FIELD, SUBNET_GROUP_FIELD, SECURITY_GROUPS_FIELD, IAM_ROLE_ARN_FIELD, PARAMETER_GROUP_FIELD, SSE_DESCRIPTION_FIELD, CLUSTER_ENDPOINT_ENCRYPTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Cluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterName;
    private final String description;
    private final String clusterArn;
    private final Integer totalNodes;
    private final Integer activeNodes;
    private final String nodeType;
    private final String status;
    private final Endpoint clusterDiscoveryEndpoint;
    private final List<String> nodeIdsToRemove;
    private final List<Node> nodes;
    private final String preferredMaintenanceWindow;
    private final NotificationConfiguration notificationConfiguration;
    private final String subnetGroup;
    private final List<SecurityGroupMembership> securityGroups;
    private final String iamRoleArn;
    private final ParameterGroupStatus parameterGroup;
    private final SSEDescription sseDescription;
    private final String clusterEndpointEncryptionType;

    private Cluster(BuilderImpl builder) {
        this.clusterName = builder.clusterName;
        this.description = builder.description;
        this.clusterArn = builder.clusterArn;
        this.totalNodes = builder.totalNodes;
        this.activeNodes = builder.activeNodes;
        this.nodeType = builder.nodeType;
        this.status = builder.status;
        this.clusterDiscoveryEndpoint = builder.clusterDiscoveryEndpoint;
        this.nodeIdsToRemove = builder.nodeIdsToRemove;
        this.nodes = builder.nodes;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.subnetGroup = builder.subnetGroup;
        this.securityGroups = builder.securityGroups;
        this.iamRoleArn = builder.iamRoleArn;
        this.parameterGroup = builder.parameterGroup;
        this.sseDescription = builder.sseDescription;
        this.clusterEndpointEncryptionType = builder.clusterEndpointEncryptionType;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String description() {
        return this.description;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final Integer totalNodes() {
        return this.totalNodes;
    }

    public final Integer activeNodes() {
        return this.activeNodes;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String status() {
        return this.status;
    }

    public final Endpoint clusterDiscoveryEndpoint() {
        return this.clusterDiscoveryEndpoint;
    }

    public final boolean hasNodeIdsToRemove() {
        return this.nodeIdsToRemove != null && !(this.nodeIdsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> nodeIdsToRemove() {
        return this.nodeIdsToRemove;
    }

    public final boolean hasNodes() {
        return this.nodes != null && !(this.nodes instanceof SdkAutoConstructList);
    }

    public final List<Node> nodes() {
        return this.nodes;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final NotificationConfiguration notificationConfiguration() {
        return this.notificationConfiguration;
    }

    public final String subnetGroup() {
        return this.subnetGroup;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupMembership> securityGroups() {
        return this.securityGroups;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final ParameterGroupStatus parameterGroup() {
        return this.parameterGroup;
    }

    public final SSEDescription sseDescription() {
        return this.sseDescription;
    }

    public final ClusterEndpointEncryptionType clusterEndpointEncryptionType() {
        return ClusterEndpointEncryptionType.fromValue(this.clusterEndpointEncryptionType);
    }

    public final String clusterEndpointEncryptionTypeAsString() {
        return this.clusterEndpointEncryptionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterDiscoveryEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeIdsToRemove() ? this.nodeIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodes() ? this.nodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEndpointEncryptionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.totalNodes(), other.totalNodes()) && Objects.equals(this.activeNodes(), other.activeNodes()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.clusterDiscoveryEndpoint(), other.clusterDiscoveryEndpoint()) && this.hasNodeIdsToRemove() == other.hasNodeIdsToRemove() && Objects.equals(this.nodeIdsToRemove(), other.nodeIdsToRemove()) && this.hasNodes() == other.hasNodes() && Objects.equals(this.nodes(), other.nodes()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.notificationConfiguration(), other.notificationConfiguration()) && Objects.equals(this.subnetGroup(), other.subnetGroup()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.parameterGroup(), other.parameterGroup()) && Objects.equals(this.sseDescription(), other.sseDescription()) && Objects.equals(this.clusterEndpointEncryptionTypeAsString(), other.clusterEndpointEncryptionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("ClusterName", (Object)this.clusterName()).add("Description", (Object)this.description()).add("ClusterArn", (Object)this.clusterArn()).add("TotalNodes", (Object)this.totalNodes()).add("ActiveNodes", (Object)this.activeNodes()).add("NodeType", (Object)this.nodeType()).add("Status", (Object)this.status()).add("ClusterDiscoveryEndpoint", (Object)this.clusterDiscoveryEndpoint()).add("NodeIdsToRemove", this.hasNodeIdsToRemove() ? this.nodeIdsToRemove() : null).add("Nodes", this.hasNodes() ? this.nodes() : null).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("NotificationConfiguration", (Object)this.notificationConfiguration()).add("SubnetGroup", (Object)this.subnetGroup()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("IamRoleArn", (Object)this.iamRoleArn()).add("ParameterGroup", (Object)this.parameterGroup()).add("SSEDescription", (Object)this.sseDescription()).add("ClusterEndpointEncryptionType", (Object)this.clusterEndpointEncryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "TotalNodes": {
                return Optional.ofNullable(clazz.cast(this.totalNodes()));
            }
            case "ActiveNodes": {
                return Optional.ofNullable(clazz.cast(this.activeNodes()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ClusterDiscoveryEndpoint": {
                return Optional.ofNullable(clazz.cast(this.clusterDiscoveryEndpoint()));
            }
            case "NodeIdsToRemove": {
                return Optional.ofNullable(clazz.cast(this.nodeIdsToRemove()));
            }
            case "Nodes": {
                return Optional.ofNullable(clazz.cast(this.nodes()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "NotificationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.notificationConfiguration()));
            }
            case "SubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.subnetGroup()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "ParameterGroup": {
                return Optional.ofNullable(clazz.cast(this.parameterGroup()));
            }
            case "SSEDescription": {
                return Optional.ofNullable(clazz.cast(this.sseDescription()));
            }
            case "ClusterEndpointEncryptionType": {
                return Optional.ofNullable(clazz.cast(this.clusterEndpointEncryptionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("TotalNodes", TOTAL_NODES_FIELD);
        map.put("ActiveNodes", ACTIVE_NODES_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ClusterDiscoveryEndpoint", CLUSTER_DISCOVERY_ENDPOINT_FIELD);
        map.put("NodeIdsToRemove", NODE_IDS_TO_REMOVE_FIELD);
        map.put("Nodes", NODES_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("NotificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        map.put("SubnetGroup", SUBNET_GROUP_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("ParameterGroup", PARAMETER_GROUP_FIELD);
        map.put("SSEDescription", SSE_DESCRIPTION_FIELD);
        map.put("ClusterEndpointEncryptionType", CLUSTER_ENDPOINT_ENCRYPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterName;
        private String description;
        private String clusterArn;
        private Integer totalNodes;
        private Integer activeNodes;
        private String nodeType;
        private String status;
        private Endpoint clusterDiscoveryEndpoint;
        private List<String> nodeIdsToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<Node> nodes = DefaultSdkAutoConstructList.getInstance();
        private String preferredMaintenanceWindow;
        private NotificationConfiguration notificationConfiguration;
        private String subnetGroup;
        private List<SecurityGroupMembership> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String iamRoleArn;
        private ParameterGroupStatus parameterGroup;
        private SSEDescription sseDescription;
        private String clusterEndpointEncryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterName(model.clusterName);
            this.description(model.description);
            this.clusterArn(model.clusterArn);
            this.totalNodes(model.totalNodes);
            this.activeNodes(model.activeNodes);
            this.nodeType(model.nodeType);
            this.status(model.status);
            this.clusterDiscoveryEndpoint(model.clusterDiscoveryEndpoint);
            this.nodeIdsToRemove(model.nodeIdsToRemove);
            this.nodes(model.nodes);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.notificationConfiguration(model.notificationConfiguration);
            this.subnetGroup(model.subnetGroup);
            this.securityGroups(model.securityGroups);
            this.iamRoleArn(model.iamRoleArn);
            this.parameterGroup(model.parameterGroup);
            this.sseDescription(model.sseDescription);
            this.clusterEndpointEncryptionType(model.clusterEndpointEncryptionType);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Integer getTotalNodes() {
            return this.totalNodes;
        }

        public final void setTotalNodes(Integer totalNodes) {
            this.totalNodes = totalNodes;
        }

        @Override
        public final Builder totalNodes(Integer totalNodes) {
            this.totalNodes = totalNodes;
            return this;
        }

        public final Integer getActiveNodes() {
            return this.activeNodes;
        }

        public final void setActiveNodes(Integer activeNodes) {
            this.activeNodes = activeNodes;
        }

        @Override
        public final Builder activeNodes(Integer activeNodes) {
            this.activeNodes = activeNodes;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Endpoint.Builder getClusterDiscoveryEndpoint() {
            return this.clusterDiscoveryEndpoint != null ? this.clusterDiscoveryEndpoint.toBuilder() : null;
        }

        public final void setClusterDiscoveryEndpoint(Endpoint.BuilderImpl clusterDiscoveryEndpoint) {
            this.clusterDiscoveryEndpoint = clusterDiscoveryEndpoint != null ? clusterDiscoveryEndpoint.build() : null;
        }

        @Override
        public final Builder clusterDiscoveryEndpoint(Endpoint clusterDiscoveryEndpoint) {
            this.clusterDiscoveryEndpoint = clusterDiscoveryEndpoint;
            return this;
        }

        public final Collection<String> getNodeIdsToRemove() {
            if (this.nodeIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeIdsToRemove;
        }

        public final void setNodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
        }

        @Override
        public final Builder nodeIdsToRemove(Collection<String> nodeIdsToRemove) {
            this.nodeIdsToRemove = NodeIdentifierListCopier.copy(nodeIdsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIdsToRemove(String ... nodeIdsToRemove) {
            this.nodeIdsToRemove(Arrays.asList(nodeIdsToRemove));
            return this;
        }

        public final List<Node.Builder> getNodes() {
            List<Node.Builder> result = NodeListCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<Node.BuilderImpl> nodes) {
            this.nodes = NodeListCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<Node> nodes) {
            this.nodes = NodeListCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Node ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<Node.Builder> ... nodes) {
            this.nodes(Stream.of(nodes).map(c -> (Node)((Node.Builder)Node.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return this.notificationConfiguration != null ? this.notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final String getSubnetGroup() {
            return this.subnetGroup;
        }

        public final void setSubnetGroup(String subnetGroup) {
            this.subnetGroup = subnetGroup;
        }

        @Override
        public final Builder subnetGroup(String subnetGroup) {
            this.subnetGroup = subnetGroup;
            return this;
        }

        public final List<SecurityGroupMembership.Builder> getSecurityGroups() {
            List<SecurityGroupMembership.Builder> result = SecurityGroupMembershipListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (SecurityGroupMembership)((SecurityGroupMembership.Builder)SecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final ParameterGroupStatus.Builder getParameterGroup() {
            return this.parameterGroup != null ? this.parameterGroup.toBuilder() : null;
        }

        public final void setParameterGroup(ParameterGroupStatus.BuilderImpl parameterGroup) {
            this.parameterGroup = parameterGroup != null ? parameterGroup.build() : null;
        }

        @Override
        public final Builder parameterGroup(ParameterGroupStatus parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public final SSEDescription.Builder getSseDescription() {
            return this.sseDescription != null ? this.sseDescription.toBuilder() : null;
        }

        public final void setSseDescription(SSEDescription.BuilderImpl sseDescription) {
            this.sseDescription = sseDescription != null ? sseDescription.build() : null;
        }

        @Override
        public final Builder sseDescription(SSEDescription sseDescription) {
            this.sseDescription = sseDescription;
            return this;
        }

        public final String getClusterEndpointEncryptionType() {
            return this.clusterEndpointEncryptionType;
        }

        public final void setClusterEndpointEncryptionType(String clusterEndpointEncryptionType) {
            this.clusterEndpointEncryptionType = clusterEndpointEncryptionType;
        }

        @Override
        public final Builder clusterEndpointEncryptionType(String clusterEndpointEncryptionType) {
            this.clusterEndpointEncryptionType = clusterEndpointEncryptionType;
            return this;
        }

        @Override
        public final Builder clusterEndpointEncryptionType(ClusterEndpointEncryptionType clusterEndpointEncryptionType) {
            this.clusterEndpointEncryptionType(clusterEndpointEncryptionType == null ? null : clusterEndpointEncryptionType.toString());
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder clusterName(String var1);

        public Builder description(String var1);

        public Builder clusterArn(String var1);

        public Builder totalNodes(Integer var1);

        public Builder activeNodes(Integer var1);

        public Builder nodeType(String var1);

        public Builder status(String var1);

        public Builder clusterDiscoveryEndpoint(Endpoint var1);

        default public Builder clusterDiscoveryEndpoint(Consumer<Endpoint.Builder> clusterDiscoveryEndpoint) {
            return this.clusterDiscoveryEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(clusterDiscoveryEndpoint)).build());
        }

        public Builder nodeIdsToRemove(Collection<String> var1);

        public Builder nodeIdsToRemove(String ... var1);

        public Builder nodes(Collection<Node> var1);

        public Builder nodes(Node ... var1);

        public Builder nodes(Consumer<Node.Builder> ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder notificationConfiguration(NotificationConfiguration var1);

        default public Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return this.notificationConfiguration((NotificationConfiguration)((NotificationConfiguration.Builder)NotificationConfiguration.builder().applyMutation(notificationConfiguration)).build());
        }

        public Builder subnetGroup(String var1);

        public Builder securityGroups(Collection<SecurityGroupMembership> var1);

        public Builder securityGroups(SecurityGroupMembership ... var1);

        public Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... var1);

        public Builder iamRoleArn(String var1);

        public Builder parameterGroup(ParameterGroupStatus var1);

        default public Builder parameterGroup(Consumer<ParameterGroupStatus.Builder> parameterGroup) {
            return this.parameterGroup((ParameterGroupStatus)((ParameterGroupStatus.Builder)ParameterGroupStatus.builder().applyMutation(parameterGroup)).build());
        }

        public Builder sseDescription(SSEDescription var1);

        default public Builder sseDescription(Consumer<SSEDescription.Builder> sseDescription) {
            return this.sseDescription((SSEDescription)((SSEDescription.Builder)SSEDescription.builder().applyMutation(sseDescription)).build());
        }

        public Builder clusterEndpointEncryptionType(String var1);

        public Builder clusterEndpointEncryptionType(ClusterEndpointEncryptionType var1);
    }
}

