/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dax.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceName").getter(Event.getter(Event::sourceName)).setter(Event.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(Event.getter(Event::sourceTypeAsString)).setter(Event.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(Event.getter(Event::message)).setter(Event.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Date").getter(Event.getter(Event::date)).setter(Event.setter(Builder::date)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NAME_FIELD, SOURCE_TYPE_FIELD, MESSAGE_FIELD, DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceName;
    private final String sourceType;
    private final String message;
    private final Instant date;

    private Event(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.sourceType = builder.sourceType;
        this.message = builder.message;
        this.date = builder.date;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public String message() {
        return this.message;
    }

    public Instant date() {
        return this.date;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.date(), other.date());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("SourceName", (Object)this.sourceName()).add("SourceType", (Object)this.sourceTypeAsString()).add("Message", (Object)this.message()).add("Date", (Object)this.date()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "Date": {
                return Optional.ofNullable(clazz.cast(this.date()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceName;
        private String sourceType;
        private String message;
        private Instant date;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.sourceName(model.sourceName);
            this.sourceType(model.sourceType);
            this.message(model.message);
            this.date(model.date);
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder sourceName(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder message(String var1);

        public Builder date(Instant var1);
    }
}

