/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AttributeEntityType;
import software.amazon.awssdk.services.datazone.model.AttributesListCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAttributesMetadataRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, BatchGetAttributesMetadataRequest> {
    private static final SdkField<List<String>> ATTRIBUTE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeIdentifiers").getter(BatchGetAttributesMetadataRequest.getter(BatchGetAttributesMetadataRequest::attributeIdentifiers)).setter(BatchGetAttributesMetadataRequest.setter(Builder::attributeIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("attributeIdentifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(BatchGetAttributesMetadataRequest.getter(BatchGetAttributesMetadataRequest::domainIdentifier)).setter(BatchGetAttributesMetadataRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityIdentifier").getter(BatchGetAttributesMetadataRequest.getter(BatchGetAttributesMetadataRequest::entityIdentifier)).setter(BatchGetAttributesMetadataRequest.setter(Builder::entityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityRevision").getter(BatchGetAttributesMetadataRequest.getter(BatchGetAttributesMetadataRequest::entityRevision)).setter(BatchGetAttributesMetadataRequest.setter(Builder::entityRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("entityRevision").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(BatchGetAttributesMetadataRequest.getter(BatchGetAttributesMetadataRequest::entityTypeAsString)).setter(BatchGetAttributesMetadataRequest.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_IDENTIFIERS_FIELD, DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAttributesMetadataRequest.memberNameToFieldInitializer();
    private final List<String> attributeIdentifiers;
    private final String domainIdentifier;
    private final String entityIdentifier;
    private final String entityRevision;
    private final String entityType;

    private BatchGetAttributesMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.attributeIdentifiers = builder.attributeIdentifiers;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
    }

    public final boolean hasAttributeIdentifiers() {
        return this.attributeIdentifiers != null && !(this.attributeIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> attributeIdentifiers() {
        return this.attributeIdentifiers;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final String entityRevision() {
        return this.entityRevision;
    }

    public final AttributeEntityType entityType() {
        return AttributeEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeIdentifiers() ? this.attributeIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttributesMetadataRequest)) {
            return false;
        }
        BatchGetAttributesMetadataRequest other = (BatchGetAttributesMetadataRequest)((Object)obj);
        return this.hasAttributeIdentifiers() == other.hasAttributeIdentifiers() && Objects.equals(this.attributeIdentifiers(), other.attributeIdentifiers()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityRevision(), other.entityRevision()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAttributesMetadataRequest").add("AttributeIdentifiers", this.hasAttributeIdentifiers() ? this.attributeIdentifiers() : null).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EntityIdentifier", (Object)this.entityIdentifier()).add("EntityRevision", (Object)this.entityRevision()).add("EntityType", (Object)this.entityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributeIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.attributeIdentifiers()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "entityRevision": {
                return Optional.ofNullable(clazz.cast(this.entityRevision()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attributeIdentifier", ATTRIBUTE_IDENTIFIERS_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityRevision", ENTITY_REVISION_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttributesMetadataRequest, T> g) {
        return obj -> g.apply((BatchGetAttributesMetadataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<String> attributeIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String domainIdentifier;
        private String entityIdentifier;
        private String entityRevision;
        private String entityType;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttributesMetadataRequest model) {
            super(model);
            this.attributeIdentifiers(model.attributeIdentifiers);
            this.domainIdentifier(model.domainIdentifier);
            this.entityIdentifier(model.entityIdentifier);
            this.entityRevision(model.entityRevision);
            this.entityType(model.entityType);
        }

        public final Collection<String> getAttributeIdentifiers() {
            if (this.attributeIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeIdentifiers;
        }

        public final void setAttributeIdentifiers(Collection<String> attributeIdentifiers) {
            this.attributeIdentifiers = AttributesListCopier.copy(attributeIdentifiers);
        }

        @Override
        public final Builder attributeIdentifiers(Collection<String> attributeIdentifiers) {
            this.attributeIdentifiers = AttributesListCopier.copy(attributeIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeIdentifiers(String ... attributeIdentifiers) {
            this.attributeIdentifiers(Arrays.asList(attributeIdentifiers));
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityRevision() {
            return this.entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(AttributeEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAttributesMetadataRequest build() {
            return new BatchGetAttributesMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAttributesMetadataRequest> {
        public Builder attributeIdentifiers(Collection<String> var1);

        public Builder attributeIdentifiers(String ... var1);

        public Builder domainIdentifier(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityRevision(String var1);

        public Builder entityType(String var1);

        public Builder entityType(AttributeEntityType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

