/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.RowFilterExpression;
import software.amazon.awssdk.services.datazone.model.RowFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RowFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RowFilter> {
    private static final SdkField<List<RowFilter>> AND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("and").getter(RowFilter.getter(RowFilter::and)).setter(RowFilter.setter(Builder::and)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RowFilterExpression> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("expression").getter(RowFilter.getter(RowFilter::expression)).setter(RowFilter.setter(Builder::expression)).constructor(RowFilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<List<RowFilter>> OR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("or").getter(RowFilter.getter(RowFilter::or)).setter(RowFilter.setter(Builder::or)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD, EXPRESSION_FIELD, OR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RowFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RowFilter> and;
    private final RowFilterExpression expression;
    private final List<RowFilter> or;
    private final Type type;

    private RowFilter(BuilderImpl builder) {
        this.and = builder.and;
        this.expression = builder.expression;
        this.or = builder.or;
        this.type = builder.type;
    }

    public final boolean hasAnd() {
        return this.and != null && !(this.and instanceof SdkAutoConstructList);
    }

    public final List<RowFilter> and() {
        return this.and;
    }

    public final RowFilterExpression expression() {
        return this.expression;
    }

    public final boolean hasOr() {
        return this.or != null && !(this.or instanceof SdkAutoConstructList);
    }

    public final List<RowFilter> or() {
        return this.or;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnd() ? this.and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOr() ? this.or() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowFilter)) {
            return false;
        }
        RowFilter other = (RowFilter)obj;
        return this.hasAnd() == other.hasAnd() && Objects.equals(this.and(), other.and()) && Objects.equals(this.expression(), other.expression()) && this.hasOr() == other.hasOr() && Objects.equals(this.or(), other.or());
    }

    public final String toString() {
        return ToString.builder((String)"RowFilter").add("And", this.hasAnd() ? this.and() : null).add("Expression", (Object)this.expression()).add("Or", this.hasOr() ? this.or() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "and": {
                return Optional.ofNullable(clazz.cast(this.and()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "or": {
                return Optional.ofNullable(clazz.cast(this.or()));
            }
        }
        return Optional.empty();
    }

    public static RowFilter fromAnd(List<RowFilter> and) {
        return (RowFilter)RowFilter.builder().and(and).build();
    }

    public static RowFilter fromExpression(RowFilterExpression expression) {
        return (RowFilter)RowFilter.builder().expression(expression).build();
    }

    public static RowFilter fromExpression(Consumer<RowFilterExpression.Builder> expression) {
        RowFilterExpression.Builder builder = RowFilterExpression.builder();
        expression.accept(builder);
        return RowFilter.fromExpression((RowFilterExpression)builder.build());
    }

    public static RowFilter fromOr(List<RowFilter> or) {
        return (RowFilter)RowFilter.builder().or(or).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("and", AND_FIELD);
        map.put("expression", EXPRESSION_FIELD);
        map.put("or", OR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RowFilter, T> g) {
        return obj -> g.apply((RowFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AND,
        EXPRESSION,
        OR,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<RowFilter> and = DefaultSdkAutoConstructList.getInstance();
        private RowFilterExpression expression;
        private List<RowFilter> or = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RowFilter model) {
            this.and(model.and);
            this.expression(model.expression);
            this.or(model.or);
        }

        public final List<Builder> getAnd() {
            List<Builder> result = RowFilterListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            List<RowFilter> oldValue = this.and;
            this.and = RowFilterListCopier.copyFromBuilder(and);
            this.handleUnionValueChange(Type.AND, oldValue, this.and);
        }

        @Override
        public final Builder and(Collection<RowFilter> and) {
            List<RowFilter> oldValue = this.and;
            this.and = RowFilterListCopier.copy(and);
            this.handleUnionValueChange(Type.AND, oldValue, this.and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(RowFilter ... and) {
            this.and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder> ... and) {
            this.and(Stream.of(and).map(c -> (RowFilter)((Builder)RowFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RowFilterExpression.Builder getExpression() {
            return this.expression != null ? this.expression.toBuilder() : null;
        }

        public final void setExpression(RowFilterExpression.BuilderImpl expression) {
            RowFilterExpression oldValue = this.expression;
            this.expression = expression != null ? expression.build() : null;
            this.handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
        }

        @Override
        public final Builder expression(RowFilterExpression expression) {
            RowFilterExpression oldValue = this.expression;
            this.expression = expression;
            this.handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
            return this;
        }

        public final List<Builder> getOr() {
            List<Builder> result = RowFilterListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            List<RowFilter> oldValue = this.or;
            this.or = RowFilterListCopier.copyFromBuilder(or);
            this.handleUnionValueChange(Type.OR, oldValue, this.or);
        }

        @Override
        public final Builder or(Collection<RowFilter> or) {
            List<RowFilter> oldValue = this.or;
            this.or = RowFilterListCopier.copy(or);
            this.handleUnionValueChange(Type.OR, oldValue, this.or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(RowFilter ... or) {
            this.or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder> ... or) {
            this.or(Stream.of(or).map(c -> (RowFilter)((Builder)RowFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RowFilter build() {
            return new RowFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RowFilter> {
        public Builder and(Collection<RowFilter> var1);

        public Builder and(RowFilter ... var1);

        public Builder and(Consumer<Builder> ... var1);

        public Builder expression(RowFilterExpression var1);

        default public Builder expression(Consumer<RowFilterExpression.Builder> expression) {
            return this.expression((RowFilterExpression)((RowFilterExpression.Builder)RowFilterExpression.builder().applyMutation(expression)).build());
        }

        public Builder or(Collection<RowFilter> var1);

        public Builder or(RowFilter ... var1);

        public Builder or(Consumer<Builder> ... var1);
    }
}

