/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectPredictionsRequest extends DataZoneRequest implements
        ToCopyableBuilder<RejectPredictionsRequest.Builder, RejectPredictionsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(RejectPredictionsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(RejectPredictionsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(RejectPredictionsRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<List<RejectChoice>> REJECT_CHOICES_FIELD = SdkField
            .<List<RejectChoice>> builder(MarshallingType.LIST)
            .memberName("rejectChoices")
            .getter(getter(RejectPredictionsRequest::rejectChoices))
            .setter(setter(Builder::rejectChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RejectChoice> builder(MarshallingType.SDK_POJO)
                                            .constructor(RejectChoice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RejectRule> REJECT_RULE_FIELD = SdkField.<RejectRule> builder(MarshallingType.SDK_POJO)
            .memberName("rejectRule").getter(getter(RejectPredictionsRequest::rejectRule)).setter(setter(Builder::rejectRule))
            .constructor(RejectRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectRule").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(RejectPredictionsRequest::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, REJECT_CHOICES_FIELD, REJECT_RULE_FIELD, REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String domainIdentifier;

    private final String identifier;

    private final List<RejectChoice> rejectChoices;

    private final RejectRule rejectRule;

    private final String revision;

    private RejectPredictionsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.rejectChoices = builder.rejectChoices;
        this.rejectRule = builder.rejectRule;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The identifier of the prediction.
     * </p>
     * 
     * @return The identifier of the prediction.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the RejectChoices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRejectChoices() {
        return rejectChoices != null && !(rejectChoices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
     * column name) that can be rejected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRejectChoices} method.
     * </p>
     * 
     * @return Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for
     *         example, a column name) that can be rejected.
     */
    public final List<RejectChoice> rejectChoices() {
        return rejectChoices;
    }

    /**
     * <p>
     * Specifies the rule (or the conditions) under which a prediction can be rejected.
     * </p>
     * 
     * @return Specifies the rule (or the conditions) under which a prediction can be rejected.
     */
    public final RejectRule rejectRule() {
        return rejectRule;
    }

    /**
     * <p>
     * The revision that is to be made to the asset.
     * </p>
     * 
     * @return The revision that is to be made to the asset.
     */
    public final String revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasRejectChoices() ? rejectChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rejectRule());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectPredictionsRequest)) {
            return false;
        }
        RejectPredictionsRequest other = (RejectPredictionsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier()) && hasRejectChoices() == other.hasRejectChoices()
                && Objects.equals(rejectChoices(), other.rejectChoices()) && Objects.equals(rejectRule(), other.rejectRule())
                && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RejectPredictionsRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("Identifier", identifier())
                .add("RejectChoices", hasRejectChoices() ? rejectChoices() : null).add("RejectRule", rejectRule())
                .add("Revision", revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "rejectChoices":
            return Optional.ofNullable(clazz.cast(rejectChoices()));
        case "rejectRule":
            return Optional.ofNullable(clazz.cast(rejectRule()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("rejectChoices", REJECT_CHOICES_FIELD);
        map.put("rejectRule", REJECT_RULE_FIELD);
        map.put("revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RejectPredictionsRequest, T> g) {
        return obj -> g.apply((RejectPredictionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, RejectPredictionsRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The identifier of the prediction.
         * </p>
         * 
         * @param identifier
         *        The identifier of the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
         * column name) that can be rejected.
         * </p>
         * 
         * @param rejectChoices
         *        Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for
         *        example, a column name) that can be rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectChoices(Collection<RejectChoice> rejectChoices);

        /**
         * <p>
         * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
         * column name) that can be rejected.
         * </p>
         * 
         * @param rejectChoices
         *        Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for
         *        example, a column name) that can be rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectChoices(RejectChoice... rejectChoices);

        /**
         * <p>
         * Specifies the prediction (aka, the automatically generated piece of metadata) and the target (for example, a
         * column name) that can be rejected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.RejectChoice.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.RejectChoice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.RejectChoice.Builder#build()} is called immediately and
         * its result is passed to {@link #rejectChoices(List<RejectChoice>)}.
         * 
         * @param rejectChoices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.RejectChoice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectChoices(java.util.Collection<RejectChoice>)
         */
        Builder rejectChoices(Consumer<RejectChoice.Builder>... rejectChoices);

        /**
         * <p>
         * Specifies the rule (or the conditions) under which a prediction can be rejected.
         * </p>
         * 
         * @param rejectRule
         *        Specifies the rule (or the conditions) under which a prediction can be rejected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectRule(RejectRule rejectRule);

        /**
         * <p>
         * Specifies the rule (or the conditions) under which a prediction can be rejected.
         * </p>
         * This is a convenience method that creates an instance of the {@link RejectRule.Builder} avoiding the need to
         * create one manually via {@link RejectRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RejectRule.Builder#build()} is called immediately and its result
         * is passed to {@link #rejectRule(RejectRule)}.
         * 
         * @param rejectRule
         *        a consumer that will call methods on {@link RejectRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectRule(RejectRule)
         */
        default Builder rejectRule(Consumer<RejectRule.Builder> rejectRule) {
            return rejectRule(RejectRule.builder().applyMutation(rejectRule).build());
        }

        /**
         * <p>
         * The revision that is to be made to the asset.
         * </p>
         * 
         * @param revision
         *        The revision that is to be made to the asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private String identifier;

        private List<RejectChoice> rejectChoices = DefaultSdkAutoConstructList.getInstance();

        private RejectRule rejectRule;

        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectPredictionsRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            rejectChoices(model.rejectChoices);
            rejectRule(model.rejectRule);
            revision(model.revision);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<RejectChoice.Builder> getRejectChoices() {
            List<RejectChoice.Builder> result = RejectChoicesCopier.copyToBuilder(this.rejectChoices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRejectChoices(Collection<RejectChoice.BuilderImpl> rejectChoices) {
            this.rejectChoices = RejectChoicesCopier.copyFromBuilder(rejectChoices);
        }

        @Override
        public final Builder rejectChoices(Collection<RejectChoice> rejectChoices) {
            this.rejectChoices = RejectChoicesCopier.copy(rejectChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectChoices(RejectChoice... rejectChoices) {
            rejectChoices(Arrays.asList(rejectChoices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectChoices(Consumer<RejectChoice.Builder>... rejectChoices) {
            rejectChoices(Stream.of(rejectChoices).map(c -> RejectChoice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RejectRule.Builder getRejectRule() {
            return rejectRule != null ? rejectRule.toBuilder() : null;
        }

        public final void setRejectRule(RejectRule.BuilderImpl rejectRule) {
            this.rejectRule = rejectRule != null ? rejectRule.build() : null;
        }

        @Override
        public final Builder rejectRule(RejectRule rejectRule) {
            this.rejectRule = rejectRule;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectPredictionsRequest build() {
            return new RejectPredictionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
