/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the prediction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictionConfiguration.Builder, PredictionConfiguration> {
    private static final SdkField<BusinessNameGenerationConfiguration> BUSINESS_NAME_GENERATION_FIELD = SdkField
            .<BusinessNameGenerationConfiguration> builder(MarshallingType.SDK_POJO).memberName("businessNameGeneration")
            .getter(getter(PredictionConfiguration::businessNameGeneration)).setter(setter(Builder::businessNameGeneration))
            .constructor(BusinessNameGenerationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessNameGeneration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BUSINESS_NAME_GENERATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BusinessNameGenerationConfiguration businessNameGeneration;

    private PredictionConfiguration(BuilderImpl builder) {
        this.businessNameGeneration = builder.businessNameGeneration;
    }

    /**
     * <p>
     * The business name generation mechanism.
     * </p>
     * 
     * @return The business name generation mechanism.
     */
    public final BusinessNameGenerationConfiguration businessNameGeneration() {
        return businessNameGeneration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(businessNameGeneration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictionConfiguration)) {
            return false;
        }
        PredictionConfiguration other = (PredictionConfiguration) obj;
        return Objects.equals(businessNameGeneration(), other.businessNameGeneration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictionConfiguration").add("BusinessNameGeneration", businessNameGeneration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "businessNameGeneration":
            return Optional.ofNullable(clazz.cast(businessNameGeneration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("businessNameGeneration", BUSINESS_NAME_GENERATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredictionConfiguration, T> g) {
        return obj -> g.apply((PredictionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictionConfiguration> {
        /**
         * <p>
         * The business name generation mechanism.
         * </p>
         * 
         * @param businessNameGeneration
         *        The business name generation mechanism.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessNameGeneration(BusinessNameGenerationConfiguration businessNameGeneration);

        /**
         * <p>
         * The business name generation mechanism.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BusinessNameGenerationConfiguration.Builder} avoiding the need to create one manually via
         * {@link BusinessNameGenerationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BusinessNameGenerationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #businessNameGeneration(BusinessNameGenerationConfiguration)}.
         * 
         * @param businessNameGeneration
         *        a consumer that will call methods on {@link BusinessNameGenerationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessNameGeneration(BusinessNameGenerationConfiguration)
         */
        default Builder businessNameGeneration(Consumer<BusinessNameGenerationConfiguration.Builder> businessNameGeneration) {
            return businessNameGeneration(BusinessNameGenerationConfiguration.builder().applyMutation(businessNameGeneration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BusinessNameGenerationConfiguration businessNameGeneration;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictionConfiguration model) {
            businessNameGeneration(model.businessNameGeneration);
        }

        public final BusinessNameGenerationConfiguration.Builder getBusinessNameGeneration() {
            return businessNameGeneration != null ? businessNameGeneration.toBuilder() : null;
        }

        public final void setBusinessNameGeneration(BusinessNameGenerationConfiguration.BuilderImpl businessNameGeneration) {
            this.businessNameGeneration = businessNameGeneration != null ? businessNameGeneration.build() : null;
        }

        @Override
        public final Builder businessNameGeneration(BusinessNameGenerationConfiguration businessNameGeneration) {
            this.businessNameGeneration = businessNameGeneration;
            return this;
        }

        @Override
        public PredictionConfiguration build() {
            return new PredictionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
