/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a listing (aka asset published in a Amazon DataZone catalog).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListingItem implements SdkPojo, Serializable, ToCopyableBuilder<ListingItem.Builder, ListingItem> {
    private static final SdkField<AssetListing> ASSET_LISTING_FIELD = SdkField.<AssetListing> builder(MarshallingType.SDK_POJO)
            .memberName("assetListing").getter(getter(ListingItem::assetListing)).setter(setter(Builder::assetListing))
            .constructor(AssetListing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetListing").build()).build();

    private static final SdkField<DataProductListing> DATA_PRODUCT_LISTING_FIELD = SdkField
            .<DataProductListing> builder(MarshallingType.SDK_POJO).memberName("dataProductListing")
            .getter(getter(ListingItem::dataProductListing)).setter(setter(Builder::dataProductListing))
            .constructor(DataProductListing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProductListing").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_LISTING_FIELD,
            DATA_PRODUCT_LISTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssetListing assetListing;

    private final DataProductListing dataProductListing;

    private final Type type;

    private ListingItem(BuilderImpl builder) {
        this.assetListing = builder.assetListing;
        this.dataProductListing = builder.dataProductListing;
        this.type = builder.type;
    }

    /**
     * <p>
     * An asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return An asset published in an Amazon DataZone catalog.
     */
    public final AssetListing assetListing() {
        return assetListing;
    }

    /**
     * <p>
     * The data product listing.
     * </p>
     * 
     * @return The data product listing.
     */
    public final DataProductListing dataProductListing() {
        return dataProductListing;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetListing());
        hashCode = 31 * hashCode + Objects.hashCode(dataProductListing());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListingItem)) {
            return false;
        }
        ListingItem other = (ListingItem) obj;
        return Objects.equals(assetListing(), other.assetListing())
                && Objects.equals(dataProductListing(), other.dataProductListing());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListingItem").add("AssetListing", assetListing())
                .add("DataProductListing", dataProductListing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetListing":
            return Optional.ofNullable(clazz.cast(assetListing()));
        case "dataProductListing":
            return Optional.ofNullable(clazz.cast(dataProductListing()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #assetListing()} initialized to the given value.
     *
     * <p>
     * An asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @param assetListing
     *        An asset published in an Amazon DataZone catalog.
     */
    public static ListingItem fromAssetListing(AssetListing assetListing) {
        return builder().assetListing(assetListing).build();
    }

    /**
     * Create an instance of this class with {@link #assetListing()} initialized to the given value.
     *
     * <p>
     * An asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @param assetListing
     *        An asset published in an Amazon DataZone catalog.
     */
    public static ListingItem fromAssetListing(Consumer<AssetListing.Builder> assetListing) {
        AssetListing.Builder builder = AssetListing.builder();
        assetListing.accept(builder);
        return fromAssetListing(builder.build());
    }

    /**
     * Create an instance of this class with {@link #dataProductListing()} initialized to the given value.
     *
     * <p>
     * The data product listing.
     * </p>
     * 
     * @param dataProductListing
     *        The data product listing.
     */
    public static ListingItem fromDataProductListing(DataProductListing dataProductListing) {
        return builder().dataProductListing(dataProductListing).build();
    }

    /**
     * Create an instance of this class with {@link #dataProductListing()} initialized to the given value.
     *
     * <p>
     * The data product listing.
     * </p>
     * 
     * @param dataProductListing
     *        The data product listing.
     */
    public static ListingItem fromDataProductListing(Consumer<DataProductListing.Builder> dataProductListing) {
        DataProductListing.Builder builder = DataProductListing.builder();
        dataProductListing.accept(builder);
        return fromDataProductListing(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetListing", ASSET_LISTING_FIELD);
        map.put("dataProductListing", DATA_PRODUCT_LISTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListingItem, T> g) {
        return obj -> g.apply((ListingItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListingItem> {
        /**
         * <p>
         * An asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param assetListing
         *        An asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetListing(AssetListing assetListing);

        /**
         * <p>
         * An asset published in an Amazon DataZone catalog.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetListing.Builder} avoiding the need
         * to create one manually via {@link AssetListing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetListing.Builder#build()} is called immediately and its
         * result is passed to {@link #assetListing(AssetListing)}.
         * 
         * @param assetListing
         *        a consumer that will call methods on {@link AssetListing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetListing(AssetListing)
         */
        default Builder assetListing(Consumer<AssetListing.Builder> assetListing) {
            return assetListing(AssetListing.builder().applyMutation(assetListing).build());
        }

        /**
         * <p>
         * The data product listing.
         * </p>
         * 
         * @param dataProductListing
         *        The data product listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProductListing(DataProductListing dataProductListing);

        /**
         * <p>
         * The data product listing.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataProductListing.Builder} avoiding the
         * need to create one manually via {@link DataProductListing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataProductListing.Builder#build()} is called immediately and its
         * result is passed to {@link #dataProductListing(DataProductListing)}.
         * 
         * @param dataProductListing
         *        a consumer that will call methods on {@link DataProductListing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataProductListing(DataProductListing)
         */
        default Builder dataProductListing(Consumer<DataProductListing.Builder> dataProductListing) {
            return dataProductListing(DataProductListing.builder().applyMutation(dataProductListing).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssetListing assetListing;

        private DataProductListing dataProductListing;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListingItem model) {
            assetListing(model.assetListing);
            dataProductListing(model.dataProductListing);
        }

        public final AssetListing.Builder getAssetListing() {
            return assetListing != null ? assetListing.toBuilder() : null;
        }

        public final void setAssetListing(AssetListing.BuilderImpl assetListing) {
            Object oldValue = this.assetListing;
            this.assetListing = assetListing != null ? assetListing.build() : null;
            handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
        }

        @Override
        public final Builder assetListing(AssetListing assetListing) {
            Object oldValue = this.assetListing;
            this.assetListing = assetListing;
            handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
            return this;
        }

        public final DataProductListing.Builder getDataProductListing() {
            return dataProductListing != null ? dataProductListing.toBuilder() : null;
        }

        public final void setDataProductListing(DataProductListing.BuilderImpl dataProductListing) {
            Object oldValue = this.dataProductListing;
            this.dataProductListing = dataProductListing != null ? dataProductListing.build() : null;
            handleUnionValueChange(Type.DATA_PRODUCT_LISTING, oldValue, this.dataProductListing);
        }

        @Override
        public final Builder dataProductListing(DataProductListing dataProductListing) {
            Object oldValue = this.dataProductListing;
            this.dataProductListing = dataProductListing;
            handleUnionValueChange(Type.DATA_PRODUCT_LISTING, oldValue, this.dataProductListing);
            return this;
        }

        @Override
        public ListingItem build() {
            return new ListingItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ListingItem#type()
     */
    public enum Type {
        ASSET_LISTING,

        DATA_PRODUCT_LISTING,

        UNKNOWN_TO_SDK_VERSION
    }
}
