/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRulesRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListRulesRequest.Builder, ListRulesRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(ListRulesRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ruleAction").build()).build();

    private static final SdkField<List<String>> ASSET_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("assetTypes")
            .getter(getter(ListRulesRequest::assetTypes))
            .setter(setter(Builder::assetTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DATA_PRODUCT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dataProduct").getter(getter(ListRulesRequest::dataProduct)).setter(setter(Builder::dataProduct))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dataProduct").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListRulesRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Boolean> INCLUDE_CASCADED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeCascaded").getter(getter(ListRulesRequest::includeCascaded))
            .setter(setter(Builder::includeCascaded))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeCascaded").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRulesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<List<String>> PROJECT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("projectIds")
            .getter(getter(ListRulesRequest::projectIds))
            .setter(setter(Builder::projectIds))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleType").getter(getter(ListRulesRequest::ruleTypeAsString)).setter(setter(Builder::ruleType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ruleType").build()).build();

    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetIdentifier").getter(getter(ListRulesRequest::targetIdentifier))
            .setter(setter(Builder::targetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("targetIdentifier").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(ListRulesRequest::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("targetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            ASSET_TYPES_FIELD, DATA_PRODUCT_FIELD, DOMAIN_IDENTIFIER_FIELD, INCLUDE_CASCADED_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PROJECT_IDS_FIELD, RULE_TYPE_FIELD, TARGET_IDENTIFIER_FIELD, TARGET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String action;

    private final List<String> assetTypes;

    private final Boolean dataProduct;

    private final String domainIdentifier;

    private final Boolean includeCascaded;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> projectIds;

    private final String ruleType;

    private final String targetIdentifier;

    private final String targetType;

    private ListRulesRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.assetTypes = builder.assetTypes;
        this.dataProduct = builder.dataProduct;
        this.domainIdentifier = builder.domainIdentifier;
        this.includeCascaded = builder.includeCascaded;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.projectIds = builder.projectIds;
        this.ruleType = builder.ruleType;
        this.targetIdentifier = builder.targetIdentifier;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final RuleAction action() {
        return RuleAction.fromValue(action);
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAssetTypes() {
        return assetTypes != null && !(assetTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The asset types of the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetTypes} method.
     * </p>
     * 
     * @return The asset types of the rule.
     */
    public final List<String> assetTypes() {
        return assetTypes;
    }

    /**
     * <p>
     * The data product of the rule.
     * </p>
     * 
     * @return The data product of the rule.
     */
    public final Boolean dataProduct() {
        return dataProduct;
    }

    /**
     * <p>
     * The ID of the domain in which the rules are to be listed.
     * </p>
     * 
     * @return The ID of the domain in which the rules are to be listed.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * Specifies whether to include cascading rules in the results.
     * </p>
     * 
     * @return Specifies whether to include cascading rules in the results.
     */
    public final Boolean includeCascaded() {
        return includeCascaded;
    }

    /**
     * <p>
     * The maximum number of rules to return in a single call to <code>ListRules</code>. When the number of rules to be
     * listed is greater than the value of <code>MaxResults</code>, the response contains a <code>NextToken</code> value
     * that you can use in a subsequent call to <code>ListRules</code> to list the next set of rules.
     * </p>
     * 
     * @return The maximum number of rules to return in a single call to <code>ListRules</code>. When the number of
     *         rules to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     *         <code>NextToken</code> value that you can use in a subsequent call to <code>ListRules</code> to list the
     *         next set of rules.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of rules is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of rules, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>ListRules</code> to list the next set of rules.
     * </p>
     * 
     * @return When the number of rules is greater than the default value for the <code>MaxResults</code> parameter, or
     *         if you explicitly specify a value for <code>MaxResults</code> that is less than the number of rules, the
     *         response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>ListRules</code> to list the next set of
     *         rules.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProjectIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProjectIds() {
        return projectIds != null && !(projectIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of projects in which rules are to be listed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProjectIds} method.
     * </p>
     * 
     * @return The IDs of projects in which rules are to be listed.
     */
    public final List<String> projectIds() {
        return projectIds;
    }

    /**
     * <p>
     * The type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of the rule.
     * @see RuleType
     */
    public final RuleType ruleType() {
        return RuleType.fromValue(ruleType);
    }

    /**
     * <p>
     * The type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return The type of the rule.
     * @see RuleType
     */
    public final String ruleTypeAsString() {
        return ruleType;
    }

    /**
     * <p>
     * The target ID of the rule.
     * </p>
     * 
     * @return The target ID of the rule.
     */
    public final String targetIdentifier() {
        return targetIdentifier;
    }

    /**
     * <p>
     * The target type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RuleTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type of the rule.
     * @see RuleTargetType
     */
    public final RuleTargetType targetType() {
        return RuleTargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The target type of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link RuleTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The target type of the rule.
     * @see RuleTargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetTypes() ? assetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dataProduct());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(includeCascaded());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasProjectIds() ? projectIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesRequest)) {
            return false;
        }
        ListRulesRequest other = (ListRulesRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && hasAssetTypes() == other.hasAssetTypes()
                && Objects.equals(assetTypes(), other.assetTypes()) && Objects.equals(dataProduct(), other.dataProduct())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(includeCascaded(), other.includeCascaded()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && hasProjectIds() == other.hasProjectIds()
                && Objects.equals(projectIds(), other.projectIds())
                && Objects.equals(ruleTypeAsString(), other.ruleTypeAsString())
                && Objects.equals(targetIdentifier(), other.targetIdentifier())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRulesRequest").add("Action", actionAsString())
                .add("AssetTypes", hasAssetTypes() ? assetTypes() : null).add("DataProduct", dataProduct())
                .add("DomainIdentifier", domainIdentifier()).add("IncludeCascaded", includeCascaded())
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ProjectIds", hasProjectIds() ? projectIds() : null).add("RuleType", ruleTypeAsString())
                .add("TargetIdentifier", targetIdentifier()).add("TargetType", targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "assetTypes":
            return Optional.ofNullable(clazz.cast(assetTypes()));
        case "dataProduct":
            return Optional.ofNullable(clazz.cast(dataProduct()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "includeCascaded":
            return Optional.ofNullable(clazz.cast(includeCascaded()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "projectIds":
            return Optional.ofNullable(clazz.cast(projectIds()));
        case "ruleType":
            return Optional.ofNullable(clazz.cast(ruleTypeAsString()));
        case "targetIdentifier":
            return Optional.ofNullable(clazz.cast(targetIdentifier()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleAction", ACTION_FIELD);
        map.put("assetTypes", ASSET_TYPES_FIELD);
        map.put("dataProduct", DATA_PRODUCT_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("includeCascaded", INCLUDE_CASCADED_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectIds", PROJECT_IDS_FIELD);
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRulesRequest, T> g) {
        return obj -> g.apply((ListRulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRulesRequest> {
        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(RuleAction action);

        /**
         * <p>
         * The asset types of the rule.
         * </p>
         * 
         * @param assetTypes
         *        The asset types of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetTypes(Collection<String> assetTypes);

        /**
         * <p>
         * The asset types of the rule.
         * </p>
         * 
         * @param assetTypes
         *        The asset types of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetTypes(String... assetTypes);

        /**
         * <p>
         * The data product of the rule.
         * </p>
         * 
         * @param dataProduct
         *        The data product of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProduct(Boolean dataProduct);

        /**
         * <p>
         * The ID of the domain in which the rules are to be listed.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain in which the rules are to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * Specifies whether to include cascading rules in the results.
         * </p>
         * 
         * @param includeCascaded
         *        Specifies whether to include cascading rules in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCascaded(Boolean includeCascaded);

        /**
         * <p>
         * The maximum number of rules to return in a single call to <code>ListRules</code>. When the number of rules to
         * be listed is greater than the value of <code>MaxResults</code>, the response contains a
         * <code>NextToken</code> value that you can use in a subsequent call to <code>ListRules</code> to list the next
         * set of rules.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of rules to return in a single call to <code>ListRules</code>. When the number of
         *        rules to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         *        <code>NextToken</code> value that you can use in a subsequent call to <code>ListRules</code> to list
         *        the next set of rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of rules is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of rules, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>ListRules</code> to list the next set of rules.
         * </p>
         * 
         * @param nextToken
         *        When the number of rules is greater than the default value for the <code>MaxResults</code> parameter,
         *        or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         *        rules, the response includes a pagination token named <code>NextToken</code>. You can specify this
         *        <code>NextToken</code> value in a subsequent call to <code>ListRules</code> to list the next set of
         *        rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The IDs of projects in which rules are to be listed.
         * </p>
         * 
         * @param projectIds
         *        The IDs of projects in which rules are to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIds(Collection<String> projectIds);

        /**
         * <p>
         * The IDs of projects in which rules are to be listed.
         * </p>
         * 
         * @param projectIds
         *        The IDs of projects in which rules are to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIds(String... projectIds);

        /**
         * <p>
         * The type of the rule.
         * </p>
         * 
         * @param ruleType
         *        The type of the rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(String ruleType);

        /**
         * <p>
         * The type of the rule.
         * </p>
         * 
         * @param ruleType
         *        The type of the rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(RuleType ruleType);

        /**
         * <p>
         * The target ID of the rule.
         * </p>
         * 
         * @param targetIdentifier
         *        The target ID of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetIdentifier(String targetIdentifier);

        /**
         * <p>
         * The target type of the rule.
         * </p>
         * 
         * @param targetType
         *        The target type of the rule.
         * @see RuleTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The target type of the rule.
         * </p>
         * 
         * @param targetType
         *        The target type of the rule.
         * @see RuleTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleTargetType
         */
        Builder targetType(RuleTargetType targetType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String action;

        private List<String> assetTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean dataProduct;

        private String domainIdentifier;

        private Boolean includeCascaded;

        private Integer maxResults;

        private String nextToken;

        private List<String> projectIds = DefaultSdkAutoConstructList.getInstance();

        private String ruleType;

        private String targetIdentifier;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesRequest model) {
            super(model);
            action(model.action);
            assetTypes(model.assetTypes);
            dataProduct(model.dataProduct);
            domainIdentifier(model.domainIdentifier);
            includeCascaded(model.includeCascaded);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            projectIds(model.projectIds);
            ruleType(model.ruleType);
            targetIdentifier(model.targetIdentifier);
            targetType(model.targetType);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Collection<String> getAssetTypes() {
            if (assetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return assetTypes;
        }

        public final void setAssetTypes(Collection<String> assetTypes) {
            this.assetTypes = AssetTypeIdentifiersCopier.copy(assetTypes);
        }

        @Override
        public final Builder assetTypes(Collection<String> assetTypes) {
            this.assetTypes = AssetTypeIdentifiersCopier.copy(assetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetTypes(String... assetTypes) {
            assetTypes(Arrays.asList(assetTypes));
            return this;
        }

        public final Boolean getDataProduct() {
            return dataProduct;
        }

        public final void setDataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
        }

        @Override
        public final Builder dataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Boolean getIncludeCascaded() {
            return includeCascaded;
        }

        public final void setIncludeCascaded(Boolean includeCascaded) {
            this.includeCascaded = includeCascaded;
        }

        @Override
        public final Builder includeCascaded(Boolean includeCascaded) {
            this.includeCascaded = includeCascaded;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getProjectIds() {
            if (projectIds instanceof SdkAutoConstructList) {
                return null;
            }
            return projectIds;
        }

        public final void setProjectIds(Collection<String> projectIds) {
            this.projectIds = ProjectIdsCopier.copy(projectIds);
        }

        @Override
        public final Builder projectIds(Collection<String> projectIds) {
            this.projectIds = ProjectIdsCopier.copy(projectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectIds(String... projectIds) {
            projectIds(Arrays.asList(projectIds));
            return this;
        }

        public final String getRuleType() {
            return ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final String getTargetIdentifier() {
            return targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RuleTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRulesRequest build() {
            return new ListRulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
