/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPolicyGrantsRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListPolicyGrantsRequest.Builder, ListPolicyGrantsRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListPolicyGrantsRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(ListPolicyGrantsRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(ListPolicyGrantsRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListPolicyGrantsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPolicyGrantsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(ListPolicyGrantsRequest::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policyType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, POLICY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityType;

    private final Integer maxResults;

    private final String nextToken;

    private final String policyType;

    private ListPolicyGrantsRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.policyType = builder.policyType;
    }

    /**
     * <p>
     * The ID of the domain where you want to list policy grants.
     * </p>
     * 
     * @return The ID of the domain where you want to list policy grants.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the entity for which you want to list policy grants.
     * </p>
     * 
     * @return The ID of the entity for which you want to list policy grants.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The type of entity for which you want to list policy grants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TargetEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of entity for which you want to list policy grants.
     * @see TargetEntityType
     */
    public final TargetEntityType entityType() {
        return TargetEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of entity for which you want to list policy grants.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TargetEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of entity for which you want to list policy grants.
     * @see TargetEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The maximum number of grants to return in a single call to <code>ListPolicyGrants</code>. When the number of
     * grants to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     * <code>NextToken</code> value that you can use in a subsequent call to <code>ListPolicyGrants</code> to list the
     * next set of grants.
     * </p>
     * 
     * @return The maximum number of grants to return in a single call to <code>ListPolicyGrants</code>. When the number
     *         of grants to be listed is greater than the value of <code>MaxResults</code>, the response contains a
     *         <code>NextToken</code> value that you can use in a subsequent call to <code>ListPolicyGrants</code> to
     *         list the next set of grants.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of grants is greater than the default value for the <code>MaxResults</code> parameter, or if you
     * explicitly specify a value for <code>MaxResults</code> that is less than the number of grants, the response
     * includes a pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     * subsequent call to <code>ListPolicyGrants</code> to list the next set of grants.
     * </p>
     * 
     * @return When the number of grants is greater than the default value for the <code>MaxResults</code> parameter, or
     *         if you explicitly specify a value for <code>MaxResults</code> that is less than the number of grants, the
     *         response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>ListPolicyGrants</code> to list the next set
     *         of grants.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The type of policy that you want to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link ManagedPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy that you want to list.
     * @see ManagedPolicyType
     */
    public final ManagedPolicyType policyType() {
        return ManagedPolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * The type of policy that you want to list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link ManagedPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return The type of policy that you want to list.
     * @see ManagedPolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyGrantsRequest)) {
            return false;
        }
        ListPolicyGrantsRequest other = (ListPolicyGrantsRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPolicyGrantsRequest").add("DomainIdentifier", domainIdentifier())
                .add("EntityIdentifier", entityIdentifier()).add("EntityType", entityTypeAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("PolicyType", policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyGrantsRequest, T> g) {
        return obj -> g.apply((ListPolicyGrantsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPolicyGrantsRequest> {
        /**
         * <p>
         * The ID of the domain where you want to list policy grants.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where you want to list policy grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the entity for which you want to list policy grants.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the entity for which you want to list policy grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The type of entity for which you want to list policy grants.
         * </p>
         * 
         * @param entityType
         *        The type of entity for which you want to list policy grants.
         * @see TargetEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of entity for which you want to list policy grants.
         * </p>
         * 
         * @param entityType
         *        The type of entity for which you want to list policy grants.
         * @see TargetEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetEntityType
         */
        Builder entityType(TargetEntityType entityType);

        /**
         * <p>
         * The maximum number of grants to return in a single call to <code>ListPolicyGrants</code>. When the number of
         * grants to be listed is greater than the value of <code>MaxResults</code>, the response contains a
         * <code>NextToken</code> value that you can use in a subsequent call to <code>ListPolicyGrants</code> to list
         * the next set of grants.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of grants to return in a single call to <code>ListPolicyGrants</code>. When the
         *        number of grants to be listed is greater than the value of <code>MaxResults</code>, the response
         *        contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>ListPolicyGrants</code> to list the next set of grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of grants is greater than the default value for the <code>MaxResults</code> parameter, or if
         * you explicitly specify a value for <code>MaxResults</code> that is less than the number of grants, the
         * response includes a pagination token named <code>NextToken</code>. You can specify this
         * <code>NextToken</code> value in a subsequent call to <code>ListPolicyGrants</code> to list the next set of
         * grants.
         * </p>
         * 
         * @param nextToken
         *        When the number of grants is greater than the default value for the <code>MaxResults</code> parameter,
         *        or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
         *        grants, the response includes a pagination token named <code>NextToken</code>. You can specify this
         *        <code>NextToken</code> value in a subsequent call to <code>ListPolicyGrants</code> to list the next
         *        set of grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The type of policy that you want to list.
         * </p>
         * 
         * @param policyType
         *        The type of policy that you want to list.
         * @see ManagedPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedPolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The type of policy that you want to list.
         * </p>
         * 
         * @param policyType
         *        The type of policy that you want to list.
         * @see ManagedPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedPolicyType
         */
        Builder policyType(ManagedPolicyType policyType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private String entityIdentifier;

        private String entityType;

        private Integer maxResults;

        private String nextToken;

        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyGrantsRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityType(model.entityType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            policyType(model.policyType);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TargetEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(ManagedPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPolicyGrantsRequest build() {
            return new ListPolicyGrantsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
