/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data lineage information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LineageInfo implements SdkPojo, Serializable, ToCopyableBuilder<LineageInfo.Builder, LineageInfo> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(LineageInfo::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(LineageInfo::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventStatus").getter(getter(LineageInfo::eventStatusAsString)).setter(setter(Builder::eventStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD,
            EVENT_ID_FIELD, EVENT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorMessage;

    private final String eventId;

    private final String eventStatus;

    private LineageInfo(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.eventId = builder.eventId;
        this.eventStatus = builder.eventStatus;
    }

    /**
     * <p>
     * The data lineage error message.
     * </p>
     * 
     * @return The data lineage error message.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The data lineage event ID.
     * </p>
     * 
     * @return The data lineage event ID.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The data lineage event status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link LineageEventProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The data lineage event status.
     * @see LineageEventProcessingStatus
     */
    public final LineageEventProcessingStatus eventStatus() {
        return LineageEventProcessingStatus.fromValue(eventStatus);
    }

    /**
     * <p>
     * The data lineage event status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventStatus} will
     * return {@link LineageEventProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventStatusAsString}.
     * </p>
     * 
     * @return The data lineage event status.
     * @see LineageEventProcessingStatus
     */
    public final String eventStatusAsString() {
        return eventStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageInfo)) {
            return false;
        }
        LineageInfo other = (LineageInfo) obj;
        return Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(eventStatusAsString(), other.eventStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LineageInfo").add("ErrorMessage", errorMessage()).add("EventId", eventId())
                .add("EventStatus", eventStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventStatus":
            return Optional.ofNullable(clazz.cast(eventStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("eventStatus", EVENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageInfo, T> g) {
        return obj -> g.apply((LineageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LineageInfo> {
        /**
         * <p>
         * The data lineage error message.
         * </p>
         * 
         * @param errorMessage
         *        The data lineage error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The data lineage event ID.
         * </p>
         * 
         * @param eventId
         *        The data lineage event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The data lineage event status.
         * </p>
         * 
         * @param eventStatus
         *        The data lineage event status.
         * @see LineageEventProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageEventProcessingStatus
         */
        Builder eventStatus(String eventStatus);

        /**
         * <p>
         * The data lineage event status.
         * </p>
         * 
         * @param eventStatus
         *        The data lineage event status.
         * @see LineageEventProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LineageEventProcessingStatus
         */
        Builder eventStatus(LineageEventProcessingStatus eventStatus);
    }

    static final class BuilderImpl implements Builder {
        private String errorMessage;

        private String eventId;

        private String eventStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageInfo model) {
            errorMessage(model.errorMessage);
            eventId(model.eventId);
            eventStatus(model.eventStatus);
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventStatus() {
            return eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(LineageEventProcessingStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        @Override
        public LineageInfo build() {
            return new LineageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
