/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Lake Formation configuration of the Data Lake blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeFormationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeFormationConfiguration.Builder, LakeFormationConfiguration> {
    private static final SdkField<List<String>> LOCATION_REGISTRATION_EXCLUDE_S3_LOCATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("locationRegistrationExcludeS3Locations")
            .getter(getter(LakeFormationConfiguration::locationRegistrationExcludeS3Locations))
            .setter(setter(Builder::locationRegistrationExcludeS3Locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("locationRegistrationExcludeS3Locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCATION_REGISTRATION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("locationRegistrationRole").getter(getter(LakeFormationConfiguration::locationRegistrationRole))
            .setter(setter(Builder::locationRegistrationRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationRegistrationRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCATION_REGISTRATION_EXCLUDE_S3_LOCATIONS_FIELD, LOCATION_REGISTRATION_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> locationRegistrationExcludeS3Locations;

    private final String locationRegistrationRole;

    private LakeFormationConfiguration(BuilderImpl builder) {
        this.locationRegistrationExcludeS3Locations = builder.locationRegistrationExcludeS3Locations;
        this.locationRegistrationRole = builder.locationRegistrationRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocationRegistrationExcludeS3Locations
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasLocationRegistrationExcludeS3Locations() {
        return locationRegistrationExcludeS3Locations != null
                && !(locationRegistrationExcludeS3Locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies certain Amazon S3 locations if you do not want Amazon DataZone to automatically register them in hybrid
     * mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocationRegistrationExcludeS3Locations}
     * method.
     * </p>
     * 
     * @return Specifies certain Amazon S3 locations if you do not want Amazon DataZone to automatically register them
     *         in hybrid mode.
     */
    public final List<String> locationRegistrationExcludeS3Locations() {
        return locationRegistrationExcludeS3Locations;
    }

    /**
     * <p>
     * The role that is used to manage read/write access to the chosen Amazon S3 bucket(s) for Data Lake using Amazon
     * Web Services Lake Formation hybrid access mode.
     * </p>
     * 
     * @return The role that is used to manage read/write access to the chosen Amazon S3 bucket(s) for Data Lake using
     *         Amazon Web Services Lake Formation hybrid access mode.
     */
    public final String locationRegistrationRole() {
        return locationRegistrationRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLocationRegistrationExcludeS3Locations() ? locationRegistrationExcludeS3Locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(locationRegistrationRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationConfiguration)) {
            return false;
        }
        LakeFormationConfiguration other = (LakeFormationConfiguration) obj;
        return hasLocationRegistrationExcludeS3Locations() == other.hasLocationRegistrationExcludeS3Locations()
                && Objects.equals(locationRegistrationExcludeS3Locations(), other.locationRegistrationExcludeS3Locations())
                && Objects.equals(locationRegistrationRole(), other.locationRegistrationRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("LakeFormationConfiguration")
                .add("LocationRegistrationExcludeS3Locations",
                        hasLocationRegistrationExcludeS3Locations() ? locationRegistrationExcludeS3Locations() : null)
                .add("LocationRegistrationRole", locationRegistrationRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "locationRegistrationExcludeS3Locations":
            return Optional.ofNullable(clazz.cast(locationRegistrationExcludeS3Locations()));
        case "locationRegistrationRole":
            return Optional.ofNullable(clazz.cast(locationRegistrationRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("locationRegistrationExcludeS3Locations", LOCATION_REGISTRATION_EXCLUDE_S3_LOCATIONS_FIELD);
        map.put("locationRegistrationRole", LOCATION_REGISTRATION_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationConfiguration, T> g) {
        return obj -> g.apply((LakeFormationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeFormationConfiguration> {
        /**
         * <p>
         * Specifies certain Amazon S3 locations if you do not want Amazon DataZone to automatically register them in
         * hybrid mode.
         * </p>
         * 
         * @param locationRegistrationExcludeS3Locations
         *        Specifies certain Amazon S3 locations if you do not want Amazon DataZone to automatically register
         *        them in hybrid mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationRegistrationExcludeS3Locations(Collection<String> locationRegistrationExcludeS3Locations);

        /**
         * <p>
         * Specifies certain Amazon S3 locations if you do not want Amazon DataZone to automatically register them in
         * hybrid mode.
         * </p>
         * 
         * @param locationRegistrationExcludeS3Locations
         *        Specifies certain Amazon S3 locations if you do not want Amazon DataZone to automatically register
         *        them in hybrid mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationRegistrationExcludeS3Locations(String... locationRegistrationExcludeS3Locations);

        /**
         * <p>
         * The role that is used to manage read/write access to the chosen Amazon S3 bucket(s) for Data Lake using
         * Amazon Web Services Lake Formation hybrid access mode.
         * </p>
         * 
         * @param locationRegistrationRole
         *        The role that is used to manage read/write access to the chosen Amazon S3 bucket(s) for Data Lake
         *        using Amazon Web Services Lake Formation hybrid access mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationRegistrationRole(String locationRegistrationRole);
    }

    static final class BuilderImpl implements Builder {
        private List<String> locationRegistrationExcludeS3Locations = DefaultSdkAutoConstructList.getInstance();

        private String locationRegistrationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationConfiguration model) {
            locationRegistrationExcludeS3Locations(model.locationRegistrationExcludeS3Locations);
            locationRegistrationRole(model.locationRegistrationRole);
        }

        public final Collection<String> getLocationRegistrationExcludeS3Locations() {
            if (locationRegistrationExcludeS3Locations instanceof SdkAutoConstructList) {
                return null;
            }
            return locationRegistrationExcludeS3Locations;
        }

        public final void setLocationRegistrationExcludeS3Locations(Collection<String> locationRegistrationExcludeS3Locations) {
            this.locationRegistrationExcludeS3Locations = S3LocationListCopier.copy(locationRegistrationExcludeS3Locations);
        }

        @Override
        public final Builder locationRegistrationExcludeS3Locations(Collection<String> locationRegistrationExcludeS3Locations) {
            this.locationRegistrationExcludeS3Locations = S3LocationListCopier.copy(locationRegistrationExcludeS3Locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationRegistrationExcludeS3Locations(String... locationRegistrationExcludeS3Locations) {
            locationRegistrationExcludeS3Locations(Arrays.asList(locationRegistrationExcludeS3Locations));
            return this;
        }

        public final String getLocationRegistrationRole() {
            return locationRegistrationRole;
        }

        public final void setLocationRegistrationRole(String locationRegistrationRole) {
            this.locationRegistrationRole = locationRegistrationRole;
        }

        @Override
        public final Builder locationRegistrationRole(String locationRegistrationRole) {
            this.locationRegistrationRole = locationRegistrationRole;
            return this;
        }

        @Override
        public LakeFormationConfiguration build() {
            return new LakeFormationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
