/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConnectionResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetConnectionResponse.Builder, GetConnectionResponse> {
    private static final SdkField<ConnectionCredentials> CONNECTION_CREDENTIALS_FIELD = SdkField
            .<ConnectionCredentials> builder(MarshallingType.SDK_POJO).memberName("connectionCredentials")
            .getter(getter(GetConnectionResponse::connectionCredentials)).setter(setter(Builder::connectionCredentials))
            .constructor(ConnectionCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionCredentials").build())
            .build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(GetConnectionResponse::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetConnectionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetConnectionResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitId").getter(getter(GetConnectionResponse::domainUnitId)).setter(setter(Builder::domainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetConnectionResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> ENVIRONMENT_USER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentUserRole").getter(getter(GetConnectionResponse::environmentUserRole))
            .setter(setter(Builder::environmentUserRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentUserRole").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetConnectionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<PhysicalEndpoint>> PHYSICAL_ENDPOINTS_FIELD = SdkField
            .<List<PhysicalEndpoint>> builder(MarshallingType.LIST)
            .memberName("physicalEndpoints")
            .getter(getter(GetConnectionResponse::physicalEndpoints))
            .setter(setter(Builder::physicalEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhysicalEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhysicalEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(GetConnectionResponse::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<ConnectionPropertiesOutput> PROPS_FIELD = SdkField
            .<ConnectionPropertiesOutput> builder(MarshallingType.SDK_POJO).memberName("props")
            .getter(getter(GetConnectionResponse::props)).setter(setter(Builder::props))
            .constructor(ConnectionPropertiesOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("props").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(GetConnectionResponse::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetConnectionResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_CREDENTIALS_FIELD,
            CONNECTION_ID_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ENVIRONMENT_ID_FIELD,
            ENVIRONMENT_USER_ROLE_FIELD, NAME_FIELD, PHYSICAL_ENDPOINTS_FIELD, PROJECT_ID_FIELD, PROPS_FIELD, SCOPE_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConnectionCredentials connectionCredentials;

    private final String connectionId;

    private final String description;

    private final String domainId;

    private final String domainUnitId;

    private final String environmentId;

    private final String environmentUserRole;

    private final String name;

    private final List<PhysicalEndpoint> physicalEndpoints;

    private final String projectId;

    private final ConnectionPropertiesOutput props;

    private final String scope;

    private final String type;

    private GetConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionCredentials = builder.connectionCredentials;
        this.connectionId = builder.connectionId;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.environmentId = builder.environmentId;
        this.environmentUserRole = builder.environmentUserRole;
        this.name = builder.name;
        this.physicalEndpoints = builder.physicalEndpoints;
        this.projectId = builder.projectId;
        this.props = builder.props;
        this.scope = builder.scope;
        this.type = builder.type;
    }

    /**
     * <p>
     * Connection credentials.
     * </p>
     * 
     * @return Connection credentials.
     */
    public final ConnectionCredentials connectionCredentials() {
        return connectionCredentials;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * Connection description.
     * </p>
     * 
     * @return Connection description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain ID of the connection.
     * </p>
     * 
     * @return The domain ID of the connection.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The domain unit ID of the connection.
     * </p>
     * 
     * @return The domain unit ID of the connection.
     */
    public final String domainUnitId() {
        return domainUnitId;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The environment user role.
     * </p>
     * 
     * @return The environment user role.
     */
    public final String environmentUserRole() {
        return environmentUserRole;
    }

    /**
     * <p>
     * The name of the connection.
     * </p>
     * 
     * @return The name of the connection.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhysicalEndpoints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhysicalEndpoints() {
        return physicalEndpoints != null && !(physicalEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The physical endpoints of the connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhysicalEndpoints} method.
     * </p>
     * 
     * @return The physical endpoints of the connection.
     */
    public final List<PhysicalEndpoint> physicalEndpoints() {
        return physicalEndpoints;
    }

    /**
     * <p>
     * The ID of the project.
     * </p>
     * 
     * @return The ID of the project.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * Connection props.
     * </p>
     * 
     * @return Connection props.
     */
    public final ConnectionPropertiesOutput props() {
        return props;
    }

    /**
     * <p>
     * The scope of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link ConnectionScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the connection.
     * @see ConnectionScope
     */
    public final ConnectionScope scope() {
        return ConnectionScope.fromValue(scope);
    }

    /**
     * <p>
     * The scope of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link ConnectionScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return The scope of the connection.
     * @see ConnectionScope
     */
    public final String scopeAsString() {
        return scope;
    }

    /**
     * <p>
     * The type of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the connection.
     * @see ConnectionType
     */
    public final ConnectionType type() {
        return ConnectionType.fromValue(type);
    }

    /**
     * <p>
     * The type of the connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the connection.
     * @see ConnectionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentUserRole());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhysicalEndpoints() ? physicalEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(props());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionResponse)) {
            return false;
        }
        GetConnectionResponse other = (GetConnectionResponse) obj;
        return Objects.equals(connectionCredentials(), other.connectionCredentials())
                && Objects.equals(connectionId(), other.connectionId()) && Objects.equals(description(), other.description())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(domainUnitId(), other.domainUnitId())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(environmentUserRole(), other.environmentUserRole()) && Objects.equals(name(), other.name())
                && hasPhysicalEndpoints() == other.hasPhysicalEndpoints()
                && Objects.equals(physicalEndpoints(), other.physicalEndpoints())
                && Objects.equals(projectId(), other.projectId()) && Objects.equals(props(), other.props())
                && Objects.equals(scopeAsString(), other.scopeAsString()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConnectionResponse")
                .add("ConnectionCredentials", connectionCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConnectionId", connectionId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("DomainUnitId", domainUnitId()).add("EnvironmentId", environmentId())
                .add("EnvironmentUserRole", environmentUserRole()).add("Name", name())
                .add("PhysicalEndpoints", hasPhysicalEndpoints() ? physicalEndpoints() : null).add("ProjectId", projectId())
                .add("Props", props()).add("Scope", scopeAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionCredentials":
            return Optional.ofNullable(clazz.cast(connectionCredentials()));
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "domainUnitId":
            return Optional.ofNullable(clazz.cast(domainUnitId()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "environmentUserRole":
            return Optional.ofNullable(clazz.cast(environmentUserRole()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "physicalEndpoints":
            return Optional.ofNullable(clazz.cast(physicalEndpoints()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "props":
            return Optional.ofNullable(clazz.cast(props()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectionCredentials", CONNECTION_CREDENTIALS_FIELD);
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("environmentUserRole", ENVIRONMENT_USER_ROLE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("physicalEndpoints", PHYSICAL_ENDPOINTS_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("props", PROPS_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionResponse, T> g) {
        return obj -> g.apply((GetConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetConnectionResponse> {
        /**
         * <p>
         * Connection credentials.
         * </p>
         * 
         * @param connectionCredentials
         *        Connection credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionCredentials(ConnectionCredentials connectionCredentials);

        /**
         * <p>
         * Connection credentials.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionCredentials.Builder} avoiding
         * the need to create one manually via {@link ConnectionCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionCredentials(ConnectionCredentials)}.
         * 
         * @param connectionCredentials
         *        a consumer that will call methods on {@link ConnectionCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionCredentials(ConnectionCredentials)
         */
        default Builder connectionCredentials(Consumer<ConnectionCredentials.Builder> connectionCredentials) {
            return connectionCredentials(ConnectionCredentials.builder().applyMutation(connectionCredentials).build());
        }

        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * Connection description.
         * </p>
         * 
         * @param description
         *        Connection description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain ID of the connection.
         * </p>
         * 
         * @param domainId
         *        The domain ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The domain unit ID of the connection.
         * </p>
         * 
         * @param domainUnitId
         *        The domain unit ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitId(String domainUnitId);

        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The environment user role.
         * </p>
         * 
         * @param environmentUserRole
         *        The environment user role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentUserRole(String environmentUserRole);

        /**
         * <p>
         * The name of the connection.
         * </p>
         * 
         * @param name
         *        The name of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The physical endpoints of the connection.
         * </p>
         * 
         * @param physicalEndpoints
         *        The physical endpoints of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalEndpoints(Collection<PhysicalEndpoint> physicalEndpoints);

        /**
         * <p>
         * The physical endpoints of the connection.
         * </p>
         * 
         * @param physicalEndpoints
         *        The physical endpoints of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalEndpoints(PhysicalEndpoint... physicalEndpoints);

        /**
         * <p>
         * The physical endpoints of the connection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.PhysicalEndpoint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.PhysicalEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.PhysicalEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #physicalEndpoints(List<PhysicalEndpoint>)}.
         * 
         * @param physicalEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.PhysicalEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalEndpoints(java.util.Collection<PhysicalEndpoint>)
         */
        Builder physicalEndpoints(Consumer<PhysicalEndpoint.Builder>... physicalEndpoints);

        /**
         * <p>
         * The ID of the project.
         * </p>
         * 
         * @param projectId
         *        The ID of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * Connection props.
         * </p>
         * 
         * @param props
         *        Connection props.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder props(ConnectionPropertiesOutput props);

        /**
         * <p>
         * Connection props.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPropertiesOutput.Builder}
         * avoiding the need to create one manually via {@link ConnectionPropertiesOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPropertiesOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #props(ConnectionPropertiesOutput)}.
         * 
         * @param props
         *        a consumer that will call methods on {@link ConnectionPropertiesOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #props(ConnectionPropertiesOutput)
         */
        default Builder props(Consumer<ConnectionPropertiesOutput.Builder> props) {
            return props(ConnectionPropertiesOutput.builder().applyMutation(props).build());
        }

        /**
         * <p>
         * The scope of the connection.
         * </p>
         * 
         * @param scope
         *        The scope of the connection.
         * @see ConnectionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionScope
         */
        Builder scope(String scope);

        /**
         * <p>
         * The scope of the connection.
         * </p>
         * 
         * @param scope
         *        The scope of the connection.
         * @see ConnectionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionScope
         */
        Builder scope(ConnectionScope scope);

        /**
         * <p>
         * The type of the connection.
         * </p>
         * 
         * @param type
         *        The type of the connection.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the connection.
         * </p>
         * 
         * @param type
         *        The type of the connection.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder type(ConnectionType type);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private ConnectionCredentials connectionCredentials;

        private String connectionId;

        private String description;

        private String domainId;

        private String domainUnitId;

        private String environmentId;

        private String environmentUserRole;

        private String name;

        private List<PhysicalEndpoint> physicalEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String projectId;

        private ConnectionPropertiesOutput props;

        private String scope;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionResponse model) {
            super(model);
            connectionCredentials(model.connectionCredentials);
            connectionId(model.connectionId);
            description(model.description);
            domainId(model.domainId);
            domainUnitId(model.domainUnitId);
            environmentId(model.environmentId);
            environmentUserRole(model.environmentUserRole);
            name(model.name);
            physicalEndpoints(model.physicalEndpoints);
            projectId(model.projectId);
            props(model.props);
            scope(model.scope);
            type(model.type);
        }

        public final ConnectionCredentials.Builder getConnectionCredentials() {
            return connectionCredentials != null ? connectionCredentials.toBuilder() : null;
        }

        public final void setConnectionCredentials(ConnectionCredentials.BuilderImpl connectionCredentials) {
            this.connectionCredentials = connectionCredentials != null ? connectionCredentials.build() : null;
        }

        @Override
        public final Builder connectionCredentials(ConnectionCredentials connectionCredentials) {
            this.connectionCredentials = connectionCredentials;
            return this;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getEnvironmentUserRole() {
            return environmentUserRole;
        }

        public final void setEnvironmentUserRole(String environmentUserRole) {
            this.environmentUserRole = environmentUserRole;
        }

        @Override
        public final Builder environmentUserRole(String environmentUserRole) {
            this.environmentUserRole = environmentUserRole;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<PhysicalEndpoint.Builder> getPhysicalEndpoints() {
            List<PhysicalEndpoint.Builder> result = PhysicalEndpointsCopier.copyToBuilder(this.physicalEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhysicalEndpoints(Collection<PhysicalEndpoint.BuilderImpl> physicalEndpoints) {
            this.physicalEndpoints = PhysicalEndpointsCopier.copyFromBuilder(physicalEndpoints);
        }

        @Override
        public final Builder physicalEndpoints(Collection<PhysicalEndpoint> physicalEndpoints) {
            this.physicalEndpoints = PhysicalEndpointsCopier.copy(physicalEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalEndpoints(PhysicalEndpoint... physicalEndpoints) {
            physicalEndpoints(Arrays.asList(physicalEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalEndpoints(Consumer<PhysicalEndpoint.Builder>... physicalEndpoints) {
            physicalEndpoints(Stream.of(physicalEndpoints).map(c -> PhysicalEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final ConnectionPropertiesOutput.Builder getProps() {
            return props != null ? props.toBuilder() : null;
        }

        public final void setProps(ConnectionPropertiesOutput.BuilderImpl props) {
            this.props = props != null ? props.build() : null;
        }

        @Override
        public final Builder props(ConnectionPropertiesOutput props) {
            this.props = props;
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(ConnectionScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConnectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetConnectionResponse build() {
            return new GetConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
