/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an environment profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentProfileSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentProfileSummary.Builder, EnvironmentProfileSummary> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(EnvironmentProfileSummary::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountRegion").getter(getter(EnvironmentProfileSummary::awsAccountRegion))
            .setter(setter(Builder::awsAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountRegion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(EnvironmentProfileSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(EnvironmentProfileSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnvironmentProfileSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(EnvironmentProfileSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintId").getter(getter(EnvironmentProfileSummary::environmentBlueprintId))
            .setter(setter(Builder::environmentBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EnvironmentProfileSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentProfileSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(EnvironmentProfileSummary::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(EnvironmentProfileSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_REGION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD,
            ENVIRONMENT_BLUEPRINT_ID_FIELD, ID_FIELD, NAME_FIELD, PROJECT_ID_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String awsAccountId;

    private final String awsAccountRegion;

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final String environmentBlueprintId;

    private final String id;

    private final String name;

    private final String projectId;

    private final Instant updatedAt;

    private EnvironmentProfileSummary(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.id = builder.id;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of an Amazon Web Services account in which an environment profile exists.
     * </p>
     * 
     * @return The identifier of an Amazon Web Services account in which an environment profile exists.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services Region in which an environment profile exists.
     * </p>
     * 
     * @return The Amazon Web Services Region in which an environment profile exists.
     */
    public final String awsAccountRegion() {
        return awsAccountRegion;
    }

    /**
     * <p>
     * The timestamp of when an environment profile was created.
     * </p>
     * 
     * @return The timestamp of when an environment profile was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the environment profile.
     * </p>
     * 
     * @return The Amazon DataZone user who created the environment profile.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the environment profile.
     * </p>
     * 
     * @return The description of the environment profile.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the environment profile exists.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which the environment profile exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The identifier of a blueprint with which an environment profile is created.
     * </p>
     * 
     * @return The identifier of a blueprint with which an environment profile is created.
     */
    public final String environmentBlueprintId() {
        return environmentBlueprintId;
    }

    /**
     * <p>
     * The identifier of the environment profile.
     * </p>
     * 
     * @return The identifier of the environment profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment profile.
     * </p>
     * 
     * @return The name of the environment profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of a project in which an environment profile exists.
     * </p>
     * 
     * @return The identifier of a project in which an environment profile exists.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The timestamp of when the environment profile was updated.
     * </p>
     * 
     * @return The timestamp of when the environment profile was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentProfileSummary)) {
            return false;
        }
        EnvironmentProfileSummary other = (EnvironmentProfileSummary) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(description(), other.description())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentProfileSummary").add("AwsAccountId", awsAccountId())
                .add("AwsAccountRegion", awsAccountRegion()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("EnvironmentBlueprintId", environmentBlueprintId()).add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", projectId())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountRegion":
            return Optional.ofNullable(clazz.cast(awsAccountRegion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "environmentBlueprintId":
            return Optional.ofNullable(clazz.cast(environmentBlueprintId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentProfileSummary, T> g) {
        return obj -> g.apply((EnvironmentProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentProfileSummary> {
        /**
         * <p>
         * The identifier of an Amazon Web Services account in which an environment profile exists.
         * </p>
         * 
         * @param awsAccountId
         *        The identifier of an Amazon Web Services account in which an environment profile exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services Region in which an environment profile exists.
         * </p>
         * 
         * @param awsAccountRegion
         *        The Amazon Web Services Region in which an environment profile exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountRegion(String awsAccountRegion);

        /**
         * <p>
         * The timestamp of when an environment profile was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when an environment profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the environment profile.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the environment profile.
         * </p>
         * 
         * @param description
         *        The description of the environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which the environment profile exists.
         * </p>
         * 
         * @param domainId
         *        The identifier of the Amazon DataZone domain in which the environment profile exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The identifier of a blueprint with which an environment profile is created.
         * </p>
         * 
         * @param environmentBlueprintId
         *        The identifier of a blueprint with which an environment profile is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintId(String environmentBlueprintId);

        /**
         * <p>
         * The identifier of the environment profile.
         * </p>
         * 
         * @param id
         *        The identifier of the environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment profile.
         * </p>
         * 
         * @param name
         *        The name of the environment profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of a project in which an environment profile exists.
         * </p>
         * 
         * @param projectId
         *        The identifier of a project in which an environment profile exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The timestamp of when the environment profile was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the environment profile was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountRegion;

        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private String environmentBlueprintId;

        private String id;

        private String name;

        private String projectId;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentProfileSummary model) {
            awsAccountId(model.awsAccountId);
            awsAccountRegion(model.awsAccountRegion);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            environmentBlueprintId(model.environmentBlueprintId);
            id(model.id);
            name(model.name);
            projectId(model.projectId);
            updatedAt(model.updatedAt);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EnvironmentProfileSummary build() {
            return new EnvironmentProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
