/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceSummary.Builder, DataSourceSummary> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(DataSourceSummary::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(DataSourceSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(DataSourceSummary::dataSourceId)).setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DataSourceSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(DataSourceSummary::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enableSetting").getter(getter(DataSourceSummary::enableSettingAsString))
            .setter(setter(Builder::enableSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(DataSourceSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<Integer> LAST_RUN_ASSET_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("lastRunAssetCount").getter(getter(DataSourceSummary::lastRunAssetCount))
            .setter(setter(Builder::lastRunAssetCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunAssetCount").build()).build();

    private static final SdkField<Instant> LAST_RUN_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRunAt")
            .getter(getter(DataSourceSummary::lastRunAt))
            .setter(setter(Builder::lastRunAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<DataSourceErrorMessage> LAST_RUN_ERROR_MESSAGE_FIELD = SdkField
            .<DataSourceErrorMessage> builder(MarshallingType.SDK_POJO).memberName("lastRunErrorMessage")
            .getter(getter(DataSourceSummary::lastRunErrorMessage)).setter(setter(Builder::lastRunErrorMessage))
            .constructor(DataSourceErrorMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunErrorMessage").build())
            .build();

    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastRunStatus").getter(getter(DataSourceSummary::lastRunStatusAsString))
            .setter(setter(Builder::lastRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunStatus").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataSourceSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("schedule")
            .getter(getter(DataSourceSummary::schedule)).setter(setter(Builder::schedule))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DataSourceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataSourceSummary::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(DataSourceSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            CREATED_AT_FIELD, DATA_SOURCE_ID_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ENABLE_SETTING_FIELD,
            ENVIRONMENT_ID_FIELD, LAST_RUN_ASSET_COUNT_FIELD, LAST_RUN_AT_FIELD, LAST_RUN_ERROR_MESSAGE_FIELD,
            LAST_RUN_STATUS_FIELD, NAME_FIELD, SCHEDULE_FIELD, STATUS_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionId;

    private final Instant createdAt;

    private final String dataSourceId;

    private final String description;

    private final String domainId;

    private final String enableSetting;

    private final String environmentId;

    private final Integer lastRunAssetCount;

    private final Instant lastRunAt;

    private final DataSourceErrorMessage lastRunErrorMessage;

    private final String lastRunStatus;

    private final String name;

    private final ScheduleConfiguration schedule;

    private final String status;

    private final String type;

    private final Instant updatedAt;

    private DataSourceSummary(BuilderImpl builder) {
        this.connectionId = builder.connectionId;
        this.createdAt = builder.createdAt;
        this.dataSourceId = builder.dataSourceId;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.enableSetting = builder.enableSetting;
        this.environmentId = builder.environmentId;
        this.lastRunAssetCount = builder.lastRunAssetCount;
        this.lastRunAt = builder.lastRunAt;
        this.lastRunErrorMessage = builder.lastRunErrorMessage;
        this.lastRunStatus = builder.lastRunStatus;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The connection ID that's part of the data source summary.
     * </p>
     * 
     * @return The connection ID that's part of the data source summary.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The timestamp of when the data source was created.
     * </p>
     * 
     * @return The timestamp of when the data source was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the data source.
     * </p>
     * 
     * @return The ID of the data source.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * The data source description.
     * </p>
     * 
     * @return The data source description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the data source exists.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the data source exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Specifies whether the data source is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return Specifies whether the data source is enabled.
     * @see EnableSetting
     */
    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(enableSetting);
    }

    /**
     * <p>
     * Specifies whether the data source is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return Specifies whether the data source is enabled.
     * @see EnableSetting
     */
    public final String enableSettingAsString() {
        return enableSetting;
    }

    /**
     * <p>
     * The ID of the environment in which the data source exists.
     * </p>
     * 
     * @return The ID of the environment in which the data source exists.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The count of the assets created during the last data source run.
     * </p>
     * 
     * @return The count of the assets created during the last data source run.
     */
    public final Integer lastRunAssetCount() {
        return lastRunAssetCount;
    }

    /**
     * <p>
     * The timestamp of when the data source run was last performed.
     * </p>
     * 
     * @return The timestamp of when the data source run was last performed.
     */
    public final Instant lastRunAt() {
        return lastRunAt;
    }

    /**
     * Returns the value of the LastRunErrorMessage property for this object.
     * 
     * @return The value of the LastRunErrorMessage property for this object.
     */
    public final DataSourceErrorMessage lastRunErrorMessage() {
        return lastRunErrorMessage;
    }

    /**
     * <p>
     * The status of the last data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastRunStatus}
     * will return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastRunStatusAsString}.
     * </p>
     * 
     * @return The status of the last data source run.
     * @see DataSourceRunStatus
     */
    public final DataSourceRunStatus lastRunStatus() {
        return DataSourceRunStatus.fromValue(lastRunStatus);
    }

    /**
     * <p>
     * The status of the last data source run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastRunStatus}
     * will return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastRunStatusAsString}.
     * </p>
     * 
     * @return The status of the last data source run.
     * @see DataSourceRunStatus
     */
    public final String lastRunStatusAsString() {
        return lastRunStatus;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Schedule property for this object.
     * 
     * @return The value of the Schedule property for this object.
     */
    public final ScheduleConfiguration schedule() {
        return schedule;
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceStatus
     */
    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * 
     * @return The type of the data source.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The timestamp of when the data source was updated.
     * </p>
     * 
     * @return The timestamp of when the data source was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunAssetCount());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSummary)) {
            return false;
        }
        DataSourceSummary other = (DataSourceSummary) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(dataSourceId(), other.dataSourceId()) && Objects.equals(description(), other.description())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(enableSettingAsString(), other.enableSettingAsString())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(lastRunAssetCount(), other.lastRunAssetCount())
                && Objects.equals(lastRunAt(), other.lastRunAt())
                && Objects.equals(lastRunErrorMessage(), other.lastRunErrorMessage())
                && Objects.equals(lastRunStatusAsString(), other.lastRunStatusAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(type(), other.type()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceSummary").add("ConnectionId", connectionId()).add("CreatedAt", createdAt())
                .add("DataSourceId", dataSourceId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("EnableSetting", enableSettingAsString()).add("EnvironmentId", environmentId())
                .add("LastRunAssetCount", lastRunAssetCount()).add("LastRunAt", lastRunAt())
                .add("LastRunErrorMessage", lastRunErrorMessage()).add("LastRunStatus", lastRunStatusAsString())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Schedule", schedule() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("Type", type()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "enableSetting":
            return Optional.ofNullable(clazz.cast(enableSettingAsString()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "lastRunAssetCount":
            return Optional.ofNullable(clazz.cast(lastRunAssetCount()));
        case "lastRunAt":
            return Optional.ofNullable(clazz.cast(lastRunAt()));
        case "lastRunErrorMessage":
            return Optional.ofNullable(clazz.cast(lastRunErrorMessage()));
        case "lastRunStatus":
            return Optional.ofNullable(clazz.cast(lastRunStatusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("enableSetting", ENABLE_SETTING_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("lastRunAssetCount", LAST_RUN_ASSET_COUNT_FIELD);
        map.put("lastRunAt", LAST_RUN_AT_FIELD);
        map.put("lastRunErrorMessage", LAST_RUN_ERROR_MESSAGE_FIELD);
        map.put("lastRunStatus", LAST_RUN_STATUS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("schedule", SCHEDULE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSummary, T> g) {
        return obj -> g.apply((DataSourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceSummary> {
        /**
         * <p>
         * The connection ID that's part of the data source summary.
         * </p>
         * 
         * @param connectionId
         *        The connection ID that's part of the data source summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The timestamp of when the data source was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the data source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the data source.
         * </p>
         * 
         * @param dataSourceId
         *        The ID of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * The data source description.
         * </p>
         * 
         * @param description
         *        The data source description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the data source exists.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which the data source exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Specifies whether the data source is enabled.
         * </p>
         * 
         * @param enableSetting
         *        Specifies whether the data source is enabled.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(String enableSetting);

        /**
         * <p>
         * Specifies whether the data source is enabled.
         * </p>
         * 
         * @param enableSetting
         *        Specifies whether the data source is enabled.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(EnableSetting enableSetting);

        /**
         * <p>
         * The ID of the environment in which the data source exists.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment in which the data source exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The count of the assets created during the last data source run.
         * </p>
         * 
         * @param lastRunAssetCount
         *        The count of the assets created during the last data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunAssetCount(Integer lastRunAssetCount);

        /**
         * <p>
         * The timestamp of when the data source run was last performed.
         * </p>
         * 
         * @param lastRunAt
         *        The timestamp of when the data source run was last performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunAt(Instant lastRunAt);

        /**
         * Sets the value of the LastRunErrorMessage property for this object.
         *
         * @param lastRunErrorMessage
         *        The new value for the LastRunErrorMessage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunErrorMessage(DataSourceErrorMessage lastRunErrorMessage);

        /**
         * Sets the value of the LastRunErrorMessage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataSourceErrorMessage.Builder} avoiding
         * the need to create one manually via {@link DataSourceErrorMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceErrorMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #lastRunErrorMessage(DataSourceErrorMessage)}.
         * 
         * @param lastRunErrorMessage
         *        a consumer that will call methods on {@link DataSourceErrorMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRunErrorMessage(DataSourceErrorMessage)
         */
        default Builder lastRunErrorMessage(Consumer<DataSourceErrorMessage.Builder> lastRunErrorMessage) {
            return lastRunErrorMessage(DataSourceErrorMessage.builder().applyMutation(lastRunErrorMessage).build());
        }

        /**
         * <p>
         * The status of the last data source run.
         * </p>
         * 
         * @param lastRunStatus
         *        The status of the last data source run.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder lastRunStatus(String lastRunStatus);

        /**
         * <p>
         * The status of the last data source run.
         * </p>
         * 
         * @param lastRunStatus
         *        The status of the last data source run.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder lastRunStatus(DataSourceRunStatus lastRunStatus);

        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * @param schedule
         *        The new value for the Schedule property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(ScheduleConfiguration schedule);

        /**
         * Sets the value of the Schedule property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(ScheduleConfiguration)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(ScheduleConfiguration)
         */
        default Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return schedule(ScheduleConfiguration.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(DataSourceStatus status);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param type
         *        The type of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The timestamp of when the data source was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the data source was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String connectionId;

        private Instant createdAt;

        private String dataSourceId;

        private String description;

        private String domainId;

        private String enableSetting;

        private String environmentId;

        private Integer lastRunAssetCount;

        private Instant lastRunAt;

        private DataSourceErrorMessage lastRunErrorMessage;

        private String lastRunStatus;

        private String name;

        private ScheduleConfiguration schedule;

        private String status;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSummary model) {
            connectionId(model.connectionId);
            createdAt(model.createdAt);
            dataSourceId(model.dataSourceId);
            description(model.description);
            domainId(model.domainId);
            enableSetting(model.enableSetting);
            environmentId(model.environmentId);
            lastRunAssetCount(model.lastRunAssetCount);
            lastRunAt(model.lastRunAt);
            lastRunErrorMessage(model.lastRunErrorMessage);
            lastRunStatus(model.lastRunStatus);
            name(model.name);
            schedule(model.schedule);
            status(model.status);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnableSetting() {
            return enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Integer getLastRunAssetCount() {
            return lastRunAssetCount;
        }

        public final void setLastRunAssetCount(Integer lastRunAssetCount) {
            this.lastRunAssetCount = lastRunAssetCount;
        }

        @Override
        public final Builder lastRunAssetCount(Integer lastRunAssetCount) {
            this.lastRunAssetCount = lastRunAssetCount;
            return this;
        }

        public final Instant getLastRunAt() {
            return lastRunAt;
        }

        public final void setLastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
        }

        @Override
        public final Builder lastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
            return this;
        }

        public final DataSourceErrorMessage.Builder getLastRunErrorMessage() {
            return lastRunErrorMessage != null ? lastRunErrorMessage.toBuilder() : null;
        }

        public final void setLastRunErrorMessage(DataSourceErrorMessage.BuilderImpl lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage != null ? lastRunErrorMessage.build() : null;
        }

        @Override
        public final Builder lastRunErrorMessage(DataSourceErrorMessage lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage;
            return this;
        }

        public final String getLastRunStatus() {
            return lastRunStatus;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        @Override
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        @Override
        public final Builder lastRunStatus(DataSourceRunStatus lastRunStatus) {
            this.lastRunStatus(lastRunStatus == null ? null : lastRunStatus.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public DataSourceSummary build() {
            return new DataSourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
