/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DataProductRevisionsCopier {
    static List<DataProductRevision> copy(Collection<? extends DataProductRevision> dataProductRevisionsParam) {
        List<DataProductRevision> list;
        if (dataProductRevisionsParam == null || dataProductRevisionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataProductRevision> modifiableList = new ArrayList<>(dataProductRevisionsParam.size());
            dataProductRevisionsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataProductRevision> copyFromBuilder(Collection<? extends DataProductRevision.Builder> dataProductRevisionsParam) {
        List<DataProductRevision> list;
        if (dataProductRevisionsParam == null || dataProductRevisionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataProductRevision> modifiableList = new ArrayList<>(dataProductRevisionsParam.size());
            dataProductRevisionsParam.forEach(entry -> {
                DataProductRevision member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataProductRevision.Builder> copyToBuilder(Collection<? extends DataProductRevision> dataProductRevisionsParam) {
        List<DataProductRevision.Builder> list;
        if (dataProductRevisionsParam == null || dataProductRevisionsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataProductRevision.Builder> modifiableList = new ArrayList<>(dataProductRevisionsParam.size());
            dataProductRevisionsParam.forEach(entry -> {
                DataProductRevision.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
