/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlossaryResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateGlossaryResponse.Builder, CreateGlossaryResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateGlossaryResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateGlossaryResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateGlossaryResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGlossaryResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(CreateGlossaryResponse::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateGlossaryResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<String>> USAGE_RESTRICTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("usageRestrictions")
            .getter(getter(CreateGlossaryResponse::usageRestrictionsAsStrings))
            .setter(setter(Builder::usageRestrictionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageRestrictions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_ID_FIELD, ID_FIELD, NAME_FIELD, OWNING_PROJECT_ID_FIELD, STATUS_FIELD, USAGE_RESTRICTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String domainId;

    private final String id;

    private final String name;

    private final String owningProjectId;

    private final String status;

    private final List<String> usageRestrictions;

    private CreateGlossaryResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
        this.status = builder.status;
        this.usageRestrictions = builder.usageRestrictions;
    }

    /**
     * <p>
     * The description of this business glossary.
     * </p>
     * 
     * @return The description of this business glossary.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this business glossary is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this business glossary is created.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of this business glossary.
     * </p>
     * 
     * @return The ID of this business glossary.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of this business glossary.
     * </p>
     * 
     * @return The name of this business glossary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the project that currently owns this business glossary.
     * </p>
     * 
     * @return The ID of the project that currently owns this business glossary.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * <p>
     * The status of this business glossary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary.
     * @see GlossaryStatus
     */
    public final GlossaryStatus status() {
        return GlossaryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this business glossary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary.
     * @see GlossaryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The usage restriction of the restricted glossary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageRestrictions} method.
     * </p>
     * 
     * @return The usage restriction of the restricted glossary.
     */
    public final List<GlossaryUsageRestriction> usageRestrictions() {
        return GlossaryUsageRestrictionsCopier.copyStringToEnum(usageRestrictions);
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageRestrictions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageRestrictions() {
        return usageRestrictions != null && !(usageRestrictions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The usage restriction of the restricted glossary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageRestrictions} method.
     * </p>
     * 
     * @return The usage restriction of the restricted glossary.
     */
    public final List<String> usageRestrictionsAsStrings() {
        return usageRestrictions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageRestrictions() ? usageRestrictionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlossaryResponse)) {
            return false;
        }
        CreateGlossaryResponse other = (CreateGlossaryResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectId(), other.owningProjectId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasUsageRestrictions() == other.hasUsageRestrictions()
                && Objects.equals(usageRestrictionsAsStrings(), other.usageRestrictionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlossaryResponse")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("Id", id()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OwningProjectId", owningProjectId()).add("Status", statusAsString())
                .add("UsageRestrictions", hasUsageRestrictions() ? usageRestrictionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "usageRestrictions":
            return Optional.ofNullable(clazz.cast(usageRestrictionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("owningProjectId", OWNING_PROJECT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("usageRestrictions", USAGE_RESTRICTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlossaryResponse, T> g) {
        return obj -> g.apply((CreateGlossaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlossaryResponse> {
        /**
         * <p>
         * The description of this business glossary.
         * </p>
         * 
         * @param description
         *        The description of this business glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this business glossary is created.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which this business glossary is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of this business glossary.
         * </p>
         * 
         * @param id
         *        The ID of this business glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of this business glossary.
         * </p>
         * 
         * @param name
         *        The name of this business glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the project that currently owns this business glossary.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the project that currently owns this business glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * The status of this business glossary.
         * </p>
         * 
         * @param status
         *        The status of this business glossary.
         * @see GlossaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this business glossary.
         * </p>
         * 
         * @param status
         *        The status of this business glossary.
         * @see GlossaryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryStatus
         */
        Builder status(GlossaryStatus status);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictionsWithStrings(String... usageRestrictions);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions);

        /**
         * <p>
         * The usage restriction of the restricted glossary.
         * </p>
         * 
         * @param usageRestrictions
         *        The usage restriction of the restricted glossary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageRestrictions(GlossaryUsageRestriction... usageRestrictions);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String description;

        private String domainId;

        private String id;

        private String name;

        private String owningProjectId;

        private String status;

        private List<String> usageRestrictions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlossaryResponse model) {
            super(model);
            description(model.description);
            domainId(model.domainId);
            id(model.id);
            name(model.name);
            owningProjectId(model.owningProjectId);
            status(model.status);
            usageRestrictionsWithStrings(model.usageRestrictions);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getUsageRestrictions() {
            if (usageRestrictions instanceof SdkAutoConstructList) {
                return null;
            }
            return usageRestrictions;
        }

        public final void setUsageRestrictions(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
        }

        @Override
        public final Builder usageRestrictionsWithStrings(Collection<String> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copy(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictionsWithStrings(String... usageRestrictions) {
            usageRestrictionsWithStrings(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public final Builder usageRestrictions(Collection<GlossaryUsageRestriction> usageRestrictions) {
            this.usageRestrictions = GlossaryUsageRestrictionsCopier.copyEnumToString(usageRestrictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageRestrictions(GlossaryUsageRestriction... usageRestrictions) {
            usageRestrictions(Arrays.asList(usageRestrictions));
            return this;
        }

        @Override
        public CreateGlossaryResponse build() {
            return new CreateGlossaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
