/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connection properties patch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionPropertiesPatch implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionPropertiesPatch.Builder, ConnectionPropertiesPatch> {
    private static final SdkField<AmazonQPropertiesPatch> AMAZON_Q_PROPERTIES_FIELD = SdkField
            .<AmazonQPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("amazonQProperties")
            .getter(getter(ConnectionPropertiesPatch::amazonQProperties)).setter(setter(Builder::amazonQProperties))
            .constructor(AmazonQPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonQProperties").build()).build();

    private static final SdkField<AthenaPropertiesPatch> ATHENA_PROPERTIES_FIELD = SdkField
            .<AthenaPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("athenaProperties")
            .getter(getter(ConnectionPropertiesPatch::athenaProperties)).setter(setter(Builder::athenaProperties))
            .constructor(AthenaPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build()).build();

    private static final SdkField<GluePropertiesPatch> GLUE_PROPERTIES_FIELD = SdkField
            .<GluePropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("glueProperties")
            .getter(getter(ConnectionPropertiesPatch::glueProperties)).setter(setter(Builder::glueProperties))
            .constructor(GluePropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueProperties").build()).build();

    private static final SdkField<IamPropertiesPatch> IAM_PROPERTIES_FIELD = SdkField
            .<IamPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("iamProperties")
            .getter(getter(ConnectionPropertiesPatch::iamProperties)).setter(setter(Builder::iamProperties))
            .constructor(IamPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamProperties").build()).build();

    private static final SdkField<MlflowPropertiesPatch> MLFLOW_PROPERTIES_FIELD = SdkField
            .<MlflowPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("mlflowProperties")
            .getter(getter(ConnectionPropertiesPatch::mlflowProperties)).setter(setter(Builder::mlflowProperties))
            .constructor(MlflowPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlflowProperties").build()).build();

    private static final SdkField<RedshiftPropertiesPatch> REDSHIFT_PROPERTIES_FIELD = SdkField
            .<RedshiftPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("redshiftProperties")
            .getter(getter(ConnectionPropertiesPatch::redshiftProperties)).setter(setter(Builder::redshiftProperties))
            .constructor(RedshiftPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftProperties").build())
            .build();

    private static final SdkField<S3PropertiesPatch> S3_PROPERTIES_FIELD = SdkField
            .<S3PropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("s3Properties")
            .getter(getter(ConnectionPropertiesPatch::s3Properties)).setter(setter(Builder::s3Properties))
            .constructor(S3PropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Properties").build()).build();

    private static final SdkField<SparkEmrPropertiesPatch> SPARK_EMR_PROPERTIES_FIELD = SdkField
            .<SparkEmrPropertiesPatch> builder(MarshallingType.SDK_POJO).memberName("sparkEmrProperties")
            .getter(getter(ConnectionPropertiesPatch::sparkEmrProperties)).setter(setter(Builder::sparkEmrProperties))
            .constructor(SparkEmrPropertiesPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkEmrProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_Q_PROPERTIES_FIELD,
            ATHENA_PROPERTIES_FIELD, GLUE_PROPERTIES_FIELD, IAM_PROPERTIES_FIELD, MLFLOW_PROPERTIES_FIELD,
            REDSHIFT_PROPERTIES_FIELD, S3_PROPERTIES_FIELD, SPARK_EMR_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AmazonQPropertiesPatch amazonQProperties;

    private final AthenaPropertiesPatch athenaProperties;

    private final GluePropertiesPatch glueProperties;

    private final IamPropertiesPatch iamProperties;

    private final MlflowPropertiesPatch mlflowProperties;

    private final RedshiftPropertiesPatch redshiftProperties;

    private final S3PropertiesPatch s3Properties;

    private final SparkEmrPropertiesPatch sparkEmrProperties;

    private final Type type;

    private ConnectionPropertiesPatch(BuilderImpl builder) {
        this.amazonQProperties = builder.amazonQProperties;
        this.athenaProperties = builder.athenaProperties;
        this.glueProperties = builder.glueProperties;
        this.iamProperties = builder.iamProperties;
        this.mlflowProperties = builder.mlflowProperties;
        this.redshiftProperties = builder.redshiftProperties;
        this.s3Properties = builder.s3Properties;
        this.sparkEmrProperties = builder.sparkEmrProperties;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Q properties of the connection.
     * </p>
     * 
     * @return The Amazon Q properties of the connection.
     */
    public final AmazonQPropertiesPatch amazonQProperties() {
        return amazonQProperties;
    }

    /**
     * <p>
     * The Amazon Athena properties of a connection properties patch.
     * </p>
     * 
     * @return The Amazon Athena properties of a connection properties patch.
     */
    public final AthenaPropertiesPatch athenaProperties() {
        return athenaProperties;
    }

    /**
     * <p>
     * The Amazon Web Services Glue properties of a connection properties patch.
     * </p>
     * 
     * @return The Amazon Web Services Glue properties of a connection properties patch.
     */
    public final GluePropertiesPatch glueProperties() {
        return glueProperties;
    }

    /**
     * <p>
     * The IAM properties of a connection properties patch.
     * </p>
     * 
     * @return The IAM properties of a connection properties patch.
     */
    public final IamPropertiesPatch iamProperties() {
        return iamProperties;
    }

    /**
     * <p>
     * The MLflow properties of a connection.
     * </p>
     * 
     * @return The MLflow properties of a connection.
     */
    public final MlflowPropertiesPatch mlflowProperties() {
        return mlflowProperties;
    }

    /**
     * <p>
     * The Amazon Redshift properties of a connection properties patch.
     * </p>
     * 
     * @return The Amazon Redshift properties of a connection properties patch.
     */
    public final RedshiftPropertiesPatch redshiftProperties() {
        return redshiftProperties;
    }

    /**
     * <p>
     * The Amazon S3 properties of a connection properties patch.
     * </p>
     * 
     * @return The Amazon S3 properties of a connection properties patch.
     */
    public final S3PropertiesPatch s3Properties() {
        return s3Properties;
    }

    /**
     * <p>
     * The Spark EMR properties of a connection properties patch.
     * </p>
     * 
     * @return The Spark EMR properties of a connection properties patch.
     */
    public final SparkEmrPropertiesPatch sparkEmrProperties() {
        return sparkEmrProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonQProperties());
        hashCode = 31 * hashCode + Objects.hashCode(athenaProperties());
        hashCode = 31 * hashCode + Objects.hashCode(glueProperties());
        hashCode = 31 * hashCode + Objects.hashCode(iamProperties());
        hashCode = 31 * hashCode + Objects.hashCode(mlflowProperties());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftProperties());
        hashCode = 31 * hashCode + Objects.hashCode(s3Properties());
        hashCode = 31 * hashCode + Objects.hashCode(sparkEmrProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPropertiesPatch)) {
            return false;
        }
        ConnectionPropertiesPatch other = (ConnectionPropertiesPatch) obj;
        return Objects.equals(amazonQProperties(), other.amazonQProperties())
                && Objects.equals(athenaProperties(), other.athenaProperties())
                && Objects.equals(glueProperties(), other.glueProperties())
                && Objects.equals(iamProperties(), other.iamProperties())
                && Objects.equals(mlflowProperties(), other.mlflowProperties())
                && Objects.equals(redshiftProperties(), other.redshiftProperties())
                && Objects.equals(s3Properties(), other.s3Properties())
                && Objects.equals(sparkEmrProperties(), other.sparkEmrProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionPropertiesPatch").add("AmazonQProperties", amazonQProperties())
                .add("AthenaProperties", athenaProperties()).add("GlueProperties", glueProperties())
                .add("IamProperties", iamProperties()).add("MlflowProperties", mlflowProperties())
                .add("RedshiftProperties", redshiftProperties()).add("S3Properties", s3Properties())
                .add("SparkEmrProperties", sparkEmrProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amazonQProperties":
            return Optional.ofNullable(clazz.cast(amazonQProperties()));
        case "athenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "glueProperties":
            return Optional.ofNullable(clazz.cast(glueProperties()));
        case "iamProperties":
            return Optional.ofNullable(clazz.cast(iamProperties()));
        case "mlflowProperties":
            return Optional.ofNullable(clazz.cast(mlflowProperties()));
        case "redshiftProperties":
            return Optional.ofNullable(clazz.cast(redshiftProperties()));
        case "s3Properties":
            return Optional.ofNullable(clazz.cast(s3Properties()));
        case "sparkEmrProperties":
            return Optional.ofNullable(clazz.cast(sparkEmrProperties()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #amazonQProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Q properties of the connection.
     * </p>
     * 
     * @param amazonQProperties
     *        The Amazon Q properties of the connection.
     */
    public static ConnectionPropertiesPatch fromAmazonQProperties(AmazonQPropertiesPatch amazonQProperties) {
        return builder().amazonQProperties(amazonQProperties).build();
    }

    /**
     * Create an instance of this class with {@link #amazonQProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Q properties of the connection.
     * </p>
     * 
     * @param amazonQProperties
     *        The Amazon Q properties of the connection.
     */
    public static ConnectionPropertiesPatch fromAmazonQProperties(Consumer<AmazonQPropertiesPatch.Builder> amazonQProperties) {
        AmazonQPropertiesPatch.Builder builder = AmazonQPropertiesPatch.builder();
        amazonQProperties.accept(builder);
        return fromAmazonQProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection properties patch.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromAthenaProperties(AthenaPropertiesPatch athenaProperties) {
        return builder().athenaProperties(athenaProperties).build();
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection properties patch.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromAthenaProperties(Consumer<AthenaPropertiesPatch.Builder> athenaProperties) {
        AthenaPropertiesPatch.Builder builder = AthenaPropertiesPatch.builder();
        athenaProperties.accept(builder);
        return fromAthenaProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection properties patch.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromGlueProperties(GluePropertiesPatch glueProperties) {
        return builder().glueProperties(glueProperties).build();
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection properties patch.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromGlueProperties(Consumer<GluePropertiesPatch.Builder> glueProperties) {
        GluePropertiesPatch.Builder builder = GluePropertiesPatch.builder();
        glueProperties.accept(builder);
        return fromGlueProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection properties patch.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromIamProperties(IamPropertiesPatch iamProperties) {
        return builder().iamProperties(iamProperties).build();
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection properties patch.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromIamProperties(Consumer<IamPropertiesPatch.Builder> iamProperties) {
        IamPropertiesPatch.Builder builder = IamPropertiesPatch.builder();
        iamProperties.accept(builder);
        return fromIamProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mlflowProperties()} initialized to the given value.
     *
     * <p>
     * The MLflow properties of a connection.
     * </p>
     * 
     * @param mlflowProperties
     *        The MLflow properties of a connection.
     */
    public static ConnectionPropertiesPatch fromMlflowProperties(MlflowPropertiesPatch mlflowProperties) {
        return builder().mlflowProperties(mlflowProperties).build();
    }

    /**
     * Create an instance of this class with {@link #mlflowProperties()} initialized to the given value.
     *
     * <p>
     * The MLflow properties of a connection.
     * </p>
     * 
     * @param mlflowProperties
     *        The MLflow properties of a connection.
     */
    public static ConnectionPropertiesPatch fromMlflowProperties(Consumer<MlflowPropertiesPatch.Builder> mlflowProperties) {
        MlflowPropertiesPatch.Builder builder = MlflowPropertiesPatch.builder();
        mlflowProperties.accept(builder);
        return fromMlflowProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection properties patch.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromRedshiftProperties(RedshiftPropertiesPatch redshiftProperties) {
        return builder().redshiftProperties(redshiftProperties).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection properties patch.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromRedshiftProperties(Consumer<RedshiftPropertiesPatch.Builder> redshiftProperties) {
        RedshiftPropertiesPatch.Builder builder = RedshiftPropertiesPatch.builder();
        redshiftProperties.accept(builder);
        return fromRedshiftProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3Properties()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 properties of a connection properties patch.
     * </p>
     * 
     * @param s3Properties
     *        The Amazon S3 properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromS3Properties(S3PropertiesPatch s3Properties) {
        return builder().s3Properties(s3Properties).build();
    }

    /**
     * Create an instance of this class with {@link #s3Properties()} initialized to the given value.
     *
     * <p>
     * The Amazon S3 properties of a connection properties patch.
     * </p>
     * 
     * @param s3Properties
     *        The Amazon S3 properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromS3Properties(Consumer<S3PropertiesPatch.Builder> s3Properties) {
        S3PropertiesPatch.Builder builder = S3PropertiesPatch.builder();
        s3Properties.accept(builder);
        return fromS3Properties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection properties patch.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromSparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties) {
        return builder().sparkEmrProperties(sparkEmrProperties).build();
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection properties patch.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection properties patch.
     */
    public static ConnectionPropertiesPatch fromSparkEmrProperties(Consumer<SparkEmrPropertiesPatch.Builder> sparkEmrProperties) {
        SparkEmrPropertiesPatch.Builder builder = SparkEmrPropertiesPatch.builder();
        sparkEmrProperties.accept(builder);
        return fromSparkEmrProperties(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amazonQProperties", AMAZON_Q_PROPERTIES_FIELD);
        map.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
        map.put("glueProperties", GLUE_PROPERTIES_FIELD);
        map.put("iamProperties", IAM_PROPERTIES_FIELD);
        map.put("mlflowProperties", MLFLOW_PROPERTIES_FIELD);
        map.put("redshiftProperties", REDSHIFT_PROPERTIES_FIELD);
        map.put("s3Properties", S3_PROPERTIES_FIELD);
        map.put("sparkEmrProperties", SPARK_EMR_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPropertiesPatch, T> g) {
        return obj -> g.apply((ConnectionPropertiesPatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionPropertiesPatch> {
        /**
         * <p>
         * The Amazon Q properties of the connection.
         * </p>
         * 
         * @param amazonQProperties
         *        The Amazon Q properties of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonQProperties(AmazonQPropertiesPatch amazonQProperties);

        /**
         * <p>
         * The Amazon Q properties of the connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmazonQPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link AmazonQPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonQPropertiesPatch.Builder#build()} is called immediately and
         * its result is passed to {@link #amazonQProperties(AmazonQPropertiesPatch)}.
         * 
         * @param amazonQProperties
         *        a consumer that will call methods on {@link AmazonQPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonQProperties(AmazonQPropertiesPatch)
         */
        default Builder amazonQProperties(Consumer<AmazonQPropertiesPatch.Builder> amazonQProperties) {
            return amazonQProperties(AmazonQPropertiesPatch.builder().applyMutation(amazonQProperties).build());
        }

        /**
         * <p>
         * The Amazon Athena properties of a connection properties patch.
         * </p>
         * 
         * @param athenaProperties
         *        The Amazon Athena properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(AthenaPropertiesPatch athenaProperties);

        /**
         * <p>
         * The Amazon Athena properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link AthenaPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaPropertiesPatch.Builder#build()} is called immediately and
         * its result is passed to {@link #athenaProperties(AthenaPropertiesPatch)}.
         * 
         * @param athenaProperties
         *        a consumer that will call methods on {@link AthenaPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaProperties(AthenaPropertiesPatch)
         */
        default Builder athenaProperties(Consumer<AthenaPropertiesPatch.Builder> athenaProperties) {
            return athenaProperties(AthenaPropertiesPatch.builder().applyMutation(athenaProperties).build());
        }

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection properties patch.
         * </p>
         * 
         * @param glueProperties
         *        The Amazon Web Services Glue properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueProperties(GluePropertiesPatch glueProperties);

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link GluePropertiesPatch.Builder} avoiding the
         * need to create one manually via {@link GluePropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GluePropertiesPatch.Builder#build()} is called immediately and
         * its result is passed to {@link #glueProperties(GluePropertiesPatch)}.
         * 
         * @param glueProperties
         *        a consumer that will call methods on {@link GluePropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueProperties(GluePropertiesPatch)
         */
        default Builder glueProperties(Consumer<GluePropertiesPatch.Builder> glueProperties) {
            return glueProperties(GluePropertiesPatch.builder().applyMutation(glueProperties).build());
        }

        /**
         * <p>
         * The IAM properties of a connection properties patch.
         * </p>
         * 
         * @param iamProperties
         *        The IAM properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamProperties(IamPropertiesPatch iamProperties);

        /**
         * <p>
         * The IAM properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamPropertiesPatch.Builder} avoiding the
         * need to create one manually via {@link IamPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamPropertiesPatch.Builder#build()} is called immediately and its
         * result is passed to {@link #iamProperties(IamPropertiesPatch)}.
         * 
         * @param iamProperties
         *        a consumer that will call methods on {@link IamPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamProperties(IamPropertiesPatch)
         */
        default Builder iamProperties(Consumer<IamPropertiesPatch.Builder> iamProperties) {
            return iamProperties(IamPropertiesPatch.builder().applyMutation(iamProperties).build());
        }

        /**
         * <p>
         * The MLflow properties of a connection.
         * </p>
         * 
         * @param mlflowProperties
         *        The MLflow properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlflowProperties(MlflowPropertiesPatch mlflowProperties);

        /**
         * <p>
         * The MLflow properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlflowPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link MlflowPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlflowPropertiesPatch.Builder#build()} is called immediately and
         * its result is passed to {@link #mlflowProperties(MlflowPropertiesPatch)}.
         * 
         * @param mlflowProperties
         *        a consumer that will call methods on {@link MlflowPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mlflowProperties(MlflowPropertiesPatch)
         */
        default Builder mlflowProperties(Consumer<MlflowPropertiesPatch.Builder> mlflowProperties) {
            return mlflowProperties(MlflowPropertiesPatch.builder().applyMutation(mlflowProperties).build());
        }

        /**
         * <p>
         * The Amazon Redshift properties of a connection properties patch.
         * </p>
         * 
         * @param redshiftProperties
         *        The Amazon Redshift properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftProperties(RedshiftPropertiesPatch redshiftProperties);

        /**
         * <p>
         * The Amazon Redshift properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link RedshiftPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftPropertiesPatch.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftProperties(RedshiftPropertiesPatch)}.
         * 
         * @param redshiftProperties
         *        a consumer that will call methods on {@link RedshiftPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftProperties(RedshiftPropertiesPatch)
         */
        default Builder redshiftProperties(Consumer<RedshiftPropertiesPatch.Builder> redshiftProperties) {
            return redshiftProperties(RedshiftPropertiesPatch.builder().applyMutation(redshiftProperties).build());
        }

        /**
         * <p>
         * The Amazon S3 properties of a connection properties patch.
         * </p>
         * 
         * @param s3Properties
         *        The Amazon S3 properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Properties(S3PropertiesPatch s3Properties);

        /**
         * <p>
         * The Amazon S3 properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3PropertiesPatch.Builder} avoiding the
         * need to create one manually via {@link S3PropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3PropertiesPatch.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Properties(S3PropertiesPatch)}.
         * 
         * @param s3Properties
         *        a consumer that will call methods on {@link S3PropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Properties(S3PropertiesPatch)
         */
        default Builder s3Properties(Consumer<S3PropertiesPatch.Builder> s3Properties) {
            return s3Properties(S3PropertiesPatch.builder().applyMutation(s3Properties).build());
        }

        /**
         * <p>
         * The Spark EMR properties of a connection properties patch.
         * </p>
         * 
         * @param sparkEmrProperties
         *        The Spark EMR properties of a connection properties patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties);

        /**
         * <p>
         * The Spark EMR properties of a connection properties patch.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkEmrPropertiesPatch.Builder} avoiding
         * the need to create one manually via {@link SparkEmrPropertiesPatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkEmrPropertiesPatch.Builder#build()} is called immediately
         * and its result is passed to {@link #sparkEmrProperties(SparkEmrPropertiesPatch)}.
         * 
         * @param sparkEmrProperties
         *        a consumer that will call methods on {@link SparkEmrPropertiesPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkEmrProperties(SparkEmrPropertiesPatch)
         */
        default Builder sparkEmrProperties(Consumer<SparkEmrPropertiesPatch.Builder> sparkEmrProperties) {
            return sparkEmrProperties(SparkEmrPropertiesPatch.builder().applyMutation(sparkEmrProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AmazonQPropertiesPatch amazonQProperties;

        private AthenaPropertiesPatch athenaProperties;

        private GluePropertiesPatch glueProperties;

        private IamPropertiesPatch iamProperties;

        private MlflowPropertiesPatch mlflowProperties;

        private RedshiftPropertiesPatch redshiftProperties;

        private S3PropertiesPatch s3Properties;

        private SparkEmrPropertiesPatch sparkEmrProperties;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPropertiesPatch model) {
            amazonQProperties(model.amazonQProperties);
            athenaProperties(model.athenaProperties);
            glueProperties(model.glueProperties);
            iamProperties(model.iamProperties);
            mlflowProperties(model.mlflowProperties);
            redshiftProperties(model.redshiftProperties);
            s3Properties(model.s3Properties);
            sparkEmrProperties(model.sparkEmrProperties);
        }

        public final AmazonQPropertiesPatch.Builder getAmazonQProperties() {
            return amazonQProperties != null ? amazonQProperties.toBuilder() : null;
        }

        public final void setAmazonQProperties(AmazonQPropertiesPatch.BuilderImpl amazonQProperties) {
            Object oldValue = this.amazonQProperties;
            this.amazonQProperties = amazonQProperties != null ? amazonQProperties.build() : null;
            handleUnionValueChange(Type.AMAZON_Q_PROPERTIES, oldValue, this.amazonQProperties);
        }

        @Override
        public final Builder amazonQProperties(AmazonQPropertiesPatch amazonQProperties) {
            Object oldValue = this.amazonQProperties;
            this.amazonQProperties = amazonQProperties;
            handleUnionValueChange(Type.AMAZON_Q_PROPERTIES, oldValue, this.amazonQProperties);
            return this;
        }

        public final AthenaPropertiesPatch.Builder getAthenaProperties() {
            return athenaProperties != null ? athenaProperties.toBuilder() : null;
        }

        public final void setAthenaProperties(AthenaPropertiesPatch.BuilderImpl athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties != null ? athenaProperties.build() : null;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
        }

        @Override
        public final Builder athenaProperties(AthenaPropertiesPatch athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
            return this;
        }

        public final GluePropertiesPatch.Builder getGlueProperties() {
            return glueProperties != null ? glueProperties.toBuilder() : null;
        }

        public final void setGlueProperties(GluePropertiesPatch.BuilderImpl glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties != null ? glueProperties.build() : null;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
        }

        @Override
        public final Builder glueProperties(GluePropertiesPatch glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
            return this;
        }

        public final IamPropertiesPatch.Builder getIamProperties() {
            return iamProperties != null ? iamProperties.toBuilder() : null;
        }

        public final void setIamProperties(IamPropertiesPatch.BuilderImpl iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties != null ? iamProperties.build() : null;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
        }

        @Override
        public final Builder iamProperties(IamPropertiesPatch iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
            return this;
        }

        public final MlflowPropertiesPatch.Builder getMlflowProperties() {
            return mlflowProperties != null ? mlflowProperties.toBuilder() : null;
        }

        public final void setMlflowProperties(MlflowPropertiesPatch.BuilderImpl mlflowProperties) {
            Object oldValue = this.mlflowProperties;
            this.mlflowProperties = mlflowProperties != null ? mlflowProperties.build() : null;
            handleUnionValueChange(Type.MLFLOW_PROPERTIES, oldValue, this.mlflowProperties);
        }

        @Override
        public final Builder mlflowProperties(MlflowPropertiesPatch mlflowProperties) {
            Object oldValue = this.mlflowProperties;
            this.mlflowProperties = mlflowProperties;
            handleUnionValueChange(Type.MLFLOW_PROPERTIES, oldValue, this.mlflowProperties);
            return this;
        }

        public final RedshiftPropertiesPatch.Builder getRedshiftProperties() {
            return redshiftProperties != null ? redshiftProperties.toBuilder() : null;
        }

        public final void setRedshiftProperties(RedshiftPropertiesPatch.BuilderImpl redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties != null ? redshiftProperties.build() : null;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
        }

        @Override
        public final Builder redshiftProperties(RedshiftPropertiesPatch redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
            return this;
        }

        public final S3PropertiesPatch.Builder getS3Properties() {
            return s3Properties != null ? s3Properties.toBuilder() : null;
        }

        public final void setS3Properties(S3PropertiesPatch.BuilderImpl s3Properties) {
            Object oldValue = this.s3Properties;
            this.s3Properties = s3Properties != null ? s3Properties.build() : null;
            handleUnionValueChange(Type.S3_PROPERTIES, oldValue, this.s3Properties);
        }

        @Override
        public final Builder s3Properties(S3PropertiesPatch s3Properties) {
            Object oldValue = this.s3Properties;
            this.s3Properties = s3Properties;
            handleUnionValueChange(Type.S3_PROPERTIES, oldValue, this.s3Properties);
            return this;
        }

        public final SparkEmrPropertiesPatch.Builder getSparkEmrProperties() {
            return sparkEmrProperties != null ? sparkEmrProperties.toBuilder() : null;
        }

        public final void setSparkEmrProperties(SparkEmrPropertiesPatch.BuilderImpl sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties != null ? sparkEmrProperties.build() : null;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
        }

        @Override
        public final Builder sparkEmrProperties(SparkEmrPropertiesPatch sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
            return this;
        }

        @Override
        public ConnectionPropertiesPatch build() {
            return new ConnectionPropertiesPatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConnectionPropertiesPatch#type()
     */
    public enum Type {
        AMAZON_Q_PROPERTIES,

        ATHENA_PROPERTIES,

        GLUE_PROPERTIES,

        IAM_PROPERTIES,

        MLFLOW_PROPERTIES,

        REDSHIFT_PROPERTIES,

        S3_PROPERTIES,

        SPARK_EMR_PROPERTIES,

        UNKNOWN_TO_SDK_VERSION
    }
}
