/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAttributesMetadataRequest extends DataZoneRequest implements
        ToCopyableBuilder<BatchGetAttributesMetadataRequest.Builder, BatchGetAttributesMetadataRequest> {
    private static final SdkField<List<String>> ATTRIBUTE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("attributeIdentifiers")
            .getter(getter(BatchGetAttributesMetadataRequest::attributeIdentifiers))
            .setter(setter(Builder::attributeIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("attributeIdentifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(BatchGetAttributesMetadataRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(BatchGetAttributesMetadataRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityRevision").getter(getter(BatchGetAttributesMetadataRequest::entityRevision))
            .setter(setter(Builder::entityRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("entityRevision").build())
            .build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(BatchGetAttributesMetadataRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_IDENTIFIERS_FIELD,
            DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> attributeIdentifiers;

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityRevision;

    private final String entityType;

    private BatchGetAttributesMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.attributeIdentifiers = builder.attributeIdentifiers;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeIdentifiers() {
        return attributeIdentifiers != null && !(attributeIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attribute identifier.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeIdentifiers} method.
     * </p>
     * 
     * @return The attribute identifier.
     */
    public final List<String> attributeIdentifiers() {
        return attributeIdentifiers;
    }

    /**
     * <p>
     * The domain ID where you want to get the attribute metadata.
     * </p>
     * 
     * @return The domain ID where you want to get the attribute metadata.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The entity ID for which you want to get attribute metadata.
     * </p>
     * 
     * @return The entity ID for which you want to get attribute metadata.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The entity revision for which you want to get attribute metadata.
     * </p>
     * 
     * @return The entity revision for which you want to get attribute metadata.
     */
    public final String entityRevision() {
        return entityRevision;
    }

    /**
     * <p>
     * The entity type for which you want to get attribute metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link AttributeEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The entity type for which you want to get attribute metadata.
     * @see AttributeEntityType
     */
    public final AttributeEntityType entityType() {
        return AttributeEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The entity type for which you want to get attribute metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link AttributeEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The entity type for which you want to get attribute metadata.
     * @see AttributeEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeIdentifiers() ? attributeIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttributesMetadataRequest)) {
            return false;
        }
        BatchGetAttributesMetadataRequest other = (BatchGetAttributesMetadataRequest) obj;
        return hasAttributeIdentifiers() == other.hasAttributeIdentifiers()
                && Objects.equals(attributeIdentifiers(), other.attributeIdentifiers())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityRevision(), other.entityRevision())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAttributesMetadataRequest")
                .add("AttributeIdentifiers", hasAttributeIdentifiers() ? attributeIdentifiers() : null)
                .add("DomainIdentifier", domainIdentifier()).add("EntityIdentifier", entityIdentifier())
                .add("EntityRevision", entityRevision()).add("EntityType", entityTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributeIdentifiers":
            return Optional.ofNullable(clazz.cast(attributeIdentifiers()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityRevision":
            return Optional.ofNullable(clazz.cast(entityRevision()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributeIdentifier", ATTRIBUTE_IDENTIFIERS_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityRevision", ENTITY_REVISION_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttributesMetadataRequest, T> g) {
        return obj -> g.apply((BatchGetAttributesMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAttributesMetadataRequest> {
        /**
         * <p>
         * The attribute identifier.
         * </p>
         * 
         * @param attributeIdentifiers
         *        The attribute identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeIdentifiers(Collection<String> attributeIdentifiers);

        /**
         * <p>
         * The attribute identifier.
         * </p>
         * 
         * @param attributeIdentifiers
         *        The attribute identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeIdentifiers(String... attributeIdentifiers);

        /**
         * <p>
         * The domain ID where you want to get the attribute metadata.
         * </p>
         * 
         * @param domainIdentifier
         *        The domain ID where you want to get the attribute metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The entity ID for which you want to get attribute metadata.
         * </p>
         * 
         * @param entityIdentifier
         *        The entity ID for which you want to get attribute metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The entity revision for which you want to get attribute metadata.
         * </p>
         * 
         * @param entityRevision
         *        The entity revision for which you want to get attribute metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRevision(String entityRevision);

        /**
         * <p>
         * The entity type for which you want to get attribute metadata.
         * </p>
         * 
         * @param entityType
         *        The entity type for which you want to get attribute metadata.
         * @see AttributeEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The entity type for which you want to get attribute metadata.
         * </p>
         * 
         * @param entityType
         *        The entity type for which you want to get attribute metadata.
         * @see AttributeEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeEntityType
         */
        Builder entityType(AttributeEntityType entityType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private List<String> attributeIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String domainIdentifier;

        private String entityIdentifier;

        private String entityRevision;

        private String entityType;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttributesMetadataRequest model) {
            super(model);
            attributeIdentifiers(model.attributeIdentifiers);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityRevision(model.entityRevision);
            entityType(model.entityType);
        }

        public final Collection<String> getAttributeIdentifiers() {
            if (attributeIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeIdentifiers;
        }

        public final void setAttributeIdentifiers(Collection<String> attributeIdentifiers) {
            this.attributeIdentifiers = AttributesListCopier.copy(attributeIdentifiers);
        }

        @Override
        public final Builder attributeIdentifiers(Collection<String> attributeIdentifiers) {
            this.attributeIdentifiers = AttributesListCopier.copy(attributeIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeIdentifiers(String... attributeIdentifiers) {
            attributeIdentifiers(Arrays.asList(attributeIdentifiers));
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityRevision() {
            return entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(AttributeEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAttributesMetadataRequest build() {
            return new BatchGetAttributesMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
