/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleTargetType {
    DOMAIN_UNIT("DOMAIN_UNIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleTargetType> VALUE_MAP;
    private final String value;

    private RuleTargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleTargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleTargetType> knownValues() {
        EnumSet<RuleTargetType> knownValues = EnumSet.allOf(RuleTargetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleTargetType.class, RuleTargetType::toString);
    }
}

