/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ConnectionPropertiesOutput;
import software.amazon.awssdk.services.datazone.model.ConnectionScope;
import software.amazon.awssdk.services.datazone.model.ConnectionType;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.PhysicalEndpoint;
import software.amazon.awssdk.services.datazone.model.PhysicalEndpointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, UpdateConnectionResponse> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionId").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::connectionId)).setter(UpdateConnectionResponse.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::description)).setter(UpdateConnectionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::domainId)).setter(UpdateConnectionResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainUnitId").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::domainUnitId)).setter(UpdateConnectionResponse.setter(Builder::domainUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::environmentId)).setter(UpdateConnectionResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::name)).setter(UpdateConnectionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<PhysicalEndpoint>> PHYSICAL_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("physicalEndpoints").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::physicalEndpoints)).setter(UpdateConnectionResponse.setter(Builder::physicalEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhysicalEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::projectId)).setter(UpdateConnectionResponse.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<ConnectionPropertiesOutput> PROPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("props").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::props)).setter(UpdateConnectionResponse.setter(Builder::props)).constructor(ConnectionPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("props").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::scopeAsString)).setter(UpdateConnectionResponse.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UpdateConnectionResponse.getter(UpdateConnectionResponse::typeAsString)).setter(UpdateConnectionResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ENVIRONMENT_ID_FIELD, NAME_FIELD, PHYSICAL_ENDPOINTS_FIELD, PROJECT_ID_FIELD, PROPS_FIELD, SCOPE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectionResponse.memberNameToFieldInitializer();
    private final String connectionId;
    private final String description;
    private final String domainId;
    private final String domainUnitId;
    private final String environmentId;
    private final String name;
    private final List<PhysicalEndpoint> physicalEndpoints;
    private final String projectId;
    private final ConnectionPropertiesOutput props;
    private final String scope;
    private final String type;

    private UpdateConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.environmentId = builder.environmentId;
        this.name = builder.name;
        this.physicalEndpoints = builder.physicalEndpoints;
        this.projectId = builder.projectId;
        this.props = builder.props;
        this.scope = builder.scope;
        this.type = builder.type;
    }

    public final String connectionId() {
        return this.connectionId;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainUnitId() {
        return this.domainUnitId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasPhysicalEndpoints() {
        return this.physicalEndpoints != null && !(this.physicalEndpoints instanceof SdkAutoConstructList);
    }

    public final List<PhysicalEndpoint> physicalEndpoints() {
        return this.physicalEndpoints;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final ConnectionPropertiesOutput props() {
        return this.props;
    }

    public final ConnectionScope scope() {
        return ConnectionScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final ConnectionType type() {
        return ConnectionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhysicalEndpoints() ? this.physicalEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.props());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionResponse)) {
            return false;
        }
        UpdateConnectionResponse other = (UpdateConnectionResponse)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainUnitId(), other.domainUnitId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.name(), other.name()) && this.hasPhysicalEndpoints() == other.hasPhysicalEndpoints() && Objects.equals(this.physicalEndpoints(), other.physicalEndpoints()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.props(), other.props()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionResponse").add("ConnectionId", (Object)this.connectionId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("DomainUnitId", (Object)this.domainUnitId()).add("EnvironmentId", (Object)this.environmentId()).add("Name", (Object)this.name()).add("PhysicalEndpoints", this.hasPhysicalEndpoints() ? this.physicalEndpoints() : null).add("ProjectId", (Object)this.projectId()).add("Props", (Object)this.props()).add("Scope", (Object)this.scopeAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "domainUnitId": {
                return Optional.ofNullable(clazz.cast(this.domainUnitId()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "physicalEndpoints": {
                return Optional.ofNullable(clazz.cast(this.physicalEndpoints()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "props": {
                return Optional.ofNullable(clazz.cast(this.props()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectionId", CONNECTION_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("physicalEndpoints", PHYSICAL_ENDPOINTS_FIELD);
        map.put("projectId", PROJECT_ID_FIELD);
        map.put("props", PROPS_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionResponse, T> g) {
        return obj -> g.apply((UpdateConnectionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String connectionId;
        private String description;
        private String domainId;
        private String domainUnitId;
        private String environmentId;
        private String name;
        private List<PhysicalEndpoint> physicalEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String projectId;
        private ConnectionPropertiesOutput props;
        private String scope;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionResponse model) {
            super(model);
            this.connectionId(model.connectionId);
            this.description(model.description);
            this.domainId(model.domainId);
            this.domainUnitId(model.domainUnitId);
            this.environmentId(model.environmentId);
            this.name(model.name);
            this.physicalEndpoints(model.physicalEndpoints);
            this.projectId(model.projectId);
            this.props(model.props);
            this.scope(model.scope);
            this.type(model.type);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return this.domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<PhysicalEndpoint.Builder> getPhysicalEndpoints() {
            List<PhysicalEndpoint.Builder> result = PhysicalEndpointsCopier.copyToBuilder(this.physicalEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhysicalEndpoints(Collection<PhysicalEndpoint.BuilderImpl> physicalEndpoints) {
            this.physicalEndpoints = PhysicalEndpointsCopier.copyFromBuilder(physicalEndpoints);
        }

        @Override
        public final Builder physicalEndpoints(Collection<PhysicalEndpoint> physicalEndpoints) {
            this.physicalEndpoints = PhysicalEndpointsCopier.copy(physicalEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalEndpoints(PhysicalEndpoint ... physicalEndpoints) {
            this.physicalEndpoints(Arrays.asList(physicalEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalEndpoints(Consumer<PhysicalEndpoint.Builder> ... physicalEndpoints) {
            this.physicalEndpoints(Stream.of(physicalEndpoints).map(c -> (PhysicalEndpoint)((PhysicalEndpoint.Builder)PhysicalEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final ConnectionPropertiesOutput.Builder getProps() {
            return this.props != null ? this.props.toBuilder() : null;
        }

        public final void setProps(ConnectionPropertiesOutput.BuilderImpl props) {
            this.props = props != null ? props.build() : null;
        }

        @Override
        public final Builder props(ConnectionPropertiesOutput props) {
            this.props = props;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(ConnectionScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConnectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public UpdateConnectionResponse build() {
            return new UpdateConnectionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionResponse> {
        public Builder connectionId(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder domainUnitId(String var1);

        public Builder environmentId(String var1);

        public Builder name(String var1);

        public Builder physicalEndpoints(Collection<PhysicalEndpoint> var1);

        public Builder physicalEndpoints(PhysicalEndpoint ... var1);

        public Builder physicalEndpoints(Consumer<PhysicalEndpoint.Builder> ... var1);

        public Builder projectId(String var1);

        public Builder props(ConnectionPropertiesOutput var1);

        default public Builder props(Consumer<ConnectionPropertiesOutput.Builder> props) {
            return this.props((ConnectionPropertiesOutput)((ConnectionPropertiesOutput.Builder)ConnectionPropertiesOutput.builder().applyMutation(props)).build());
        }

        public Builder scope(String var1);

        public Builder scope(ConnectionScope var1);

        public Builder type(String var1);

        public Builder type(ConnectionType var1);
    }
}

