/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AwsRegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountInfo> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(AccountInfo.getter(AccountInfo::awsAccountId)).setter(AccountInfo.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountName").getter(AccountInfo.getter(AccountInfo::awsAccountName)).setter(AccountInfo.setter(Builder::awsAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountName").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedRegions").getter(AccountInfo.getter(AccountInfo::supportedRegions)).setter(AccountInfo.setter(Builder::supportedRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, AWS_ACCOUNT_NAME_FIELD, SUPPORTED_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsAccountId;
    private final String awsAccountName;
    private final List<String> supportedRegions;

    private AccountInfo(BuilderImpl builder) {
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountName = builder.awsAccountName;
        this.supportedRegions = builder.supportedRegions;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsAccountName() {
        return this.awsAccountName;
    }

    public final boolean hasSupportedRegions() {
        return this.supportedRegions != null && !(this.supportedRegions instanceof SdkAutoConstructList);
    }

    public final List<String> supportedRegions() {
        return this.supportedRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedRegions() ? this.supportedRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountInfo)) {
            return false;
        }
        AccountInfo other = (AccountInfo)obj;
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsAccountName(), other.awsAccountName()) && this.hasSupportedRegions() == other.hasSupportedRegions() && Objects.equals(this.supportedRegions(), other.supportedRegions());
    }

    public final String toString() {
        return ToString.builder((String)"AccountInfo").add("AwsAccountId", (Object)this.awsAccountId()).add("AwsAccountName", (Object)(this.awsAccountName() == null ? null : "*** Sensitive Data Redacted ***")).add("SupportedRegions", this.hasSupportedRegions() ? this.supportedRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "awsAccountName": {
                return Optional.ofNullable(clazz.cast(this.awsAccountName()));
            }
            case "supportedRegions": {
                return Optional.ofNullable(clazz.cast(this.supportedRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsAccountName", AWS_ACCOUNT_NAME_FIELD);
        map.put("supportedRegions", SUPPORTED_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountInfo, T> g) {
        return obj -> g.apply((AccountInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String awsAccountName;
        private List<String> supportedRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountInfo model) {
            this.awsAccountId(model.awsAccountId);
            this.awsAccountName(model.awsAccountName);
            this.supportedRegions(model.supportedRegions);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountName() {
            return this.awsAccountName;
        }

        public final void setAwsAccountName(String awsAccountName) {
            this.awsAccountName = awsAccountName;
        }

        @Override
        public final Builder awsAccountName(String awsAccountName) {
            this.awsAccountName = awsAccountName;
            return this;
        }

        public final Collection<String> getSupportedRegions() {
            if (this.supportedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedRegions;
        }

        public final void setSupportedRegions(Collection<String> supportedRegions) {
            this.supportedRegions = AwsRegionListCopier.copy(supportedRegions);
        }

        @Override
        public final Builder supportedRegions(Collection<String> supportedRegions) {
            this.supportedRegions = AwsRegionListCopier.copy(supportedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRegions(String ... supportedRegions) {
            this.supportedRegions(Arrays.asList(supportedRegions));
            return this;
        }

        public AccountInfo build() {
            return new AccountInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountInfo> {
        public Builder awsAccountId(String var1);

        public Builder awsAccountName(String var1);

        public Builder supportedRegions(Collection<String> var1);

        public Builder supportedRegions(String ... var1);
    }
}

