/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobRunStatus {
    SCHEDULED("SCHEDULED"),
    IN_PROGRESS("IN_PROGRESS"),
    SUCCESS("SUCCESS"),
    PARTIALLY_SUCCEEDED("PARTIALLY_SUCCEEDED"),
    FAILED("FAILED"),
    ABORTED("ABORTED"),
    TIMED_OUT("TIMED_OUT"),
    CANCELED("CANCELED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobRunStatus> VALUE_MAP;
    private final String value;

    private JobRunStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobRunStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobRunStatus> knownValues() {
        EnumSet<JobRunStatus> knownValues = EnumSet.allOf(JobRunStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobRunStatus.class, JobRunStatus::toString);
    }
}

