/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GovernanceType {
    AWS_MANAGED("AWS_MANAGED"),
    USER_MANAGED("USER_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GovernanceType> VALUE_MAP;
    private final String value;

    private GovernanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GovernanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GovernanceType> knownValues() {
        EnumSet<GovernanceType> knownValues = EnumSet.allOf(GovernanceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GovernanceType.class, GovernanceType::toString);
    }
}

