/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.LakeFormationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisioningConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProvisioningConfiguration> {
    private static final SdkField<LakeFormationConfiguration> LAKE_FORMATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lakeFormationConfiguration").getter(ProvisioningConfiguration.getter(ProvisioningConfiguration::lakeFormationConfiguration)).setter(ProvisioningConfiguration.setter(Builder::lakeFormationConfiguration)).constructor(LakeFormationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakeFormationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAKE_FORMATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProvisioningConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LakeFormationConfiguration lakeFormationConfiguration;
    private final Type type;

    private ProvisioningConfiguration(BuilderImpl builder) {
        this.lakeFormationConfiguration = builder.lakeFormationConfiguration;
        this.type = builder.type;
    }

    public final LakeFormationConfiguration lakeFormationConfiguration() {
        return this.lakeFormationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lakeFormationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningConfiguration)) {
            return false;
        }
        ProvisioningConfiguration other = (ProvisioningConfiguration)obj;
        return Objects.equals(this.lakeFormationConfiguration(), other.lakeFormationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisioningConfiguration").add("LakeFormationConfiguration", (Object)this.lakeFormationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lakeFormationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lakeFormationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public static ProvisioningConfiguration fromLakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
        return (ProvisioningConfiguration)ProvisioningConfiguration.builder().lakeFormationConfiguration(lakeFormationConfiguration).build();
    }

    public static ProvisioningConfiguration fromLakeFormationConfiguration(Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
        LakeFormationConfiguration.Builder builder = LakeFormationConfiguration.builder();
        lakeFormationConfiguration.accept(builder);
        return ProvisioningConfiguration.fromLakeFormationConfiguration((LakeFormationConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<LakeFormationConfiguration>> map = new HashMap<String, SdkField<LakeFormationConfiguration>>();
        map.put("lakeFormationConfiguration", LAKE_FORMATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProvisioningConfiguration, T> g) {
        return obj -> g.apply((ProvisioningConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        LAKE_FORMATION_CONFIGURATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private LakeFormationConfiguration lakeFormationConfiguration;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningConfiguration model) {
            this.lakeFormationConfiguration(model.lakeFormationConfiguration);
        }

        public final LakeFormationConfiguration.Builder getLakeFormationConfiguration() {
            return this.lakeFormationConfiguration != null ? this.lakeFormationConfiguration.toBuilder() : null;
        }

        public final void setLakeFormationConfiguration(LakeFormationConfiguration.BuilderImpl lakeFormationConfiguration) {
            LakeFormationConfiguration oldValue = this.lakeFormationConfiguration;
            this.lakeFormationConfiguration = lakeFormationConfiguration != null ? lakeFormationConfiguration.build() : null;
            this.handleUnionValueChange(Type.LAKE_FORMATION_CONFIGURATION, oldValue, this.lakeFormationConfiguration);
        }

        @Override
        public final Builder lakeFormationConfiguration(LakeFormationConfiguration lakeFormationConfiguration) {
            LakeFormationConfiguration oldValue = this.lakeFormationConfiguration;
            this.lakeFormationConfiguration = lakeFormationConfiguration;
            this.handleUnionValueChange(Type.LAKE_FORMATION_CONFIGURATION, oldValue, this.lakeFormationConfiguration);
            return this;
        }

        public ProvisioningConfiguration build() {
            return new ProvisioningConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProvisioningConfiguration> {
        public Builder lakeFormationConfiguration(LakeFormationConfiguration var1);

        default public Builder lakeFormationConfiguration(Consumer<LakeFormationConfiguration.Builder> lakeFormationConfiguration) {
            return this.lakeFormationConfiguration((LakeFormationConfiguration)((LakeFormationConfiguration.Builder)LakeFormationConfiguration.builder().applyMutation(lakeFormationConfiguration)).build());
        }
    }
}

