/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetTypeIdentifiersCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.ProjectIdsCopier;
import software.amazon.awssdk.services.datazone.model.RuleAction;
import software.amazon.awssdk.services.datazone.model.RuleTargetType;
import software.amazon.awssdk.services.datazone.model.RuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRulesRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListRulesRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(ListRulesRequest.getter(ListRulesRequest::actionAsString)).setter(ListRulesRequest.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ruleAction").build()}).build();
    private static final SdkField<List<String>> ASSET_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetTypes").getter(ListRulesRequest.getter(ListRulesRequest::assetTypes)).setter(ListRulesRequest.setter(Builder::assetTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DATA_PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dataProduct").getter(ListRulesRequest.getter(ListRulesRequest::dataProduct)).setter(ListRulesRequest.setter(Builder::dataProduct)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dataProduct").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListRulesRequest.getter(ListRulesRequest::domainIdentifier)).setter(ListRulesRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CASCADED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeCascaded").getter(ListRulesRequest.getter(ListRulesRequest::includeCascaded)).setter(ListRulesRequest.setter(Builder::includeCascaded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeCascaded").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRulesRequest.getter(ListRulesRequest::maxResults)).setter(ListRulesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRulesRequest.getter(ListRulesRequest::nextToken)).setter(ListRulesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> PROJECT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectIds").getter(ListRulesRequest.getter(ListRulesRequest::projectIds)).setter(ListRulesRequest.setter(Builder::projectIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleType").getter(ListRulesRequest.getter(ListRulesRequest::ruleTypeAsString)).setter(ListRulesRequest.setter(Builder::ruleType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ruleType").build()}).build();
    private static final SdkField<String> TARGET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetIdentifier").getter(ListRulesRequest.getter(ListRulesRequest::targetIdentifier)).setter(ListRulesRequest.setter(Builder::targetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("targetIdentifier").build()}).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetType").getter(ListRulesRequest.getter(ListRulesRequest::targetTypeAsString)).setter(ListRulesRequest.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("targetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ASSET_TYPES_FIELD, DATA_PRODUCT_FIELD, DOMAIN_IDENTIFIER_FIELD, INCLUDE_CASCADED_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROJECT_IDS_FIELD, RULE_TYPE_FIELD, TARGET_IDENTIFIER_FIELD, TARGET_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRulesRequest.memberNameToFieldInitializer();
    private final String action;
    private final List<String> assetTypes;
    private final Boolean dataProduct;
    private final String domainIdentifier;
    private final Boolean includeCascaded;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> projectIds;
    private final String ruleType;
    private final String targetIdentifier;
    private final String targetType;

    private ListRulesRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.assetTypes = builder.assetTypes;
        this.dataProduct = builder.dataProduct;
        this.domainIdentifier = builder.domainIdentifier;
        this.includeCascaded = builder.includeCascaded;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.projectIds = builder.projectIds;
        this.ruleType = builder.ruleType;
        this.targetIdentifier = builder.targetIdentifier;
        this.targetType = builder.targetType;
    }

    public final RuleAction action() {
        return RuleAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasAssetTypes() {
        return this.assetTypes != null && !(this.assetTypes instanceof SdkAutoConstructList);
    }

    public final List<String> assetTypes() {
        return this.assetTypes;
    }

    public final Boolean dataProduct() {
        return this.dataProduct;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Boolean includeCascaded() {
        return this.includeCascaded;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProjectIds() {
        return this.projectIds != null && !(this.projectIds instanceof SdkAutoConstructList);
    }

    public final List<String> projectIds() {
        return this.projectIds;
    }

    public final RuleType ruleType() {
        return RuleType.fromValue(this.ruleType);
    }

    public final String ruleTypeAsString() {
        return this.ruleType;
    }

    public final String targetIdentifier() {
        return this.targetIdentifier;
    }

    public final RuleTargetType targetType() {
        return RuleTargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetTypes() ? this.assetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProduct());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeCascaded());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectIds() ? this.projectIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRulesRequest)) {
            return false;
        }
        ListRulesRequest other = (ListRulesRequest)((Object)obj);
        return Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasAssetTypes() == other.hasAssetTypes() && Objects.equals(this.assetTypes(), other.assetTypes()) && Objects.equals(this.dataProduct(), other.dataProduct()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.includeCascaded(), other.includeCascaded()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasProjectIds() == other.hasProjectIds() && Objects.equals(this.projectIds(), other.projectIds()) && Objects.equals(this.ruleTypeAsString(), other.ruleTypeAsString()) && Objects.equals(this.targetIdentifier(), other.targetIdentifier()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListRulesRequest").add("Action", (Object)this.actionAsString()).add("AssetTypes", this.hasAssetTypes() ? this.assetTypes() : null).add("DataProduct", (Object)this.dataProduct()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("IncludeCascaded", (Object)this.includeCascaded()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ProjectIds", this.hasProjectIds() ? this.projectIds() : null).add("RuleType", (Object)this.ruleTypeAsString()).add("TargetIdentifier", (Object)this.targetIdentifier()).add("TargetType", (Object)this.targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "assetTypes": {
                return Optional.ofNullable(clazz.cast(this.assetTypes()));
            }
            case "dataProduct": {
                return Optional.ofNullable(clazz.cast(this.dataProduct()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "includeCascaded": {
                return Optional.ofNullable(clazz.cast(this.includeCascaded()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "projectIds": {
                return Optional.ofNullable(clazz.cast(this.projectIds()));
            }
            case "ruleType": {
                return Optional.ofNullable(clazz.cast(this.ruleTypeAsString()));
            }
            case "targetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetIdentifier()));
            }
            case "targetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleAction", ACTION_FIELD);
        map.put("assetTypes", ASSET_TYPES_FIELD);
        map.put("dataProduct", DATA_PRODUCT_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("includeCascaded", INCLUDE_CASCADED_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectIds", PROJECT_IDS_FIELD);
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("targetIdentifier", TARGET_IDENTIFIER_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRulesRequest, T> g) {
        return obj -> g.apply((ListRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String action;
        private List<String> assetTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean dataProduct;
        private String domainIdentifier;
        private Boolean includeCascaded;
        private Integer maxResults;
        private String nextToken;
        private List<String> projectIds = DefaultSdkAutoConstructList.getInstance();
        private String ruleType;
        private String targetIdentifier;
        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRulesRequest model) {
            super(model);
            this.action(model.action);
            this.assetTypes(model.assetTypes);
            this.dataProduct(model.dataProduct);
            this.domainIdentifier(model.domainIdentifier);
            this.includeCascaded(model.includeCascaded);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.projectIds(model.projectIds);
            this.ruleType(model.ruleType);
            this.targetIdentifier(model.targetIdentifier);
            this.targetType(model.targetType);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final Collection<String> getAssetTypes() {
            if (this.assetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assetTypes;
        }

        public final void setAssetTypes(Collection<String> assetTypes) {
            this.assetTypes = AssetTypeIdentifiersCopier.copy(assetTypes);
        }

        @Override
        public final Builder assetTypes(Collection<String> assetTypes) {
            this.assetTypes = AssetTypeIdentifiersCopier.copy(assetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetTypes(String ... assetTypes) {
            this.assetTypes(Arrays.asList(assetTypes));
            return this;
        }

        public final Boolean getDataProduct() {
            return this.dataProduct;
        }

        public final void setDataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
        }

        @Override
        public final Builder dataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Boolean getIncludeCascaded() {
            return this.includeCascaded;
        }

        public final void setIncludeCascaded(Boolean includeCascaded) {
            this.includeCascaded = includeCascaded;
        }

        @Override
        public final Builder includeCascaded(Boolean includeCascaded) {
            this.includeCascaded = includeCascaded;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getProjectIds() {
            if (this.projectIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.projectIds;
        }

        public final void setProjectIds(Collection<String> projectIds) {
            this.projectIds = ProjectIdsCopier.copy(projectIds);
        }

        @Override
        public final Builder projectIds(Collection<String> projectIds) {
            this.projectIds = ProjectIdsCopier.copy(projectIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectIds(String ... projectIds) {
            this.projectIds(Arrays.asList(projectIds));
            return this;
        }

        public final String getRuleType() {
            return this.ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final String getTargetIdentifier() {
            return this.targetIdentifier;
        }

        public final void setTargetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
        }

        @Override
        public final Builder targetIdentifier(String targetIdentifier) {
            this.targetIdentifier = targetIdentifier;
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(RuleTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRulesRequest build() {
            return new ListRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRulesRequest> {
        public Builder action(String var1);

        public Builder action(RuleAction var1);

        public Builder assetTypes(Collection<String> var1);

        public Builder assetTypes(String ... var1);

        public Builder dataProduct(Boolean var1);

        public Builder domainIdentifier(String var1);

        public Builder includeCascaded(Boolean var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder projectIds(Collection<String> var1);

        public Builder projectIds(String ... var1);

        public Builder ruleType(String var1);

        public Builder ruleType(RuleType var1);

        public Builder targetIdentifier(String var1);

        public Builder targetType(String var1);

        public Builder targetType(RuleTargetType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

