/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AssetFilterConfiguration;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetFilterRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateAssetFilterRequest> {
    private static final SdkField<String> ASSET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetIdentifier").getter(CreateAssetFilterRequest.getter(CreateAssetFilterRequest::assetIdentifier)).setter(CreateAssetFilterRequest.setter(Builder::assetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetIdentifier").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAssetFilterRequest.getter(CreateAssetFilterRequest::clientToken)).setter(CreateAssetFilterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<AssetFilterConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateAssetFilterRequest.getter(CreateAssetFilterRequest::configuration)).setter(CreateAssetFilterRequest.setter(Builder::configuration)).constructor(AssetFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAssetFilterRequest.getter(CreateAssetFilterRequest::description)).setter(CreateAssetFilterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateAssetFilterRequest.getter(CreateAssetFilterRequest::domainIdentifier)).setter(CreateAssetFilterRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAssetFilterRequest.getter(CreateAssetFilterRequest::name)).setter(CreateAssetFilterRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_IDENTIFIER_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAssetFilterRequest.memberNameToFieldInitializer();
    private final String assetIdentifier;
    private final String clientToken;
    private final AssetFilterConfiguration configuration;
    private final String description;
    private final String domainIdentifier;
    private final String name;

    private CreateAssetFilterRequest(BuilderImpl builder) {
        super(builder);
        this.assetIdentifier = builder.assetIdentifier;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
    }

    public final String assetIdentifier() {
        return this.assetIdentifier;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final AssetFilterConfiguration configuration() {
        return this.configuration;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetFilterRequest)) {
            return false;
        }
        CreateAssetFilterRequest other = (CreateAssetFilterRequest)((Object)obj);
        return Objects.equals(this.assetIdentifier(), other.assetIdentifier()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssetFilterRequest").add("AssetIdentifier", (Object)this.assetIdentifier()).add("ClientToken", (Object)this.clientToken()).add("Configuration", (Object)this.configuration()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.assetIdentifier()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetIdentifier", ASSET_IDENTIFIER_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetFilterRequest, T> g) {
        return obj -> g.apply((CreateAssetFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String assetIdentifier;
        private String clientToken;
        private AssetFilterConfiguration configuration;
        private String description;
        private String domainIdentifier;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetFilterRequest model) {
            super(model);
            this.assetIdentifier(model.assetIdentifier);
            this.clientToken(model.clientToken);
            this.configuration(model.configuration);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.name(model.name);
        }

        public final String getAssetIdentifier() {
            return this.assetIdentifier;
        }

        public final void setAssetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
        }

        @Override
        public final Builder assetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AssetFilterConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AssetFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AssetFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetFilterRequest build() {
            return new CreateAssetFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetFilterRequest> {
        public Builder assetIdentifier(String var1);

        public Builder clientToken(String var1);

        public Builder configuration(AssetFilterConfiguration var1);

        default public Builder configuration(Consumer<AssetFilterConfiguration.Builder> configuration) {
            return this.configuration((AssetFilterConfiguration)((AssetFilterConfiguration.Builder)AssetFilterConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

