/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.ListingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateListingChangeSetResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, CreateListingChangeSetResponse> {
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingId").getter(CreateListingChangeSetResponse.getter(CreateListingChangeSetResponse::listingId)).setter(CreateListingChangeSetResponse.setter(Builder::listingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()}).build();
    private static final SdkField<String> LISTING_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listingRevision").getter(CreateListingChangeSetResponse.getter(CreateListingChangeSetResponse::listingRevision)).setter(CreateListingChangeSetResponse.setter(Builder::listingRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingRevision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateListingChangeSetResponse.getter(CreateListingChangeSetResponse::statusAsString)).setter(CreateListingChangeSetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTING_ID_FIELD, LISTING_REVISION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateListingChangeSetResponse.memberNameToFieldInitializer();
    private final String listingId;
    private final String listingRevision;
    private final String status;

    private CreateListingChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.listingId = builder.listingId;
        this.listingRevision = builder.listingRevision;
        this.status = builder.status;
    }

    public final String listingId() {
        return this.listingId;
    }

    public final String listingRevision() {
        return this.listingRevision;
    }

    public final ListingStatus status() {
        return ListingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.listingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListingChangeSetResponse)) {
            return false;
        }
        CreateListingChangeSetResponse other = (CreateListingChangeSetResponse)((Object)obj);
        return Objects.equals(this.listingId(), other.listingId()) && Objects.equals(this.listingRevision(), other.listingRevision()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateListingChangeSetResponse").add("ListingId", (Object)this.listingId()).add("ListingRevision", (Object)this.listingRevision()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "listingId": {
                return Optional.ofNullable(clazz.cast(this.listingId()));
            }
            case "listingRevision": {
                return Optional.ofNullable(clazz.cast(this.listingRevision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("listingId", LISTING_ID_FIELD);
        map.put("listingRevision", LISTING_REVISION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateListingChangeSetResponse, T> g) {
        return obj -> g.apply((CreateListingChangeSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String listingId;
        private String listingRevision;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListingChangeSetResponse model) {
            super(model);
            this.listingId(model.listingId);
            this.listingRevision(model.listingRevision);
            this.status(model.status);
        }

        public final String getListingId() {
            return this.listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingRevision() {
            return this.listingRevision;
        }

        public final void setListingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
        }

        @Override
        public final Builder listingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateListingChangeSetResponse build() {
            return new CreateListingChangeSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateListingChangeSetResponse> {
        public Builder listingId(String var1);

        public Builder listingRevision(String var1);

        public Builder status(String var1);

        public Builder status(ListingStatus var1);
    }
}

