/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintConfigurationItem;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintConfigurationsResponse;

public class ListEnvironmentBlueprintConfigurationsPublisher
implements SdkPublisher<ListEnvironmentBlueprintConfigurationsResponse> {
    private final DataZoneAsyncClient client;
    private final ListEnvironmentBlueprintConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentBlueprintConfigurationsPublisher(DataZoneAsyncClient client, ListEnvironmentBlueprintConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentBlueprintConfigurationsPublisher(DataZoneAsyncClient client, ListEnvironmentBlueprintConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentBlueprintConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentBlueprintConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentBlueprintConfigurationItem> items() {
        Function<ListEnvironmentBlueprintConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentBlueprintConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentBlueprintConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentBlueprintConfigurationsResponse> {
        private ListEnvironmentBlueprintConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentBlueprintConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentBlueprintConfigurationsResponse> nextPage(ListEnvironmentBlueprintConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentBlueprintConfigurationsPublisher.this.client.listEnvironmentBlueprintConfigurations(ListEnvironmentBlueprintConfigurationsPublisher.this.firstRequest);
            }
            return ListEnvironmentBlueprintConfigurationsPublisher.this.client.listEnvironmentBlueprintConfigurations((ListEnvironmentBlueprintConfigurationsRequest)((Object)ListEnvironmentBlueprintConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

